/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.form.support;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFormMultiSelectList
extends AbstractSwingXFormField<JPanel>
implements XFormOptionsField {
    private JList list;
    private DefaultListModel listModel;
    private List<Boolean> selected = new ArrayList<Boolean>();

    public XFormMultiSelectList(String[] values) {
        super(new JPanel(new BorderLayout()));
        this.listModel = new DefaultListModel();
        if (values != null) {
            for (String value : values) {
                this.selected.add(false);
                this.listModel.addElement(value);
            }
        }
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new CheckListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int index = XFormMultiSelectList.this.list.locationToIndex(e.getPoint());
                if (index != -1) {
                    XFormMultiSelectList.this.selected.set(index, (Boolean)XFormMultiSelectList.this.selected.get(index) == false);
                    XFormMultiSelectList.this.list.repaint();
                }
            }
        });
        ((JPanel)this.getComponent()).add((Component)new JScrollPane(this.list), "Center");
        ((JPanel)this.getComponent()).add(this.buildToolbar(), "South");
        ((JPanel)this.getComponent()).setSize(new Dimension(400, 120));
        ((JPanel)this.getComponent()).setMaximumSize(new Dimension(400, 120));
        ((JPanel)this.getComponent()).setPreferredSize(new Dimension(400, 120));
        ((JPanel)this.getComponent()).setMinimumSize(new Dimension(400, 120));
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(new JButton(new SelectAllAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(new JButton(new UnselectAllAction()));
        return toolbar;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.list.getSelectedValue());
    }

    @Override
    public void setValue(String value) {
        int index = this.listModel.indexOf(value);
        this.selected.set(index, true);
        this.list.setSelectedIndex(index);
    }

    @Override
    public void addItem(Object value) {
        this.listModel.addElement(value);
        this.selected.add(false);
    }

    @Override
    public Object[] getOptions() {
        Object[] options = new Object[this.listModel.size()];
        for (int c = 0; c < options.length; ++c) {
            options[c] = this.listModel.get(c);
        }
        return options;
    }

    @Override
    public Object[] getSelectedOptions() {
        ArrayList result = new ArrayList();
        for (int c = 0; c < this.selected.size(); ++c) {
            if (!this.selected.get(c).booleanValue()) continue;
            result.add(this.listModel.get(c));
        }
        return result.toArray();
    }

    @Override
    public void setOptions(Object[] values) {
        this.listModel.clear();
        this.selected.clear();
        for (Object value : values) {
            this.selected.add(false);
            this.listModel.addElement(value);
        }
    }

    @Override
    public void setSelectedOptions(Object[] options) {
        List<Object> asList = Arrays.asList(options);
        for (int c = 0; c < this.selected.size(); ++c) {
            this.selected.set(c, asList.contains(this.listModel.get(c)));
        }
        this.list.repaint();
    }

    @Override
    public int[] getSelectedIndexes() {
        int cnt = 0;
        for (int c = 0; c < this.selected.size(); ++c) {
            if (!this.selected.get(c).booleanValue()) continue;
            ++cnt;
        }
        int[] result = new int[cnt];
        cnt = 0;
        for (int c = 0; c < this.selected.size(); ++c) {
            if (!this.selected.get(c).booleanValue()) continue;
            result[cnt++] = c;
        }
        return result;
    }

    private class UnselectAllAction
    extends AbstractAction {
        public UnselectAllAction() {
            super("Unselect all");
            this.putValue("ShortDescription", "Unselects all items in the list");
        }

        public void actionPerformed(ActionEvent e) {
            XFormMultiSelectList.this.setSelectedOptions(new String[0]);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select all");
            this.putValue("ShortDescription", "Selects all items in the list");
        }

        public void actionPerformed(ActionEvent e) {
            XFormMultiSelectList.this.setSelectedOptions(XFormMultiSelectList.this.getOptions());
        }
    }

    public class CheckListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setSelected((Boolean)XFormMultiSelectList.this.selected.get(index));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

