/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceDialog;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.xml.actions.FormatXmlAction;
import com.eviware.soapui.support.xml.actions.LoadXmlTextAreaAction;
import com.eviware.soapui.support.xml.actions.SaveXmlTextAreaAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.syntax.jedit.InputHandler;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.tokenmarker.GroovyTokenMarker;
import org.syntax.jedit.tokenmarker.JavaScriptTokenMarker;
import org.syntax.jedit.tokenmarker.TSQLTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

public class JXEditTextArea
extends JEditTextArea
implements UndoableEditListener,
FocusListener,
FindAndReplaceable,
JEditorStatusBar.JEditorStatusBarTarget {
    public static final int UNDO_LIMIT = 1500;
    private UndoManager undoManager;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private FindAndReplaceDialog findAndReplaceAction;
    private boolean discardEditsOnSet = true;
    private GoToLineAction goToLineAction;
    private static ReferenceQueue<JXEditTextArea> testQueue = new ReferenceQueue();
    private static Map<WeakReference<JXEditTextArea>, InternalSettingsListener> testMap = new HashMap<WeakReference<JXEditTextArea>, InternalSettingsListener>();

    public static JXEditTextArea createXmlEditor(boolean addPopup) {
        JXEditTextArea editArea = new JXEditTextArea(new XMLTokenMarker());
        if (addPopup) {
            JPopupMenu inputPopup = new JPopupMenu();
            inputPopup.add(new FormatXmlAction(editArea));
            inputPopup.addSeparator();
            inputPopup.add(editArea.getUndoAction());
            inputPopup.add(editArea.getRedoAction());
            inputPopup.add(editArea.createCopyAction());
            inputPopup.add(editArea.createCutAction());
            inputPopup.add(editArea.createPasteAction());
            inputPopup.addSeparator();
            inputPopup.add(editArea.getFindAndReplaceAction());
            inputPopup.addSeparator();
            inputPopup.add(editArea.getGoToLineAction());
            inputPopup.addSeparator();
            inputPopup.add(new SaveXmlTextAreaAction(editArea, "Save Editor Content"));
            inputPopup.add(new LoadXmlTextAreaAction(editArea, "Load Editor Content"));
            editArea.setRightClickPopup(inputPopup);
        }
        return editArea;
    }

    public static JXEditTextArea createGroovyEditor() {
        return new JXEditTextArea(new GroovyTokenMarker());
    }

    public static JXEditTextArea createJavaScriptEditor() {
        return new JXEditTextArea(new JavaScriptTokenMarker());
    }

    public static JXEditTextArea createSqlEditor() {
        return new JXEditTextArea(new TSQLTokenMarker());
    }

    public JXEditTextArea(TokenMarker tokenMarker) {
        this.getPainter().setFont(UISupport.getEditorFont());
        this.getPainter().setLineHighlightColor(new Color(240, 240, 180));
        this.getPainter().setStyles(this.createXmlStyles());
        this.setTokenMarker(tokenMarker);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addFocusListener(this);
        this.undoAction = new UndoAction();
        this.getInputHandler().addKeyBinding("C+Z", this.undoAction);
        this.redoAction = new RedoAction();
        this.getInputHandler().addKeyBinding("C+Y", this.redoAction);
        this.findAndReplaceAction = new FindAndReplaceDialog(this);
        this.getInputHandler().addKeyBinding("C+F", this.findAndReplaceAction);
        this.getInputHandler().addKeyBinding("F3", this.findAndReplaceAction);
        this.getInputHandler().addKeyBinding("A+RIGHT", new NextElementValueAction());
        this.getInputHandler().addKeyBinding("A+LEFT", new PreviousElementValueAction());
        this.getInputHandler().addKeyBinding("C+D", new DeleteLineAction());
        this.getInputHandler().addKeyBinding("S+INSERT", this.createPasteAction());
        this.getInputHandler().addKeyBinding("S+DELETE", this.createCutAction());
        this.goToLineAction = new GoToLineAction();
        this.getInputHandler().addKeyBinding("CA+L", this.goToLineAction);
        this.setMinimumSize(new Dimension(50, 50));
        new InternalSettingsListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.getDocument().addUndoableEditListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.getDocument().removeUndoableEditListener(this);
    }

    public Action getFindAndReplaceAction() {
        return this.findAndReplaceAction;
    }

    public Action getGoToLineAction() {
        return this.goToLineAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public void setText(String text) {
        if (text != null && text.equals(this.getText())) {
            return;
        }
        super.setText(text == null ? "" : text);
        if (this.discardEditsOnSet && this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public boolean isDiscardEditsOnSet() {
        return this.discardEditsOnSet;
    }

    public void setDiscardEditsOnSet(boolean discardEditsOnSet) {
        this.discardEditsOnSet = discardEditsOnSet;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public SyntaxStyle[] createXmlStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[11];
        styles[1] = new SyntaxStyle(Color.black, true, false);
        styles[2] = new SyntaxStyle(new Color(0x990033), true, false);
        styles[6] = new SyntaxStyle(Color.blue, false, false);
        styles[7] = new SyntaxStyle(Color.magenta, false, false);
        styles[8] = new SyntaxStyle(new Color(38400), false, false);
        styles[3] = new SyntaxStyle(new Color(6619289), false, false);
        styles[4] = new SyntaxStyle(new Color(6619289), false, true);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }

    private void createUndoMananger() {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1500);
    }

    public void focusGained(FocusEvent fe) {
        if (this.isEditable() && this.undoManager == null) {
            this.createUndoMananger();
        }
    }

    public void setEnabledAndEditable(boolean flag) {
        super.setEnabled(flag);
        this.setEditable(flag);
    }

    public void setEditable(boolean enabled) {
        super.setEditable(enabled);
        this.setCaretVisible(enabled);
        this.getPainter().setLineHighlightEnabled(enabled);
        this.repaint();
    }

    public void focusLost(FocusEvent fe) {
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.undoManager != null) {
            this.undoManager.addEdit(e.getEdit());
        }
    }

    public Action createCopyAction() {
        return new InputHandler.clip_copy();
    }

    public void undo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.undoManager != null) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Action createCutAction() {
        return new InputHandler.clip_cut();
    }

    public Action createPasteAction() {
        return new InputHandler.clip_paste();
    }

    public int getCaretColumn() {
        int pos = this.getCaretPosition();
        int line = this.getLineOfOffset(pos);
        return pos - this.getLineStartOffset(line);
    }

    public void toNextElement() {
        String text = this.getText();
        for (int pos = this.getCaretPosition(); pos < text.length(); ++pos) {
            if (text.charAt(pos) != '>' || pos >= text.length() - 1 || pos <= 2 || text.substring(pos - 2, pos).equals("--") || pos <= 1 || text.charAt(pos - 1) == '/' || text.indexOf(47, pos) != text.indexOf(60, pos) + 1 || text.lastIndexOf(47, pos) == text.lastIndexOf(60, pos) + 1) continue;
            this.setCaretPosition(pos + 1);
            return;
        }
        this.getToolkit().beep();
    }

    public void toPreviousElement() {
        String text = this.getText();
        for (int pos = this.getCaretPosition() - 2; pos > 0; --pos) {
            if (text.charAt(pos) != '>' || pos >= text.length() - 1 || pos <= 2 || text.substring(pos - 2, pos).equals("--") || pos <= 1 || text.charAt(pos - 1) == '/' || text.indexOf(47, pos) != text.indexOf(60, pos) + 1 || text.lastIndexOf(47, pos) == text.lastIndexOf(60, pos) + 1) continue;
            this.setCaretPosition(pos + 1);
            return;
        }
        this.getToolkit().beep();
    }

    public boolean canUndo() {
        return this.undoManager != null && this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager != null && this.undoManager.canRedo();
    }

    public void redo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.canRedo()) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static {
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (testQueue == null) {
                                continue;
                            }
                            Reference ref = testQueue.remove();
                            InternalSettingsListener listener = (InternalSettingsListener)testMap.remove(ref);
                            if (listener == null) continue;
                            listener.release();
                        }
                    }
                    catch (InterruptedException e) {
                        SoapUI.logError(e);
                        continue;
                    }
                    break;
                }
            }
        }, "ReferenceQueueMonitor").start();
    }

    public class DeleteLineAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (!JXEditTextArea.this.isEditable()) {
                JXEditTextArea.this.getToolkit().beep();
                return;
            }
            int caretLine = JXEditTextArea.this.getCaretLine();
            if (caretLine == -1) {
                return;
            }
            int lineStartOffset = JXEditTextArea.this.getLineStartOffset(caretLine);
            int lineEndOffset = JXEditTextArea.this.getLineEndOffset(caretLine);
            try {
                int len = lineEndOffset - lineStartOffset;
                if (lineStartOffset + len >= JXEditTextArea.this.getDocumentLength()) {
                    len = JXEditTextArea.this.getDocumentLength() - lineStartOffset;
                }
                JXEditTextArea.this.getDocument().remove(lineStartOffset, len);
            }
            catch (BadLocationException e1) {
                SoapUI.logError(e1);
            }
        }
    }

    public class PreviousElementValueAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.toPreviousElement();
        }
    }

    public class NextElementValueAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.toNextElement();
        }
    }

    private final class GoToLineAction
    extends AbstractAction {
        public GoToLineAction() {
            super("Go To Line");
            this.putValue("ShortDescription", "Moves the caret to the specified line");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt L"));
        }

        public void actionPerformed(ActionEvent e) {
            String line = UISupport.prompt("Enter line-number to (1.." + JXEditTextArea.this.getLineCount() + ")", "Go To Line", String.valueOf(JXEditTextArea.this.getCaretLine() + 1));
            if (line != null) {
                try {
                    int ln = Integer.parseInt(line) - 1;
                    if (ln >= 0 && ln < JXEditTextArea.this.getLineCount()) {
                        JXEditTextArea.this.scrollTo(ln, 0);
                        JXEditTextArea.this.setCaretPosition(JXEditTextArea.this.getLineStartOffset(ln));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Y"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Z"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.undo();
        }
    }

    private static final class InternalSettingsListener
    implements SettingsListener {
        private WeakReference<JXEditTextArea> textArea;

        public InternalSettingsListener(JXEditTextArea area) {
            this.textArea = new WeakReference<JXEditTextArea>(area, testQueue);
            testMap.put(this.textArea, this);
            SoapUI.getSettings().addSettingsListener(this);
        }

        public void release() {
            if (this.textArea.get() == null) {
                SoapUI.getSettings().removeSettingsListener(this);
            } else {
                System.err.println("Error, cannot release listener");
            }
        }

        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(UISettings.EDITOR_FONT) && this.textArea.get() != null) {
                ((JXEditTextArea)this.textArea.get()).getPainter().setFont(Font.decode(newValue));
                ((JXEditTextArea)this.textArea.get()).invalidate();
            }
        }
    }
}

