/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class JLogList
extends JPanel {
    private long maxRows = 1000L;
    private JList logList;
    private SimpleAttributeSet requestAttributes;
    private SimpleAttributeSet responseAttributes;
    private LogListModel model;
    private List<Logger> loggers = new ArrayList<Logger>();
    private InternalLogAppender internalLogAppender = new InternalLogAppender();
    private boolean tailing = true;
    private Stack<Object> linesToAdd = new Stack();
    private EnableAction enableAction;
    private JCheckBoxMenuItem enableMenuItem;
    private final String title;
    private boolean released;
    private Future<?> future;

    public JLogList(String title) {
        super(new BorderLayout());
        this.title = title;
        this.model = new LogListModel();
        this.logList = new JList(this.model);
        this.logList.setToolTipText(title);
        this.logList.setCellRenderer(new LogAreaCellRenderer());
        this.logList.setPrototypeCellValue("Testing 123");
        this.logList.setFixedCellWidth(-1);
        JPopupMenu listPopup = new JPopupMenu();
        listPopup.add(new ClearAction());
        this.enableAction = new EnableAction();
        this.enableMenuItem = new JCheckBoxMenuItem(this.enableAction);
        this.enableMenuItem.setSelected(true);
        listPopup.add(this.enableMenuItem);
        listPopup.addSeparator();
        listPopup.add(new CopyAction());
        listPopup.add(new SetMaxRowsAction());
        listPopup.addSeparator();
        listPopup.add(new ExportToFileAction());
        this.logList.setComponentPopupMenu(listPopup);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JScrollPane scrollPane = new JScrollPane(this.logList);
        UISupport.addPreviewCorner(scrollPane, true);
        this.add((Component)scrollPane, "Center");
        this.requestAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.requestAttributes, Color.BLUE);
        this.responseAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.responseAttributes, Color.GREEN);
        try {
            this.maxRows = Long.parseLong(SoapUI.getSettings().getString("JLogList#" + title, "1000"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void clear() {
        this.model.clear();
    }

    public JList getLogList() {
        return this.logList;
    }

    public long getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    public synchronized void addLine(Object line) {
        if (!this.isEnabled()) {
            return;
        }
        if (line instanceof LoggingEvent) {
            LoggingEvent ev = (LoggingEvent)line;
            this.linesToAdd.push(new LoggingEventWrapper(ev));
            if (ev.getThrowableInformation() != null) {
                Throwable t = ev.getThrowableInformation().getThrowable();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                StringTokenizer st = new StringTokenizer(sw.toString(), "\r\n");
                while (st.hasMoreElements()) {
                    this.linesToAdd.push("   " + st.nextElement());
                }
            }
        } else {
            this.linesToAdd.push(line);
        }
        if (this.future == null) {
            this.released = false;
            this.future = SoapUI.getThreadPool().submit(this.model);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.logList.setEnabled(enabled);
        this.enableMenuItem.setSelected(enabled);
    }

    public void addLogger(String loggerName, boolean addAppender) {
        Logger logger = Logger.getLogger((String)loggerName);
        if (addAppender) {
            logger.addAppender((Appender)this.internalLogAppender);
        }
        this.loggers.add(logger);
    }

    public Logger[] getLoggers() {
        return this.loggers.toArray(new Logger[this.loggers.size()]);
    }

    public void setLevel(Level level) {
        for (Logger logger : this.loggers) {
            logger.setLevel(level);
        }
    }

    public Logger getLogger(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!logger.getName().equals(loggerName)) continue;
            return logger;
        }
        return null;
    }

    public boolean monitors(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!loggerName.startsWith(logger.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeLogger(String loggerName) {
        for (Logger logger : this.loggers) {
            if (!loggerName.equals(logger.getName())) continue;
            logger.removeAppender((Appender)this.internalLogAppender);
        }
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tail) {
        this.tailing = tail;
    }

    public void release() {
        this.released = true;
    }

    public void saveToFile(File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            for (int c = 0; c < this.model.getSize(); ++c) {
                writer.println(this.model.getElementAt(c));
            }
            writer.close();
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private final class LogListModel
    extends AbstractListModel
    implements Runnable {
        private List<Object> lines = new LinkedList<Object>();

        private LogListModel() {
        }

        public int getSize() {
            return this.lines.size();
        }

        public Object getElementAt(int index) {
            return this.lines.get(index);
        }

        public void clear() {
            int sz = this.lines.size();
            if (sz == 0) {
                return;
            }
            this.lines.clear();
            this.fireIntervalRemoved(this, 0, sz - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("LogList Updater for " + JLogList.this.title);
            try {
                while (!JLogList.this.released && !JLogList.this.linesToAdd.isEmpty()) {
                    try {
                        if (!JLogList.this.linesToAdd.isEmpty()) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    try {
                                        while (!JLogList.this.linesToAdd.isEmpty()) {
                                            int sz = LogListModel.this.lines.size();
                                            LogListModel.this.lines.addAll(JLogList.this.linesToAdd);
                                            JLogList.this.linesToAdd.clear();
                                            LogListModel.this.fireIntervalAdded(LogListModel.this, sz, LogListModel.this.lines.size() - sz);
                                        }
                                        int cnt = 0;
                                        while ((long)LogListModel.this.lines.size() > JLogList.this.maxRows) {
                                            LogListModel.this.lines.remove(0);
                                            ++cnt;
                                        }
                                        if (cnt > 0) {
                                            LogListModel.this.fireIntervalRemoved(LogListModel.this, 0, cnt - 1);
                                        }
                                        if (JLogList.this.tailing) {
                                            JLogList.this.logList.ensureIndexIsVisible(LogListModel.this.lines.size() - 1);
                                        }
                                    }
                                    catch (Throwable e) {
                                        SoapUI.logError(e);
                                    }
                                }
                            });
                        }
                        Thread.sleep(500L);
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                }
            }
            finally {
                JLogList.this.future = null;
            }
        }
    }

    private class EnableAction
    extends AbstractAction {
        public EnableAction() {
            super("Enable");
        }

        public void actionPerformed(ActionEvent e) {
            JLogList.this.setEnabled(JLogList.this.enableMenuItem.isSelected());
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy to clipboard");
        }

        public void actionPerformed(ActionEvent e) {
            int c;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuffer buf = new StringBuffer();
            int[] selectedIndices = JLogList.this.logList.getSelectedIndices();
            if (selectedIndices.length == 0) {
                for (c = 0; c < JLogList.this.logList.getModel().getSize(); ++c) {
                    buf.append(JLogList.this.logList.getModel().getElementAt(c).toString());
                    buf.append("\r\n");
                }
            } else {
                for (c = 0; c < selectedIndices.length; ++c) {
                    buf.append(JLogList.this.logList.getModel().getElementAt(selectedIndices[c]).toString());
                    buf.append("\r\n");
                }
            }
            StringSelection selection = new StringSelection(buf.toString());
            clipboard.setContents(selection, selection);
        }
    }

    private class ExportToFileAction
    extends AbstractAction {
        public ExportToFileAction() {
            super("Export to File");
        }

        public void actionPerformed(ActionEvent e) {
            if (JLogList.this.model.getSize() == 0) {
                UISupport.showErrorMessage("Log is empty; nothing to export");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(JLogList.this, "Save Log [] to File", "*.log", "*.log", null);
            if (file != null) {
                JLogList.this.saveToFile(file);
            }
        }
    }

    private class SetMaxRowsAction
    extends AbstractAction {
        public SetMaxRowsAction() {
            super("Set Max Rows");
        }

        public void actionPerformed(ActionEvent e) {
            String val = UISupport.prompt("Set maximum number of log rows to keep", "Set Max Rows", String.valueOf(JLogList.this.maxRows));
            if (val != null) {
                try {
                    JLogList.this.maxRows = Long.parseLong(val);
                    SoapUI.getSettings().setString("JLogList#" + JLogList.this.title, val);
                }
                catch (NumberFormatException e1) {
                    UISupport.beep();
                }
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            JLogList.this.model.clear();
        }
    }

    private class InternalLogAppender
    extends AppenderSkeleton {
        private InternalLogAppender() {
        }

        protected void append(LoggingEvent event) {
            JLogList.this.addLine(event);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    private static final class LoggingEventWrapper {
        private final LoggingEvent loggingEvent;
        private String str;

        public LoggingEventWrapper(LoggingEvent loggingEvent) {
            this.loggingEvent = loggingEvent;
        }

        public Level getLevel() {
            return this.loggingEvent.getLevel();
        }

        public String toString() {
            if (this.str == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(new Date(this.loggingEvent.timeStamp));
                builder.append(':').append(this.loggingEvent.getLevel()).append(':').append(this.loggingEvent.getMessage());
                this.str = builder.toString();
            }
            return this.str;
        }
    }

    private static class LogAreaCellRenderer
    extends DefaultListCellRenderer {
        private Map<Level, Color> levelColors = new HashMap<Level, Color>();

        private LogAreaCellRenderer() {
            this.levelColors.put(Level.ERROR, new Color(192, 0, 0));
            this.levelColors.put(Level.INFO, new Color(0, 92, 0));
            this.levelColors.put(Level.WARN, Color.ORANGE.darker().darker());
            this.levelColors.put(Level.DEBUG, new Color(0, 0, 128));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String toolTip;
            LoggingEventWrapper eventWrapper;
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LoggingEventWrapper && this.levelColors.containsKey((eventWrapper = (LoggingEventWrapper)value).getLevel())) {
                component.setForeground(this.levelColors.get(eventWrapper.getLevel()));
            }
            if ((toolTip = component.getText()) != null && toolTip.length() > 1000) {
                toolTip = toolTip.substring(0, 1000);
            }
            component.setToolTipText(toolTip);
            return component;
        }
    }
}

