/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.jnlp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class WebstartUtil {
    protected static String createWebStartDirectory(String name, String jarUrl) throws IOException {
        String deploymentUserTmp = System.getProperty("deployment.user.tmp");
        JarFile jar = WebstartUtil.getJar(jarUrl);
        String dir = WebstartUtil.createDirectory(deploymentUserTmp, name);
        WebstartUtil.extract(jar, dir);
        return dir;
    }

    private static void extract(JarFile jar, String dir) throws IOException, FileNotFoundException {
        WebstartUtil.makeDirectories(jar, dir);
        WebstartUtil.extractFiles(jar, dir);
    }

    private static void extractFiles(JarFile jar, String eviwareDir) throws IOException, FileNotFoundException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry file = entries.nextElement();
            File f = new File(eviwareDir + File.separator + file.getName());
            if (file.isDirectory()) continue;
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }

    private static void makeDirectories(JarFile jar, String eviwareDir) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry file = entries.nextElement();
            File f = new File(eviwareDir + File.separator + file.getName());
            if (!file.isDirectory()) continue;
            f.mkdir();
        }
    }

    private static JarFile getJar(String jarUrl) throws MalformedURLException, IOException {
        URL url = new URL("jar:" + jarUrl + "!/");
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        JarFile jar = jarConnection.getJarFile();
        return jar;
    }

    private static String createDirectory(String deploymentUserTmp, String folderName) {
        File folder = new File(deploymentUserTmp + File.separator + folderName);
        folder.mkdir();
        return folder.getAbsolutePath();
    }

    protected static boolean isWebStart() {
        String webstart = System.getProperty("com.eviware.soapui.webstart", "false");
        return "true".equalsIgnoreCase(webstart);
    }
}

