/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.jdbc;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JdbcUtils {
    public static final String PASS_TEMPLATE = "PASS_VALUE";

    public static Connection initConnection(PropertyExpansionContext context, String driver, String connectionString, String password) throws SQLException, SoapUIException {
        if (JdbcUtils.missingConnSettings(driver, connectionString, password)) {
            throw new SoapUIException("Some connections settings are missing");
        }
        String drvr = PropertyExpander.expandProperties(context, driver).trim();
        String connStr = PropertyExpander.expandProperties(context, connectionString).trim();
        String pass = StringUtils.hasContent(password) ? PropertyExpander.expandProperties(context, password).trim() : "";
        String masskedPass = connStr.replace(PASS_TEMPLATE, "#####");
        if (connStr.contains(PASS_TEMPLATE)) {
            connStr = connStr.replaceFirst(PASS_TEMPLATE, pass);
        }
        try {
            DriverManager.getDriver(connStr);
        }
        catch (SQLException e) {
            SoapUI.logError(e);
            try {
                Class.forName(drvr).newInstance();
            }
            catch (Exception e1) {
                SoapUI.logError(e);
                throw new SoapUIException("Failed to init connection for drvr [" + drvr + "], connectionString [" + masskedPass + "]");
            }
        }
        return DriverManager.getConnection(connStr);
    }

    public static boolean hasMasskedPass(String connStr) {
        return !StringUtils.isNullOrEmpty(connStr) ? connStr.contains(PASS_TEMPLATE) : false;
    }

    public static boolean missingConnSettings(String driver, String connectionString, String password) {
        return StringUtils.isNullOrEmpty(driver) || StringUtils.isNullOrEmpty(connectionString) || connectionString.contains(PASS_TEMPLATE) && StringUtils.isNullOrEmpty(password);
    }
}

