/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views.xml.source;

import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wadl.support.WadlValidator;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.AddWsaHeadersToMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.ApplyOutgoingWSSToMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.RemoveAllOutgoingWSSFromMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.RemoveWsaHeadersFromMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSSUsernameTokenAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSTimestampAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWsaHeadersToRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.ApplyOutgoingWSSToRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RemoveAllOutgoingWSSFromRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RemoveWsaHeadersFromRequestAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResultMessageExchange;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.RestResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.registry.RequestEditorViewFactory;
import com.eviware.soapui.support.editor.registry.ResponseEditorViewFactory;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.editor.xml.XmlEditorView;
import com.eviware.soapui.support.editor.xml.support.ValidationError;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSourceEditorViewFactory
implements ResponseEditorViewFactory,
RequestEditorViewFactory {
    public static final String VIEW_ID = "Source";

    public XmlEditorView createEditorView(XmlEditor editor) {
        return new XmlSourceEditorView<Object>(editor, null);
    }

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    @Override
    public EditorView<?> createRequestEditorView(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlRequest) {
            return new WsdlRequestXmlSourceEditor((XmlEditor)editor, (WsdlRequest)modelItem);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockRequestXmlSourceEditor((XmlEditor)editor, (WsdlMockResponse)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new XmlSourceEditorView<MessageExchangeModelItem>((XmlEditor)editor, (MessageExchangeModelItem)modelItem);
        }
        return null;
    }

    @Override
    public EditorView<?> createResponseEditorView(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlRequest) {
            return new WsdlResponseXmlSourceEditor((XmlEditor)editor, (WsdlRequest)modelItem);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockResponseXmlSourceEditor((XmlEditor)editor, (WsdlMockResponse)modelItem);
        }
        if (modelItem instanceof HttpRequestInterface) {
            return new RestResponseXmlSourceEditor((XmlEditor)editor, (HttpRequestInterface)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new XmlSourceEditorView<MessageExchangeModelItem>((XmlEditor)editor, (MessageExchangeModelItem)modelItem);
        }
        if (modelItem instanceof JdbcRequestTestStep) {
            return new XmlSourceEditorView<JdbcRequestTestStep>((XmlEditor)editor, (JdbcRequestTestStep)modelItem);
        }
        if (modelItem instanceof AMFRequestTestStep) {
            return new XmlSourceEditorView<AMFRequestTestStep>((XmlEditor)editor, (AMFRequestTestStep)modelItem);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RestResponseXmlSourceEditor
    extends XmlSourceEditorView<HttpRequestInterface<?>> {
        public RestResponseXmlSourceEditor(XmlEditor<XmlDocument> xmlEditor, HttpRequestInterface<?> restRequest) {
            super(xmlEditor, restRequest);
        }

        @Override
        protected ValidationError[] validateXml(String xml) {
            if (this.getModelItem() instanceof HttpRequestInterface || ((RestRequestInterface)this.getModelItem()).getResource() == null) {
                return new ValidationError[0];
            }
            WadlValidator validator = new WadlValidator(((RestRequestInterface)this.getModelItem()).getResource().getService().getWadlContext());
            return validator.assertResponse(new RestResponseMessageExchange((RestRequest)this.getModelItem()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WsdlMockResponseXmlSourceEditor
    extends XmlSourceEditorView<WsdlMockResponse> {
        private JMenu applyMenu;
        private JMenu wsaApplyMenu;

        public WsdlMockResponseXmlSourceEditor(XmlEditor xmlEditor, WsdlMockResponse mockResponse) {
            super(xmlEditor, mockResponse);
        }

        @Override
        protected void buildUI() {
            super.buildUI();
            this.getValidateXmlAction().setEnabled(((WsdlMockResponse)this.getModelItem()).getMockOperation().getOperation().isBidirectional());
        }

        @Override
        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = ((WsdlMockResponse)this.getModelItem()).getMockOperation().getOperation();
            if (operation == null) {
                return new ValidationError[]{new AssertionError("Missing operation for MockResponse")};
            }
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertResponse(new WsdlMockResponseMessageExchange((WsdlMockResponse)this.getModelItem()), false);
        }

        public WsdlMockResponse getMockResponse() {
            return (WsdlMockResponse)this.getModelItem();
        }

        @Override
        protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
            super.buildPopup(inputPopup, editArea);
            this.applyMenu = new JMenu("Outgoing WSS");
            inputPopup.insert(this.applyMenu, 2);
            this.wsaApplyMenu = new JMenu("WS-A headers");
            inputPopup.insert(this.wsaApplyMenu, 3);
            inputPopup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    WsdlMockResponseXmlSourceEditor.this.applyMenu.removeAll();
                    DefaultWssContainer wss = ((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem()).getMockOperation().getMockService().getProject().getWssContainer();
                    List<OutgoingWss> outgoingWssList = wss.getOutgoingWssList();
                    WsdlMockResponseXmlSourceEditor.this.applyMenu.setEnabled(!outgoingWssList.isEmpty());
                    for (OutgoingWss outgoing : outgoingWssList) {
                        WsdlMockResponseXmlSourceEditor.this.applyMenu.add(new ApplyOutgoingWSSToMockResponseAction((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem(), outgoing));
                    }
                    WsdlMockResponseXmlSourceEditor.this.applyMenu.add(new RemoveAllOutgoingWSSFromMockResponseAction((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem()));
                    WsdlMockResponseXmlSourceEditor.this.wsaApplyMenu.removeAll();
                    WsdlMockResponseXmlSourceEditor.this.wsaApplyMenu.add(new AddWsaHeadersToMockResponseAction((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem()));
                    WsdlMockResponseXmlSourceEditor.this.wsaApplyMenu.add(new RemoveWsaHeadersFromMockResponseAction((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem()));
                    WsdlMockResponseXmlSourceEditor.this.wsaApplyMenu.setEnabled(((WsdlMockResponse)WsdlMockResponseXmlSourceEditor.this.getModelItem()).getWsaConfig().isWsaEnabled());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WsdlResponseXmlSourceEditor
    extends XmlSourceEditorView<WsdlRequest> {
        public WsdlResponseXmlSourceEditor(XmlEditor xmlEditor, WsdlRequest request) {
            super(xmlEditor, request);
        }

        @Override
        protected ValidationError[] validateXml(String xml) {
            if (this.getModelItem() instanceof WsdlTestRequest) {
                WsdlTestRequest testRequest = (WsdlTestRequest)this.getModelItem();
                testRequest.assertResponse(new WsdlTestRunContext(testRequest.getTestStep()));
            }
            WsdlOperation operation = ((WsdlRequest)this.getModelItem()).getOperation();
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertResponse(new WsdlResponseMessageExchange((WsdlRequest)this.getModelItem()), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WsdlMockRequestXmlSourceEditor
    extends XmlSourceEditorView<WsdlMockResponse> {
        public WsdlMockRequestXmlSourceEditor(XmlEditor xmlEditor, WsdlMockResponse mockResponse) {
            super(xmlEditor, mockResponse);
        }

        @Override
        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = ((WsdlMockResponse)this.getModelItem()).getMockOperation().getOperation();
            if (operation == null) {
                return new ValidationError[]{new AssertionError("Missing operation for MockResponse")};
            }
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertRequest(new WsdlMockResultMessageExchange(((WsdlMockResponse)this.getModelItem()).getMockResult(), (WsdlMockResponse)this.getModelItem()), false);
        }

        @Override
        protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
            super.buildPopup(inputPopup, editArea);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WsdlRequestXmlSourceEditor
    extends XmlSourceEditorView<WsdlRequest> {
        private JMenu applyMenu;
        private JMenu wsaApplyMenu;

        public WsdlRequestXmlSourceEditor(XmlEditor xmlEditor, WsdlRequest request) {
            super(xmlEditor, request);
        }

        @Override
        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = ((WsdlRequest)this.getModelItem()).getOperation();
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            WsdlResponseMessageExchange wsdlResponseMessageExchange = new WsdlResponseMessageExchange((WsdlRequest)this.getModelItem());
            wsdlResponseMessageExchange.setRequestContent(xml);
            return validator.assertRequest(wsdlResponseMessageExchange, false);
        }

        @Override
        protected void buildUI() {
            super.buildUI();
            PropertyExpansionPopupListener.enable(this.getInputArea(), this.getModelItem());
        }

        @Override
        protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
            super.buildPopup(inputPopup, editArea);
            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(new AddWSSUsernameTokenAction((WsdlRequest)this.getModelItem()), 3);
            inputPopup.insert(new AddWSTimestampAction((WsdlRequest)this.getModelItem()), 4);
            this.applyMenu = new JMenu("Outgoing WSS");
            inputPopup.insert(this.applyMenu, 5);
            this.wsaApplyMenu = new JMenu("WS-A headers");
            inputPopup.insert(this.wsaApplyMenu, 6);
            inputPopup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    WsdlRequestXmlSourceEditor.this.applyMenu.removeAll();
                    DefaultWssContainer wss = ((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem()).getOperation().getInterface().getProject().getWssContainer();
                    List<OutgoingWss> outgoingWssList = wss.getOutgoingWssList();
                    WsdlRequestXmlSourceEditor.this.applyMenu.setEnabled(!outgoingWssList.isEmpty());
                    for (OutgoingWss outgoing : outgoingWssList) {
                        WsdlRequestXmlSourceEditor.this.applyMenu.add(new ApplyOutgoingWSSToRequestAction((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem(), outgoing));
                    }
                    WsdlRequestXmlSourceEditor.this.applyMenu.add(new RemoveAllOutgoingWSSFromRequestAction((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem()));
                    WsdlRequestXmlSourceEditor.this.wsaApplyMenu.removeAll();
                    WsdlRequestXmlSourceEditor.this.wsaApplyMenu.add(new AddWsaHeadersToRequestAction((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem()));
                    WsdlRequestXmlSourceEditor.this.wsaApplyMenu.add(new RemoveWsaHeadersFromRequestAction((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem()));
                    WsdlRequestXmlSourceEditor.this.wsaApplyMenu.setEnabled(((WsdlRequest)WsdlRequestXmlSourceEditor.this.getModelItem()).getWsaConfig().isWsaEnabled());
                }
            });
        }

        public WsdlRequest getRequest() {
            return (WsdlRequest)this.getModelItem();
        }
    }
}

