/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.wsrm;

import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.support.wsmc.WsmcInjection;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmContainer;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmSequence;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmUtils;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.wsrm.AbstractWsrmInspector;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class WsdlRequestWsrmInspector
extends AbstractWsrmInspector
implements XmlInspector,
PropertyChangeListener,
SubmitListener {
    private final WsdlRequest request;

    public WsdlRequestWsrmInspector(WsdlRequest request) {
        super(request);
        request.addSubmitListener(this);
        this.request = request;
    }

    public void buildContent(SimpleBindingForm form) {
        form.addSpace(5);
        form.appendCheckBox("wsrmEnabled", "Enable WS-Reliable Messaging", "Enable/Disable WS-Reliable Messaging");
        form.addSpace(5);
        form.appendComboBox("version", "WS-RM Version", new String[]{WsrmVersionTypeConfig.X_1_0.toString(), WsrmVersionTypeConfig.X_1_1.toString(), WsrmVersionTypeConfig.X_1_2.toString()}, "The  property for managing WS-RM version");
        form.appendTextField("ackTo", "Acknowledgment to", "The acknowledgment endpoint reference, will be generated if left empty");
        form.addSpace(5);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public void afterSubmit(Submit submit, SubmitContext context) {
        WsrmContainer container = (WsrmContainer)((Object)submit.getRequest());
        if (this.request.getWsrmConfig().isWsrmEnabled() && submit.getResponse() != null) {
            String content = submit.getResponse().getContentAsString();
            XmlOptions options = new XmlOptions();
            try {
                XmlObject xml = XmlObject.Factory.parse((String)content);
                String namespaceDeclaration = "declare namespace wsrm='" + this.request.getWsrmConfig().getVersionNameSpace() + "';";
                XmlObject[] result = xml.selectPath(namespaceDeclaration + "//wsrm:AcknowledgementRange", options);
                if (result.length > 0) {
                    for (int i = 0; i < result.length; ++i) {
                        String upper = result[i].selectAttribute(null, "Upper").getDomNode().getNodeValue();
                        String lower = result[i].selectAttribute(null, "Lower").getDomNode().getNodeValue();
                        if (lower == upper) {
                            Logger.getLogger((String)"wsrm").info((Object)("Acknowledgment for message " + upper + " received for identifier: " + this.request.getWsrmConfig().getSequenceIdentifier()));
                            continue;
                        }
                        Logger.getLogger((String)"wsrm").info((Object)("Acknowledgment for messages " + lower + " to " + upper + " received for identifier: " + this.request.getWsrmConfig().getSequenceIdentifier()));
                    }
                }
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
        if (container.getWsrmConfig().isWsrmEnabled()) {
            WsdlInterface iface = this.request.getOperation().getInterface();
            WsrmUtils utils = new WsrmUtils(iface.getSoapVersion());
            utils.closeSequence(this.request.getEndpoint(), iface.getSoapVersion(), this.request.getWsrmConfig().getVersionNameSpace(), this.request.getWsrmConfig().getUuid(), this.request.getWsrmConfig().getSequenceIdentifier(), 1L, this.request.getOperation());
        }
    }

    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        WsrmContainer container = (WsrmContainer)((Object)submit.getRequest());
        if (container.getWsrmConfig().isWsrmEnabled()) {
            WsdlInterface iface = this.request.getOperation().getInterface();
            WsrmUtils utils = new WsrmUtils(iface.getSoapVersion());
            WsrmSequence sequence = utils.createSequence(this.request.getEndpoint(), iface.getSoapVersion(), this.request.getWsrmConfig().getVersionNameSpace(), this.request.getWsrmConfig().getAckTo(), 0L, this.request.getOperation(), ((WsdlRequest)submit.getRequest()).getWsaConfig().getTo());
            this.request.getWsrmConfig().setSequenceIdentifier(sequence.getIdentifier());
            this.request.getWsrmConfig().setUuid(sequence.getUuid());
            if (this.request.getWsrmConfig().getVersion() != WsrmVersionTypeConfig.X_1_0.toString()) {
                WsmcInjection receiveInjection = new WsmcInjection(this.request.getEndpoint(), this.request.getOperation(), iface.getSoapVersion(), this.request.getWsrmConfig().getUuid());
                this.request.setAfterRequestInjection(receiveInjection);
            }
        }
        return true;
    }
}

