/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.httpheaders;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.httpheaders.HttpHeadersInspectorModel;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private StringToStringMapTableModel headersTableModel;
    private final HttpHeadersInspectorModel model;
    private JTable headersTable;
    private JPanel panel;
    private JButton removeButton;
    public boolean changing;

    protected HttpHeadersInspector(HttpHeadersInspectorModel model) {
        super("Headers (" + (model.getHeaders() == null ? "0" : Integer.valueOf(model.getHeaders().size())) + ")", "Additional HTTP Headers for this message", true, "HTTP Headers");
        this.model = model;
        model.setInspector(this);
        model.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.headersTableModel = new StringToStringMapTableModel(this.model.getHeaders(), "Header", "Value", !this.model.isReadOnly());
        this.headersTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                HttpHeadersInspector.this.model.setHeaders(HttpHeadersInspector.this.headersTableModel.getData());
                HttpHeadersInspector.this.setTitle("Headers (" + (HttpHeadersInspector.this.model.getHeaders() == null ? "0" : Integer.valueOf(HttpHeadersInspector.this.model.getHeaders().size())) + ")");
            }
        });
        this.headersTable = new JTable(this.headersTableModel);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.headersTable), "Center");
        if (!this.model.isReadOnly()) {
            this.headersTable.setSurrendersFocusOnKeystroke(true);
            this.headersTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            JXToolBar builder = UISupport.createSmallToolbar();
            builder.addFixed(UISupport.createToolbarButton(new AddAction()));
            this.removeButton = UISupport.createToolbarButton(new RemoveAction());
            builder.addFixed(this.removeButton);
            builder.addGlue();
            builder.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/requests.html#HTTP_Headers")));
            this.panel.add((Component)builder, "North");
            this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    HttpHeadersInspector.this.removeButton.setEnabled(HttpHeadersInspector.this.headersTable.getSelectedRow() != -1);
                }
            });
            if (this.headersTable.getRowCount() > 0) {
                this.headersTable.setRowSelectionInterval(0, 0);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        return this.panel;
    }

    public JTable getHeadersTable() {
        return this.headersTable;
    }

    @Override
    public void release() {
        super.release();
        this.model.release();
        this.model.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changing) {
            this.headersTableModel.setData(this.model.getHeaders());
        }
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    private final class AddAction
    extends AbstractAction {
        private AddAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a custom HTTP Header to this message");
        }

        public void actionPerformed(ActionEvent arg0) {
            String header = UISupport.prompt("Specify name of header to add", "Add HTTP Header", "");
            if (header != null) {
                HttpHeadersInspector.this.changing = true;
                HttpHeadersInspector.this.headersTableModel.add(header.toString(), "");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int row = HttpHeadersInspector.this.headersTable.getRowCount() - 1;
                        HttpHeadersInspector.this.headersTable.scrollRectToVisible(HttpHeadersInspector.this.headersTable.getCellRect(row, 1, true));
                        HttpHeadersInspector.this.headersTable.setRowSelectionInterval(row, row);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                HttpHeadersInspector.this.headersTable.editCellAt(HttpHeadersInspector.this.headersTable.getRowCount() - 1, 1);
                                HttpHeadersInspector.this.headersTable.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    }
                });
                HttpHeadersInspector.this.changing = false;
            }
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected custom HTTP Header from this message");
        }

        public void actionPerformed(ActionEvent arg0) {
            int row = HttpHeadersInspector.this.headersTable.getSelectedRow();
            if (row != -1 && UISupport.confirm("Delete selected header?", "Remove Header")) {
                HttpHeadersInspector.this.changing = true;
                HttpHeadersInspector.this.headersTableModel.remove(row);
                HttpHeadersInspector.this.changing = false;
            }
        }
    }
}

