/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.aut;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.types.StringList;
import com.jgoodies.binding.PresentationModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAutInspector
extends AbstractXmlInspector {
    private JPanel mainPanel;
    private final AbstractHttpRequest<?> request;
    private SimpleBindingForm form;

    protected RequestAutInspector(AbstractHttpRequest<?> request) {
        super("Aut", "Authentication and Security-related settings", true, "Aut");
        this.request = request;
    }

    @Override
    public JComponent getComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.form = new SimpleBindingForm(new PresentationModel(this.request));
            this.form.addSpace(5);
            this.form.appendTextField("username", "Username", "The username to use for HTTP Authentication");
            this.form.appendTextField("password", "Password", "The password to use for HTTP Authentication");
            this.form.appendTextField("domain", "Domain", "The domain to use for HTTP Authentication");
            if (this.request instanceof WsdlRequest) {
                StringList outgoingNames = new StringList(this.request.getOperation().getInterface().getProject().getWssContainer().getOutgoingWssNames());
                outgoingNames.add("");
                StringList incomingNames = new StringList(this.request.getOperation().getInterface().getProject().getWssContainer().getIncomingWssNames());
                incomingNames.add("");
                this.form.addSpace(5);
                this.form.appendComboBox("outgoingWss", "Outgoing WSS", outgoingNames.toStringArray(), "The outgoing WS-Security configuration to use");
                this.form.appendComboBox("incomingWss", "Incoming WSS", incomingNames.toStringArray(), "The incoming WS-Security configuration to use");
            }
            this.form.addSpace(5);
            this.mainPanel.add((Component)new JScrollPane(this.form.getPanel()), "Center");
        }
        return this.mainPanel;
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }
}

