/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.amfheader;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.amfheader.AMFHeadersInspectorModel;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFHeadersInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private StringToStringMapTableModel headersTableModel;
    private final AMFHeadersInspectorModel model;
    private JTable headersTable;
    private JPanel panel;
    private JButton removeButton;
    public boolean changing;

    protected AMFHeadersInspector(AMFHeadersInspectorModel model) {
        super("AMF Headers (" + (model.getHeaders() == null ? "0" : Integer.valueOf(model.getHeaders().size())) + ")", "AMF Headers for this amf message", true, "AMF Headers");
        this.model = model;
        model.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.headersTableModel = new StringToStringMapTableModel(this.model.getHeaders(), "AMFHeader", "Value", !this.model.isReadOnly());
        this.headersTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                AMFHeadersInspector.this.model.setHeaders(AMFHeadersInspector.this.headersTableModel.getData());
                AMFHeadersInspector.this.setTitle("AMF Headers (" + (AMFHeadersInspector.this.model.getHeaders() == null ? "0" : Integer.valueOf(AMFHeadersInspector.this.model.getHeaders().size())) + ")");
            }
        });
        this.headersTable = new JTable(this.headersTableModel);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.headersTable), "Center");
        if (!this.model.isReadOnly()) {
            this.headersTable.setSurrendersFocusOnKeystroke(true);
            this.headersTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            JXToolBar builder = UISupport.createSmallToolbar();
            builder.addFixed(UISupport.createToolbarButton(new AddAction()));
            this.removeButton = UISupport.createToolbarButton(new RemoveAction());
            builder.addFixed(this.removeButton);
            builder.addGlue();
            builder.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/requests.html#HTTP_Headers")));
            this.panel.add((Component)builder, "North");
            this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    AMFHeadersInspector.this.removeButton.setEnabled(AMFHeadersInspector.this.headersTable.getSelectedRow() != -1);
                }
            });
            if (this.headersTable.getRowCount() > 0) {
                this.headersTable.setRowSelectionInterval(0, 0);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        return this.panel;
    }

    public JTable getHeadersTable() {
        return this.headersTable;
    }

    @Override
    public void release() {
        super.release();
        this.model.release();
        this.model.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changing) {
            this.headersTableModel.setData(this.model.getHeaders());
        }
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    private final class AddAction
    extends AbstractAction {
        private AddAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a custom AMF Header to this message");
        }

        public void actionPerformed(ActionEvent arg0) {
            String header = UISupport.prompt("Specify name of header to add", "Add AMF Header", "");
            if (header != null) {
                AMFHeadersInspector.this.changing = true;
                AMFHeadersInspector.this.headersTableModel.add(header.toString(), "");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int row = AMFHeadersInspector.this.headersTable.getRowCount() - 1;
                        AMFHeadersInspector.this.headersTable.scrollRectToVisible(AMFHeadersInspector.this.headersTable.getCellRect(row, 1, true));
                        AMFHeadersInspector.this.headersTable.setRowSelectionInterval(row, row);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AMFHeadersInspector.this.headersTable.editCellAt(AMFHeadersInspector.this.headersTable.getRowCount() - 1, 1);
                                AMFHeadersInspector.this.headersTable.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    }
                });
                AMFHeadersInspector.this.changing = false;
            }
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected custom AMF Header from this message");
        }

        public void actionPerformed(ActionEvent arg0) {
            int row = AMFHeadersInspector.this.headersTable.getSelectedRow();
            if (row != -1 && UISupport.confirm("Delete selected header?", "Remove Header")) {
                AMFHeadersInspector.this.changing = true;
                AMFHeadersInspector.this.headersTableModel.remove(row);
                AMFHeadersInspector.this.changing = false;
            }
        }
    }
}

