/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.support.dnd.handlers.AbstractBeforeAfterModelItemDropHandler;
import com.eviware.soapui.support.dnd.handlers.DragAndDropSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStepToTestStepDropHandler
extends AbstractBeforeAfterModelItemDropHandler<WsdlTestStep, WsdlTestStep> {
    public TestStepToTestStepDropHandler() {
        super(WsdlTestStep.class, WsdlTestStep.class);
    }

    @Override
    boolean copyAfter(WsdlTestStep source, WsdlTestStep target) {
        return DragAndDropSupport.copyTestStep(source, target.getTestCase(), target.getTestCase().getIndexOfTestStep(target) + 1);
    }

    @Override
    boolean moveAfter(WsdlTestStep source, WsdlTestStep target) {
        return DragAndDropSupport.moveTestStep(source, target.getTestCase(), target.getTestCase().getIndexOfTestStep(target) + 1);
    }

    @Override
    boolean canCopyAfter(WsdlTestStep source, WsdlTestStep target) {
        return !SoapUI.getTestMonitor().hasRunningTest(target.getTestCase());
    }

    @Override
    boolean canMoveAfter(WsdlTestStep source, WsdlTestStep target) {
        return source != target;
    }

    @Override
    String getCopyAfterInfo(WsdlTestStep source, WsdlTestStep target) {
        return source.getTestCase() == target.getTestCase() ? "Copy TestStep [" + source.getName() + "] within TestCase [" + target.getTestCase().getName() + "]" : "Copy TestStep [" + source.getName() + "] to TestCase [" + target.getTestCase().getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlTestStep source, WsdlTestStep target) {
        return source.getTestCase() == target.getTestCase() ? "Move TestStep [" + source.getName() + "] within TestCase [" + target.getTestCase().getName() + "]" : "Move TestStep [" + source.getName() + "] to TestCase [" + target.getTestCase().getName() + "]";
    }

    @Override
    boolean canCopyBefore(WsdlTestStep source, WsdlTestStep target) {
        return true;
    }

    @Override
    boolean canMoveBefore(WsdlTestStep source, WsdlTestStep target) {
        return source != target;
    }

    @Override
    boolean copyBefore(WsdlTestStep source, WsdlTestStep target) {
        return DragAndDropSupport.copyTestStep(source, target.getTestCase(), target.getTestCase().getIndexOfTestStep(target));
    }

    @Override
    String getCopyBeforeInfo(WsdlTestStep source, WsdlTestStep target) {
        return this.getCopyAfterInfo(source, target);
    }

    @Override
    String getMoveBeforeInfo(WsdlTestStep source, WsdlTestStep target) {
        return this.getMoveAfterInfo(source, target);
    }

    @Override
    boolean moveBefore(WsdlTestStep source, WsdlTestStep target) {
        return DragAndDropSupport.moveTestStep(source, target.getTestCase(), target.getTestCase().getIndexOfTestStep(target));
    }
}

