/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.request.AddRequestToTestCaseAction;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.tree.nodes.support.WsdlTestStepsModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.dnd.handlers.AbstractAfterModelItemDropHandler;
import com.eviware.soapui.support.dnd.handlers.DragAndDropSupport;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestToTestStepsDropHandler
extends AbstractAfterModelItemDropHandler<WsdlRequest, WsdlTestStepsModelItem> {
    public RequestToTestStepsDropHandler() {
        super(WsdlRequest.class, WsdlTestStepsModelItem.class);
    }

    @Override
    boolean canCopyAfter(WsdlRequest source, WsdlTestStepsModelItem target) {
        return true;
    }

    @Override
    boolean canMoveAfter(WsdlRequest source, WsdlTestStepsModelItem target) {
        return true;
    }

    @Override
    boolean copyAfter(WsdlRequest source, WsdlTestStepsModelItem target) {
        return this.addRequestToTestCase(source, target);
    }

    private boolean addRequestToTestCase(WsdlRequest source, WsdlTestStepsModelItem target) {
        SoapUIAction action;
        if (!UISupport.confirm("Add Request [" + source.getName() + "] to TestCase [" + target.getTestCase().getName() + "]", "Add Request to TestCase")) {
            return false;
        }
        WsdlProject targetProject = target.getTestCase().getTestSuite().getProject();
        if (targetProject != source.getOperation().getInterface().getProject()) {
            HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
            requiredInterfaces.add(source.getOperation().getInterface());
            if (!DragAndDropSupport.importRequiredInterfaces(targetProject, requiredInterfaces, "Add Request to TestCase")) {
                return false;
            }
        }
        return ((AddRequestToTestCaseAction)(action = SoapUI.getActionRegistry().getAction("AddRequestToTestCaseAction"))).addRequest(target.getTestCase(), source, 0) != null;
    }

    @Override
    boolean moveAfter(WsdlRequest source, WsdlTestStepsModelItem target) {
        return this.addRequestToTestCase(source, target);
    }

    @Override
    String getCopyAfterInfo(WsdlRequest source, WsdlTestStepsModelItem target) {
        return "Add Request [" + source.getName() + "] to TestCase [" + target.getTestCase().getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlRequest source, WsdlTestStepsModelItem target) {
        return this.getCopyAfterInfo(source, target);
    }
}

