/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.dnd.ModelItemDropHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelItemDropHandler<T1 extends ModelItem, T2 extends ModelItem>
implements ModelItemDropHandler<ModelItem> {
    private final Class<T1> sourceClass;
    private final Class<T2> targetClass;

    protected AbstractModelItemDropHandler(Class<T1> sourceClass, Class<T2> targetClass) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    @Override
    public boolean canDrop(ModelItem source, ModelItem target, int dropAction, int dropType) {
        try {
            if (this.sourceClass.isAssignableFrom(source.getClass()) && this.targetClass.isAssignableFrom(target.getClass())) {
                ModelItem sourceItem = source;
                ModelItem targetItem = target;
                if ((dropAction & 1) != 0) {
                    return this.canCopy(sourceItem, targetItem, dropType);
                }
                if ((dropAction & 2) != 0) {
                    return this.canMove(sourceItem, targetItem, dropType);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return false;
    }

    private boolean canMove(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.canMoveBefore(sourceItem, targetItem);
            }
            case 2: {
                return this.canMoveAfter(sourceItem, targetItem);
            }
            case 4: {
                return this.canMoveOn(sourceItem, targetItem);
            }
        }
        return false;
    }

    private boolean canCopy(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.canCopyBefore(sourceItem, targetItem);
            }
            case 2: {
                return this.canCopyAfter(sourceItem, targetItem);
            }
            case 4: {
                return this.canCopyOn(sourceItem, targetItem);
            }
        }
        return false;
    }

    abstract boolean canCopyBefore(T1 var1, T2 var2);

    abstract boolean canMoveBefore(T1 var1, T2 var2);

    abstract boolean canMoveOn(T1 var1, T2 var2);

    abstract boolean canCopyOn(T1 var1, T2 var2);

    abstract boolean copyBefore(T1 var1, T2 var2);

    abstract boolean moveBefore(T1 var1, T2 var2);

    abstract boolean moveOn(T1 var1, T2 var2);

    abstract boolean canCopyAfter(T1 var1, T2 var2);

    abstract boolean canMoveAfter(T1 var1, T2 var2);

    abstract boolean copyAfter(T1 var1, T2 var2);

    abstract boolean copyOn(T1 var1, T2 var2);

    abstract boolean moveAfter(T1 var1, T2 var2);

    abstract String getCopyBeforeInfo(T1 var1, T2 var2);

    abstract String getMoveBeforeInfo(T1 var1, T2 var2);

    abstract String getCopyOnInfo(T1 var1, T2 var2);

    abstract String getMoveOnInfo(T1 var1, T2 var2);

    abstract String getCopyAfterInfo(T1 var1, T2 var2);

    abstract String getMoveAfterInfo(T1 var1, T2 var2);

    @Override
    public String getDropInfo(ModelItem source, ModelItem target, int dropAction, int dropType) {
        try {
            if (this.sourceClass.isAssignableFrom(source.getClass()) && this.targetClass.isAssignableFrom(target.getClass())) {
                ModelItem sourceItem = source;
                ModelItem targetItem = target;
                if ((dropAction & 1) != 0) {
                    return this.getCopyInfo(sourceItem, targetItem, dropType);
                }
                if ((dropAction & 2) != 0) {
                    return this.getMoveInfo(sourceItem, targetItem, dropType);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return null;
    }

    private String getMoveInfo(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.getMoveBeforeInfo(sourceItem, targetItem);
            }
            case 2: {
                return this.getMoveAfterInfo(sourceItem, targetItem);
            }
            case 4: {
                return this.getMoveOnInfo(sourceItem, targetItem);
            }
        }
        return null;
    }

    private String getCopyInfo(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.getCopyBeforeInfo(sourceItem, targetItem);
            }
            case 2: {
                return this.getCopyAfterInfo(sourceItem, targetItem);
            }
            case 4: {
                return this.getCopyOnInfo(sourceItem, targetItem);
            }
        }
        return null;
    }

    @Override
    public boolean drop(ModelItem source, ModelItem target, int dropAction, int dropType) {
        try {
            if (this.sourceClass.isAssignableFrom(source.getClass()) && this.targetClass.isAssignableFrom(target.getClass())) {
                ModelItem sourceItem = source;
                ModelItem targetItem = target;
                if ((dropAction & 1) != 0 && this.canCopy(sourceItem, targetItem, dropType)) {
                    return this.copy(sourceItem, targetItem, dropType);
                }
                if ((dropAction & 2) != 0 && this.canMove(sourceItem, targetItem, dropType)) {
                    return this.move(sourceItem, targetItem, dropType);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return false;
    }

    private boolean move(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.moveBefore(sourceItem, targetItem);
            }
            case 2: {
                return this.moveAfter(sourceItem, targetItem);
            }
            case 4: {
                return this.moveOn(sourceItem, targetItem);
            }
        }
        return false;
    }

    private boolean copy(T1 sourceItem, T2 targetItem, int dropType) {
        switch (dropType) {
            case 1: {
                return this.copyBefore(sourceItem, targetItem);
            }
            case 2: {
                return this.copyAfter(sourceItem, targetItem);
            }
            case 4: {
                return this.copyOn(sourceItem, targetItem);
            }
        }
        return false;
    }
}

