/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd;

import com.eviware.soapui.SoapUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public abstract class AbstractSoapUIDropTarget
implements DropTargetListener {
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dtde.getDropAction());
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrop();
        } else {
            try {
                Object testCase = this.getTransferData(dtde.getTransferable());
                if (testCase != null) {
                    dtde.acceptDrop(dtde.getDropAction());
                    this.handleDrop(testCase, dtde.getLocation());
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    protected abstract boolean handleDrop(Object var1, Point var2);

    protected abstract boolean isAcceptable(Object var1, Point var2);

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean isAcceptable(Transferable transferable, Point point) {
        return this.isAcceptable(this.getTransferData(transferable), point);
    }

    private Object getTransferData(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
            try {
                return transferable.getTransferData(flavor);
            }
            catch (Exception ex) {
                SoapUI.logError(ex);
            }
        }
        return null;
    }

    public static void addDropTarget(Component component, AbstractSoapUIDropTarget target) {
        DropTarget dropTarget = new DropTarget(component, target);
        dropTarget.setDefaultActions(3);
    }
}

