/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceDialog;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.components.Undoable;
import com.eviware.soapui.support.swing.JTextComponentPopupMenu;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JUndoableTextArea
extends JTextArea
implements Undoable,
UndoableEditListener,
FocusListener,
FindAndReplaceable,
JEditorStatusBar.JEditorStatusBarTarget {
    public static final int UNDO_LIMIT = 1500;
    private UndoManager undoManager;
    private boolean discardEditsOnSet = false;
    private FindAndReplaceDialog findAndReplaceAction;

    public JUndoableTextArea() {
        this.init();
    }

    private void init() {
        this.getDocument().addUndoableEditListener(this);
        this.addFocusListener(this);
        this.setMinimumSize(new Dimension(50, 50));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu Z"))) {
                    JUndoableTextArea.this.undo();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu Y"))) {
                    JUndoableTextArea.this.redo();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu X"))) {
                    JUndoableTextArea.this.cut();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu C"))) {
                    JUndoableTextArea.this.copy();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu V"))) {
                    JUndoableTextArea.this.paste();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("F3"))) {
                    JUndoableTextArea.this.findAndReplace();
                } else {
                    return;
                }
                e.consume();
            }
        });
        JTextComponentPopupMenu.add(this);
    }

    public JUndoableTextArea(int i, int j) {
        super(i, j);
        this.init();
    }

    public JUndoableTextArea(String text) {
        super(text);
        this.init();
    }

    protected void findAndReplace() {
        if (this.findAndReplaceAction == null) {
            this.findAndReplaceAction = new FindAndReplaceDialog(this);
        }
        this.findAndReplaceAction.show();
    }

    public void setText(String text) {
        this.ensureUndoManager();
        super.setText(text == null ? "" : text);
        if (this.discardEditsOnSet && this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public boolean isDiscardEditsOnSet() {
        return this.discardEditsOnSet;
    }

    public void setDiscardEditsOnSet(boolean discardEditsOnSet) {
        this.discardEditsOnSet = discardEditsOnSet;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    private void ensureUndoManager() {
        if (this.isEditable() && this.undoManager == null) {
            this.undoManager = new UndoManager();
            this.undoManager.setLimit(1500);
        }
    }

    public void focusGained(FocusEvent fe) {
        this.ensureUndoManager();
    }

    public void focusLost(FocusEvent fe) {
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.undoManager != null) {
            this.undoManager.addEdit(e.getEdit());
        }
    }

    public void undo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.undoManager != null) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.undoManager != null) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setSelectedText(String txt) {
        this.replaceSelection(txt);
    }

    public boolean canRedo() {
        return this.undoManager != null && this.undoManager.canRedo();
    }

    public boolean canUndo() {
        return this.undoManager != null && this.undoManager.canUndo();
    }
}

