/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class JHyperlinkLabel
extends JLabel {
    private Color underlineColor = null;

    public JHyperlinkLabel(String label) {
        super(label);
        this.setForeground(Color.BLUE.darker());
        this.setCursor(new Cursor(12));
        this.addMouseListener(new HyperlinkLabelMouseAdapter());
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.underlineColor == null ? this.getForeground() : this.underlineColor);
        Insets insets = this.getInsets();
        int left = insets.left;
        if (this.getIcon() != null) {
            left += this.getIcon().getIconWidth() + this.getIconTextGap();
        }
        g.drawLine(left, this.getHeight() - 1 - insets.bottom, (int)this.getPreferredSize().getWidth() - insets.right, this.getHeight() - 1 - insets.bottom);
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    public class HyperlinkLabelMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Tools.openURL(JHyperlinkLabel.this.getText());
        }
    }
}

