/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.teamdev.jxbrowser.BrowserAttributes;
import com.teamdev.jxbrowser.ClipboardSupport;
import com.teamdev.jxbrowser.ContentHandler;
import com.teamdev.jxbrowser.SearchParams;
import com.teamdev.jxbrowser.WebBrowser;
import com.teamdev.jxbrowser.WebBrowserFactory;
import com.teamdev.jxbrowser.WebBrowserHistory;
import com.teamdev.jxbrowser.WebBrowserWindow;
import com.teamdev.jxbrowser.WindowCreator;
import com.teamdev.jxbrowser.event.ContextMenuListener;
import com.teamdev.jxbrowser.event.HistoryChangeListener;
import com.teamdev.jxbrowser.event.LocationEvent;
import com.teamdev.jxbrowser.event.RequestAdapter;
import com.teamdev.jxbrowser.event.RequestListener;
import com.teamdev.jxbrowser.event.StatusChangeEvent;
import com.teamdev.jxbrowser.event.StatusChangeListener;
import com.teamdev.jxbrowser.event.TitleChangeListener;
import com.teamdev.jxbrowser.mozilla.MozillaWebBrowser;
import com.teamdev.jxbrowser.printing.WebBrowserPrinting;
import com.teamdev.jxbrowser.ssl.BadCertificateHandler;
import com.teamdev.xpcom.AsyncHandlerFactory;
import com.teamdev.xpcom.PoxyAuthenticationHandler;
import com.teamdev.xpcom.ProxyConfiguration;
import com.teamdev.xpcom.ProxyServerAuthInfo;
import com.teamdev.xpcom.ProxyServerType;
import com.teamdev.xpcom.Services;
import com.teamdev.xpcom.Xpcom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWeakReference;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Document;

public class BrowserComponent
implements nsIWebProgressListener,
nsIWeakReference,
StatusChangeListener {
    private static String disabledReason;
    private WebBrowser browser;
    private static WebBrowserFactory webBrowserFactory;
    private JPanel panel = new JPanel(new BorderLayout());
    private JPanel statusBar;
    private JLabel statusLabel;
    private String errorPage;
    private WebBrowserWindow browserWindowAdapter = new BrowserWindowAdapter();
    private final boolean addToolbar;
    private boolean showingErrorPage;
    public String url;
    private static Boolean initialized;
    private Boolean possibleError = false;
    private boolean disposed;
    private static boolean disabled;

    public BrowserComponent(boolean addToolbar) {
        this.addToolbar = addToolbar;
        BrowserComponent.initialize();
    }

    public static void setDisabled(boolean disabled) {
        BrowserComponent.disabled = disabled;
    }

    public static synchronized void initialize() {
        if (initialized.booleanValue()) {
            return;
        }
        try {
            if (!BrowserComponent.isJXBrowserDisabled()) {
                if (Xpcom.isMacOSX()) {
                    String currentCP = System.getProperty("java.class.path");
                    String appleJavaExtentions = ":/System/Library/Java";
                    System.setProperty("java.class.path", currentCP + ":/System/Library/Java");
                }
                Xpcom.initialize();
                webBrowserFactory = WebBrowserFactory.getInstance();
            }
            initialized = true;
        }
        catch (Throwable t) {
            disabledReason = t.getMessage();
            t.printStackTrace();
        }
    }

    public static boolean isJXBrowserDisabled() {
        if (disabled) {
            return true;
        }
        String disable = System.getProperty("soapui.jxbrowser.disable", "nope");
        if (disable.equals("true")) {
            return true;
        }
        return !disable.equals("false") && !Xpcom.isMacOSX() && "64".equals(System.getProperty("sun.arch.data.model"));
    }

    public Component getComponent() {
        if (BrowserComponent.isJXBrowserDisabled()) {
            JEditorPane jxbrowserDisabledPanel = new JEditorPane();
            jxbrowserDisabledPanel.setText("browser component disabled");
            this.panel.add(jxbrowserDisabledPanel);
        } else if (this.browser == null) {
            this.statusBar = new JPanel();
            this.statusLabel = new JLabel();
            this.statusBar.add((Component)this.statusLabel, "Center");
            if (this.addToolbar) {
                this.panel.add(this.buildToolbar(), "North");
            }
            this.panel.add((Component)this.statusBar, "South");
            this.initBrowser();
            this.browser.navigate("about:blank");
        }
        return this.panel;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new BackAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(UISupport.createToolbarButton(new ForwardAction()));
        toolbar.addGlue();
        return toolbar;
    }

    public synchronized boolean initBrowser() {
        if (this.browser != null) {
            return false;
        }
        this.browser = webBrowserFactory == null ? new DummyBrowser() : webBrowserFactory.createBrowser();
        this.panel.add(this.browser.getComponent(), "Center");
        this.browser.addContentHandler(new ContentHandler(){

            public boolean canHandleContent(String arg0) {
                return true;
            }

            public void handleContent(URL arg0) {
                SoapUI.log.info((Object)("Ignoring content for [" + arg0 + "]"));
            }

            public boolean isPreferred(String arg0) {
                return true;
            }
        });
        if (webBrowserFactory != null) {
            nsIWebBrowser nsWebBrowser = ((MozillaWebBrowser)this.browser).getWebBrowser();
            nsWebBrowser.addWebBrowserListener((nsISupports)this, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            this.browser.addStatusChangeListener((StatusChangeListener)this);
            this.browser.setWindowCreator(new WindowCreator(){

                public WebBrowserWindow createChildWindow(Component parentComponent, long flags) {
                    return BrowserComponent.this.browserWindowAdapter;
                }
            });
            this.setUpProxy();
        }
        return true;
    }

    public void release() {
        if (this.browser != null) {
            this.disposed = true;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BrowserComponent.this.cleanup();
                    }
                });
            } else {
                this.cleanup();
            }
        }
        this.possibleError = false;
    }

    private void cleanup() {
        this.browser.stop();
        if (webBrowserFactory != null) {
            nsIWebBrowser nsWebBrowser = ((MozillaWebBrowser)this.browser).getWebBrowser();
            nsWebBrowser.removeWebBrowserListener((nsISupports)this, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            this.browser.removeStatusChangeListener((StatusChangeListener)this);
            this.browser.dispose();
        }
        this.browser = null;
    }

    public void setContent(String contentAsString, String contentType, String contextUri) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ContentSetter(contentAsString, contentType, contextUri));
        } else {
            if (this.browser == null) {
                this.initBrowser();
            }
            this.browser.activate();
            this.browser.setContentWithContext(contentAsString, contentType, contextUri);
        }
    }

    public void setContent(String content, String contentType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ContentSetter(content, contentType, null));
        } else {
            if (this.browser == null) {
                this.initBrowser();
            }
            this.browser.activate();
            this.browser.setContent(content, contentType);
        }
    }

    public boolean navigate(String url, String errorPage) {
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
        this.url = url;
        Xpcom.invokeLater((Runnable)new Navigator());
        return true;
    }

    public String getContent() {
        return this.browser == null ? null : XmlUtils.serialize(this.browser.getDocument());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws InterruptedException, InvocationTargetException {
        this.navigate(url, null);
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public nsISupports queryReferent(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public void onLocationChange(nsIWebProgress arg0, nsIRequest arg1, nsIURI arg2) {
        if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
            if (!this.possibleError.booleanValue()) {
                this.possibleError = true;
            } else if (!this.showingErrorPage) {
                this.showErrorPage();
            }
        }
    }

    public void onProgressChange(nsIWebProgress arg0, nsIRequest arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    public void onSecurityChange(nsIWebProgress arg0, nsIRequest arg1, long arg2) {
    }

    public void onStateChange(nsIWebProgress arg0, nsIRequest request, long arg2, long arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    private void showErrorPage() {
        if (this.errorPage != null && !this.errorPage.equals(this.getUrl())) {
            try {
                this.showingErrorPage = true;
                this.setUrl(this.errorPage);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void onStatusChange(nsIWebProgress arg0, nsIRequest arg1, long arg2, String arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)arg1.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    public void statusChanged(final StatusChangeEvent event) {
        if (this.statusLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BrowserComponent.this.statusLabel.setText(event.getStatus());
                }
            });
        }
    }

    public boolean isBrowserInitialised() {
        return this.browser != null;
    }

    void setUpProxy() {
        ProxyConfiguration proxyConf = Services.getProxyConfiguration();
        if (proxyConf == null) {
            return;
        }
        Settings settings = SoapUI.getSettings();
        PropertyExpansionContext context = null;
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost == null) {
            proxyHost = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.HOST, ""));
        }
        if (proxyPort == null) {
            proxyPort = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PORT, ""));
        }
        if (!StringUtils.isNullOrEmpty(proxyHost) && !StringUtils.isNullOrEmpty(proxyPort)) {
            String[] excludes;
            proxyConf.setHttpHost(proxyHost);
            proxyConf.setHttpPort(Integer.parseInt(proxyPort));
            for (String url : excludes = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.EXCLUDES, "")).split(",")) {
                proxyConf.setSkipProxyFor(url);
            }
            final String proxyUsername = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.USERNAME, null));
            final String proxyPassword = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PASSWORD, null));
            if (proxyUsername != null) {
                proxyConf.setPoxyAuthenticationHandler(ProxyServerType.HTTP, new PoxyAuthenticationHandler(){

                    public ProxyServerAuthInfo authenticationRequired() {
                        return new ProxyServerAuthInfo(proxyUsername, proxyPassword);
                    }
                });
            }
        }
    }

    static {
        initialized = false;
    }

    public class ContentSetter
    implements Runnable {
        private final String contentAsString;
        private final String contentType;
        private final String contextUri;

        public ContentSetter(String contentAsString, String contentType, String contextUri) {
            this.contentAsString = contentAsString;
            this.contentType = contentType;
            this.contextUri = contextUri;
        }

        public void run() {
            if (StringUtils.hasContent(this.contextUri)) {
                BrowserComponent.this.browser.setContentWithContext(this.contentAsString, this.contentType, this.contextUri);
            } else {
                BrowserComponent.this.browser.setContent(this.contentAsString, this.contentType);
            }
        }
    }

    private static class PopupRequestAdapter
    extends RequestAdapter {
        private LocationEvent event;

        private PopupRequestAdapter() {
        }

        public void locationChanged(LocationEvent arg0) {
            if (!arg0.getLocation().equals("about:blank")) {
                this.event = arg0;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean opened = false;
                        if (UISupport.confirm("Open url [" + PopupRequestAdapter.this.event.getLocation() + "] in external browser?", "Open URL")) {
                            opened = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    Tools.openURL(PopupRequestAdapter.this.event.getLocation());
                                    PopupRequestAdapter.this.event = null;
                                }
                            });
                        }
                        PopupRequestAdapter.this.event.getWebBrowser().stop();
                        PopupRequestAdapter.this.event.getWebBrowser().deactivate();
                        PopupRequestAdapter.this.event.getWebBrowser().dispose();
                        PopupRequestAdapter.this.event.getWebBrowser().removeRequestListener((RequestListener)PopupRequestAdapter.this);
                        if (!opened) {
                            PopupRequestAdapter.this.event = null;
                        }
                    }
                });
            }
        }
    }

    private class BrowserWindowAdapter
    implements WebBrowserWindow {
        private boolean resizable;

        private BrowserWindowAdapter() {
        }

        public void close() {
        }

        public boolean isClosed() {
            return true;
        }

        public void setModal(boolean arg0) {
        }

        public void setSize(int arg0, int arg1) {
        }

        public void setVisible(boolean arg0) {
        }

        public void setWebBrowser(WebBrowser arg0) {
            if (arg0 != null) {
                arg0.addRequestListener((RequestListener)new PopupRequestAdapter());
            }
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public void setResizable(boolean resizable) {
            this.resizable = resizable;
        }
    }

    private final class Navigator
    implements Runnable {
        private Navigator() {
        }

        public void run() {
            try {
                if (BrowserComponent.this.browser == null) {
                    BrowserComponent.this.initBrowser();
                }
                BrowserComponent.this.browser.activate();
                BrowserComponent.this.browser.navigate(BrowserComponent.this.getUrl());
                if (BrowserComponent.this.showingErrorPage) {
                    BrowserComponent.this.showingErrorPage = false;
                }
            }
            catch (Throwable e) {
                SoapUI.log(e.toString());
            }
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        public void actionPerformed(ActionEvent e) {
            BrowserComponent.this.browser.goForward();
        }
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        public void actionPerformed(ActionEvent e) {
            if (BrowserComponent.this.browser.getHistory().getCurrentPosition() == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                BrowserComponent.this.browser.goBack();
            }
        }
    }

    public class DummyBrowser
    implements WebBrowser {
        public void activate() {
        }

        public void addContentHandler(ContentHandler arg0) {
        }

        public void addContextMenuListener(ContextMenuListener arg0) {
        }

        public void addHistoryChangeListener(HistoryChangeListener arg0) {
        }

        public void addRequestListener(RequestListener arg0) {
        }

        public void addStatusChangeListener(StatusChangeListener arg0) {
        }

        public void addTitleChangeListener(TitleChangeListener arg0) {
        }

        public void deactivate() {
        }

        public void displayAsSource(boolean arg0) {
        }

        public void dispose() {
        }

        public String evaluateScript(String arg0) {
            return null;
        }

        public boolean findString(String arg0) {
            return false;
        }

        public AsyncHandlerFactory getAsyncHandler() {
            return null;
        }

        public BrowserAttributes getAttributes() {
            return null;
        }

        public boolean getCanGoBack() {
            return false;
        }

        public boolean getCanGoForward() {
            return false;
        }

        public ClipboardSupport getClipboardSupport() {
            return null;
        }

        public Component getComponent() {
            return new JLabel("Browser Component Disabled: [" + disabledReason + "]");
        }

        public Document getDocument() {
            return null;
        }

        public String getDocumentContent(String arg0) {
            return null;
        }

        public WebBrowserHistory getHistory() {
            return null;
        }

        public String getLocationURL() {
            return null;
        }

        public WebBrowserPrinting getPrinting() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public void goBack() {
        }

        public void goForward() {
        }

        public boolean isDisposed() {
            return false;
        }

        public void navigate(String arg0) {
        }

        public void navigate(String arg0, String arg1) {
        }

        public void pageDown() {
        }

        public void pageUp() {
        }

        public void refresh() {
        }

        public void removeContextMenuListener(ContextMenuListener arg0) {
        }

        public void removeHistoryChangeListener(HistoryChangeListener arg0) {
        }

        public void removeRequestListener(RequestListener arg0) {
        }

        public void removeStatusChangeListener(StatusChangeListener arg0) {
        }

        public void removeTitleChangeListener(TitleChangeListener arg0) {
        }

        public void resetBadCertificateHandler(BadCertificateHandler arg0) {
        }

        public void saveCurrentDocument(File arg0, RequestListener arg1) {
        }

        public void saveURLtoFile(URL arg0, File arg1, RequestListener arg2) {
        }

        public void setAsyncHandler(AsyncHandlerFactory arg0) {
        }

        public void setAttributes(BrowserAttributes arg0) {
        }

        public void setContent(String arg0, String arg1) {
        }

        public void setContent(String arg0, String arg1, String arg2) {
        }

        public void setContentWithContext(String arg0, String arg1, String arg2) {
        }

        public void setFocusAtFirstElement() {
        }

        public void setWindowCreator(WindowCreator arg0) {
        }

        public void showOpenFileDialog() {
        }

        public void showSaveFileDialog() {
        }

        public void stop() {
        }

        public BufferedImage toImage() {
            return null;
        }

        public boolean findNext(String arg0, SearchParams arg1) {
            return false;
        }

        public void setContent(String arg0) {
        }
    }
}

