/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlHolder
implements Map<String, Object> {
    private XmlObject xmlObject;
    private StringToStringMap declaredNamespaces;
    private PropertyExpansionContext context;
    private String propertyRef;

    public XmlHolder(String xml) throws XmlException {
        this.xmlObject = XmlObject.Factory.parse((String)xml);
    }

    public XmlHolder(Node node) throws XmlException {
        this.xmlObject = XmlObject.Factory.parse((Node)node);
    }

    public XmlHolder(XmlObject xmlObject) throws XmlException {
        this.xmlObject = xmlObject;
    }

    public XmlHolder(PropertyExpansionContext context, String propertyRef) throws XmlException {
        this(context.getProperty(propertyRef).toString());
        this.context = context;
        this.propertyRef = propertyRef;
    }

    public void updateProperty() {
        this.updateProperty(false);
    }

    public void updateProperty(boolean prettyPrint) {
        if (this.context != null && this.propertyRef != null) {
            this.context.setProperty(this.propertyRef, prettyPrint ? this.getPrettyXml() : this.getXml());
        }
    }

    public String getNodeValue(String xpath) throws XmlException {
        xpath = this.initXPathNamespaces(xpath);
        return XmlUtils.selectFirstNodeValue(this.xmlObject, xpath);
    }

    public StringToStringMap getNamespaces() {
        if (this.declaredNamespaces == null) {
            this.declaredNamespaces = new StringToStringMap();
        }
        return this.declaredNamespaces;
    }

    public void declareNamespace(String prefix, String uri) {
        if (this.declaredNamespaces == null) {
            this.declaredNamespaces = new StringToStringMap();
        }
        this.declaredNamespaces.put(prefix, uri);
    }

    public String[] getNodeValues(String xpath) throws XmlException {
        xpath = this.initXPathNamespaces(xpath);
        return XmlUtils.selectNodeValues(this.xmlObject, xpath);
    }

    private String initXPathNamespaces(String xpath) {
        if (this.declaredNamespaces != null && !this.declaredNamespaces.isEmpty()) {
            for (String prefix : this.declaredNamespaces.keySet()) {
                xpath = "declare namespace " + prefix + "='" + (String)this.declaredNamespaces.get(prefix) + "';\n" + xpath;
            }
        } else if (!xpath.trim().startsWith("declare namespace")) {
            xpath = XmlUtils.declareXPathNamespaces(this.xmlObject) + xpath;
        }
        return xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeValue(String xpath, Object value) throws XmlException {
        xpath = this.initXPathNamespaces(xpath);
        XmlCursor cursor = this.xmlObject.newCursor();
        try {
            cursor.selectPath(xpath);
            if (cursor.toNextSelection()) {
                XmlUtils.setNodeValue(cursor.getDomNode(), value == null ? null : value.toString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            cursor.dispose();
            throw throwable;
        }
        cursor.dispose();
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public Node getDomNode(String xpath) throws XmlException {
        xpath = this.initXPathNamespaces(xpath);
        return XmlUtils.selectFirstDomNode(this.xmlObject, xpath);
    }

    public Node[] getDomNodes(String xpath) throws XmlException {
        xpath = this.initXPathNamespaces(xpath);
        return XmlUtils.selectDomNodes(this.xmlObject, xpath);
    }

    public void removeDomNodes(String xpath) throws XmlException {
        Node[] nodes;
        xpath = this.initXPathNamespaces(xpath);
        for (Node node : nodes = this.getDomNodes(xpath)) {
            node.getParentNode().removeChild(node);
        }
    }

    public String getXml() {
        return this.xmlObject.xmlText();
    }

    public String getPrettyXml() {
        return XmlUtils.prettyPrintXml(this.xmlObject);
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getDomNode(key.toString()) != null;
        }
        catch (XmlException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.getNodeValue(value.toString()) != null;
        }
        catch (XmlException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    @Override
    public Object get(Object key) {
        try {
            String str = key.toString();
            if (str.equals("prettyXml")) {
                return this.getPrettyXml();
            }
            if (str.equals("xmlObject")) {
                return this.getXmlObject();
            }
            if (str.equals("namespaces")) {
                return this.getNamespaces();
            }
            if (str.equals("xml")) {
                return this.getXml();
            }
            String[] nodeValues = this.getNodeValues(str);
            return nodeValues != null && nodeValues.length == 1 ? nodeValues[0] : nodeValues;
        }
        catch (XmlException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public String put(String key, Object value) {
        try {
            String result = this.getNodeValue(key);
            this.setNodeValue(key, value == null ? null : value.toString());
            return result;
        }
        catch (XmlException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        if (t.keySet() == null) {
            return;
        }
        for (String string : t.keySet()) {
            this.put(string, t.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        try {
            Node node = this.getDomNode(key.toString());
            if (node != null) {
                node.getParentNode().removeChild(node);
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }
}

