/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.AbstractTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.LoadTestTreeNode;
import com.eviware.soapui.model.tree.nodes.PropertiesTreeNode;
import com.eviware.soapui.model.tree.nodes.TestStepTreeNode;
import com.eviware.soapui.model.tree.nodes.support.WsdlLoadTestsModelItem;
import com.eviware.soapui.model.tree.nodes.support.WsdlTestStepsModelItem;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseTreeNode
extends AbstractModelItemTreeNode<TestCase> {
    private TestStepsTreeNode testStepsNode;
    private LoadTestsTreeNode loadTestsNode;
    private PropertiesTreeNode<?> propertiesTreeNode;
    private List<SoapUITreeNode> childNodes = new ArrayList<SoapUITreeNode>();

    public TestCaseTreeNode(TestCase testCase, SoapUITreeModel treeModel) {
        super(testCase, testCase.getTestSuite(), treeModel);
        this.testStepsNode = new TestStepsTreeNode();
        this.loadTestsNode = new LoadTestsTreeNode();
        this.getTreeModel().mapModelItem(this.testStepsNode);
        this.getTreeModel().mapModelItem(this.loadTestsNode);
        this.propertiesTreeNode = PropertiesTreeNode.createDefaultPropertiesNode(testCase, this.getTreeModel());
        this.getTreeModel().mapModelItem(this.propertiesTreeNode);
        this.childNodes.add(this.propertiesTreeNode);
        this.childNodes.add(this.testStepsNode);
        this.childNodes.add(this.loadTestsNode);
    }

    @Override
    public void release() {
        super.release();
        for (SoapUITreeNode treeNode : this.childNodes) {
            if (!(treeNode instanceof PropertiesTreeNode)) {
                this.getTreeModel().unmapModelItem(treeNode.getModelItem());
            }
            treeNode.release();
        }
    }

    @Override
    public int getChildCount() {
        int propMod = this.getTreeModel().isShowProperties() ? 0 : 1;
        return this.childNodes.size() - propMod;
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        int propMod = this.getTreeModel().isShowProperties() ? 0 : 1;
        return this.childNodes.get(index + propMod);
    }

    @Override
    public int getIndexOfChild(Object child) {
        int propMod;
        int n = propMod = this.getTreeModel().isShowProperties() ? 0 : 1;
        if (child == this.propertiesTreeNode && propMod == 1) {
            return 0;
        }
        return this.childNodes.indexOf(child) - propMod;
    }

    public LoadTestsTreeNode getLoadTestsNode() {
        return this.loadTestsNode;
    }

    public TestStepsTreeNode getTestStepsNode() {
        return this.testStepsNode;
    }

    public TestCase getTestCase() {
        return (TestCase)this.getModelItem();
    }

    public void testStepInserted(TestStep testStep, int index) {
        this.testStepsNode.testStepInserted(testStep, index);
    }

    public void testStepRemoved(TestStep testStep, int index) {
        this.testStepsNode.testStepRemoved(testStep, index);
    }

    public void loadTestInserted(LoadTest loadTest) {
        this.loadTestsNode.loadTestInserted(loadTest);
    }

    public void loadTestRemoved(LoadTest loadTest) {
        this.loadTestsNode.loadTestRemoved(loadTest);
    }

    public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
        this.testStepsNode.testStepMoved(testStep, fromIndex, offset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LoadTestsTreeNode
    extends AbstractTreeNode<WsdlLoadTestsModelItem> {
        private List<LoadTestTreeNode> loadTestNodes;

        protected LoadTestsTreeNode() {
            super(new WsdlLoadTestsModelItem(TestCaseTreeNode.this.getTestCase()));
            this.loadTestNodes = new ArrayList<LoadTestTreeNode>();
            for (int c = 0; c < TestCaseTreeNode.this.getTestCase().getLoadTestCount(); ++c) {
                this.loadTestNodes.add(new LoadTestTreeNode(TestCaseTreeNode.this.getTestCase().getLoadTestAt(c), (ModelItem)this.getModelItem(), TestCaseTreeNode.this.getTreeModel()));
            }
            TestCaseTreeNode.this.getTreeModel().mapModelItems(this.loadTestNodes);
        }

        @Override
        public int getChildCount() {
            return this.loadTestNodes.size();
        }

        @Override
        public int getIndexOfChild(Object child) {
            return this.loadTestNodes.indexOf(child);
        }

        @Override
        public SoapUITreeNode getChildNode(int index) {
            return this.loadTestNodes.get(index);
        }

        @Override
        public SoapUITreeNode getParentTreeNode() {
            return TestCaseTreeNode.this;
        }

        public void loadTestInserted(LoadTest loadTest) {
            LoadTestTreeNode loadTestTreeNode = new LoadTestTreeNode(loadTest, (ModelItem)this.getModelItem(), TestCaseTreeNode.this.getTreeModel());
            this.loadTestNodes.add(loadTestTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeInserted(loadTestTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeChanged(this);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            SoapUITreeNode treeNode = TestCaseTreeNode.this.getTreeModel().getTreeNode(loadTest);
            if (!this.loadTestNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown loadTest");
            }
            TestCaseTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            this.loadTestNodes.remove(treeNode);
        }

        @Override
        public void release() {
            for (LoadTestTreeNode loadTestNode : this.loadTestNodes) {
                loadTestNode.release();
            }
        }

        @Override
        public ActionList getActions() {
            return ActionListBuilder.buildActions("LoadTestsTreeNodeActions", TestCaseTreeNode.this.getModelItem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestStepsTreeNode
    extends AbstractTreeNode<WsdlTestStepsModelItem> {
        private List<TestStepTreeNode> testStepNodes;

        protected TestStepsTreeNode() {
            super(new WsdlTestStepsModelItem(TestCaseTreeNode.this.getTestCase()));
            this.testStepNodes = new ArrayList<TestStepTreeNode>();
            for (int c = 0; c < TestCaseTreeNode.this.getTestCase().getTestStepCount(); ++c) {
                TestStep testStep = TestCaseTreeNode.this.getTestCase().getTestStepAt(c);
                this.testStepNodes.add(this.createTestStepTreeNode(testStep));
            }
            TestCaseTreeNode.this.getTreeModel().mapModelItems(this.testStepNodes);
        }

        private TestStepTreeNode createTestStepTreeNode(TestStep testStep) {
            return new TestStepTreeNode(testStep, (ModelItem)this.getModelItem(), TestCaseTreeNode.this.getTreeModel());
        }

        @Override
        public int getChildCount() {
            return this.testStepNodes.size();
        }

        @Override
        public int getIndexOfChild(Object child) {
            return this.testStepNodes.indexOf(child);
        }

        @Override
        public SoapUITreeNode getChildNode(int index) {
            return this.testStepNodes.get(index);
        }

        @Override
        public SoapUITreeNode getParentTreeNode() {
            return TestCaseTreeNode.this;
        }

        public void testStepInserted(TestStep testStep, int index) {
            TestStepTreeNode testStepTreeNode = this.createTestStepTreeNode(testStep);
            this.testStepNodes.add(index, testStepTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeInserted(testStepTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeChanged(this);
        }

        public void testStepRemoved(TestStep testStep, int index) {
            SoapUITreeNode treeNode = TestCaseTreeNode.this.getTreeModel().getTreeNode(testStep);
            if (!this.testStepNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown testStep");
            }
            TestCaseTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            this.testStepNodes.remove(treeNode);
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            this.testStepRemoved(testStep, fromIndex);
            this.testStepInserted(testStep, fromIndex + offset);
        }

        @Override
        public ActionList getActions() {
            return ActionListBuilder.buildActions("TestStepsTreeNodeActions", TestCaseTreeNode.this.getModelItem());
        }

        @Override
        public void release() {
            for (TestStepTreeNode testStepNode : this.testStepNodes) {
                testStepNode.release();
            }
            ((WsdlTestStepsModelItem)this.getModelItem()).release();
        }
    }
}

