/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion.resolvers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class ResolverUtils {
    public static String checkForExplicitReference(String propertyName, String prefix, TestPropertyHolder holder, PropertyExpansionContext context, boolean globalOverride) {
        if (holder == null) {
            return null;
        }
        if (!propertyName.startsWith(prefix)) {
            return null;
        }
        propertyName = propertyName.substring(prefix.length());
        return ResolverUtils.parseProperty(propertyName, holder, context, globalOverride);
    }

    public static String parseProperty(String name, TestPropertyHolder holder, PropertyExpansionContext context, boolean globalOverride) {
        int sepIx = name.indexOf(35);
        if (sepIx != -1) {
            String value;
            String xpath = name.substring(sepIx + 1);
            name = name.substring(0, sepIx);
            if (globalOverride && (value = PropertyExpansionUtils.getGlobalProperty(name)) != null) {
                return value;
            }
            TestProperty property = holder.getProperty(name);
            if (property != null) {
                return context == null ? ResolverUtils.extractXPathPropertyValue(property, xpath) : ResolverUtils.extractXPathPropertyValue(property, PropertyExpander.expandProperties(context, xpath));
            }
        } else {
            String value;
            if (globalOverride && (value = PropertyExpansionUtils.getGlobalProperty(name)) != null) {
                return value;
            }
            TestProperty property = holder.getProperty(name);
            if (property != null) {
                return property.getValue();
            }
        }
        return null;
    }

    public static String extractXPathPropertyValue(Object property, String xpath) {
        try {
            String value = property instanceof TestProperty ? ((TestProperty)property).getValue() : property.toString();
            XmlObject xmlObject = XmlObject.Factory.parse((String)value);
            String ns = xpath.trim().startsWith("declare namespace") ? "" : XmlUtils.declareXPathNamespaces(xmlObject);
            Node domNode = XmlUtils.selectFirstDomNode(xmlObject, ns + xpath);
            return domNode == null ? null : XmlUtils.getValueForMatch(domNode, false);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }
}

