/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion.resolvers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockRunContext;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.resolvers.PropertyResolver;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvalPropertyResolver
implements PropertyResolver {
    private Logger log = Logger.getLogger(EvalPropertyResolver.class);
    private Map<String, ScriptEnginePool> scriptEnginePools = new HashMap<String, ScriptEnginePool>();

    public String resolveProperty(PropertyExpansionContext context, String name, boolean globalOverride) {
        ModelItem modelItem;
        if (name.length() == 0 || name.charAt(0) != '=') {
            return null;
        }
        name = name.substring(1);
        StringToObjectMap objects = new StringToObjectMap(context.getProperties());
        objects.put("context", context);
        objects.put("log", SoapUI.ensureGroovyLog());
        if (context instanceof TestCaseRunContext) {
            objects.put("testRunner", ((TestCaseRunContext)context).getTestRunner());
        }
        if (context instanceof LoadTestRunContext) {
            objects.put("loadTestRunner", ((LoadTestRunContext)context).getLoadTestRunner());
        }
        if (context instanceof MockRunContext) {
            objects.put("mockRunner", ((MockRunContext)context).getMockRunner());
        }
        if ((modelItem = context.getModelItem()) instanceof TestCase) {
            objects.put("testCase", modelItem);
        } else if (modelItem instanceof TestStep) {
            objects.put("testStep", modelItem);
        } else if (modelItem instanceof TestSuite) {
            objects.put("testSuite", modelItem);
        }
        if (modelItem instanceof LoadTest) {
            objects.put("loadTest", modelItem);
        } else if (modelItem instanceof Project) {
            objects.put("project", modelItem);
        } else if (modelItem instanceof MockService) {
            objects.put("mockService", modelItem);
        } else if (modelItem instanceof MockOperation) {
            objects.put("mockOperation", modelItem);
        } else if (modelItem instanceof MockResponse) {
            objects.put("mockResponse", modelItem);
        } else if (modelItem instanceof Request) {
            objects.put("request", modelItem);
        } else if (modelItem instanceof Operation) {
            objects.put("operation", modelItem);
        } else if (modelItem instanceof Interface) {
            objects.put("interface", modelItem);
        }
        if (modelItem != null) {
            objects.put("modelItem", modelItem);
        }
        return this.doEval(name, modelItem, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doEval(String name, ModelItem modelItem, StringToObjectMap objects) {
        String engineId = SoapUIScriptEngineRegistry.getScriptEngineId(modelItem);
        EvalPropertyResolver evalPropertyResolver = this;
        synchronized (evalPropertyResolver) {
            if (!this.scriptEnginePools.containsKey(engineId)) {
                this.scriptEnginePools.put(engineId, new ScriptEnginePool(engineId));
            }
        }
        ScriptEnginePool scriptEnginePool = this.scriptEnginePools.get(engineId);
        SoapUIScriptEngine scriptEngine = scriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setScript(name);
            for (String key : objects.keySet()) {
                scriptEngine.setVariable(key, objects.get(key));
            }
            Object result = scriptEngine.run();
            String string = result == null ? null : result.toString();
            Object var10_12 = null;
            scriptEngine.clearVariables();
            scriptEnginePool.returnScriptEngine(scriptEngine);
            return string;
        }
        catch (Throwable e) {
            try {
                this.log.error((Object)"Error evaluating script", e);
                String string = e.getMessage();
                Object var10_13 = null;
                scriptEngine.clearVariables();
                scriptEnginePool.returnScriptEngine(scriptEngine);
                return string;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                scriptEngine.clearVariables();
                scriptEnginePool.returnScriptEngine(scriptEngine);
                throw throwable;
            }
        }
    }
}

