/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion.resolvers;

import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.resolvers.PropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.providers.ProjectDirProvider;
import com.eviware.soapui.model.propertyexpansion.resolvers.providers.WorkspaceDirProvider;
import java.util.HashMap;
import java.util.Map;

public class DynamicPropertyResolver
implements PropertyResolver {
    private static Map<String, ValueProvider> providers = new HashMap<String, ValueProvider>();

    public String resolveProperty(PropertyExpansionContext context, String name, boolean globalOverride) {
        ValueProvider provider = providers.get(name);
        if (provider != null) {
            return provider.getValue(context);
        }
        return null;
    }

    public static void addProvider(String propertyName, ValueProvider provider) {
        providers.put(propertyName, provider);
    }

    static {
        DynamicPropertyResolver.addProvider("projectDir", new ProjectDirProvider());
        DynamicPropertyResolver.addProvider("workspaceDir", new WorkspaceDirProvider());
    }

    public static interface ValueProvider {
        public String getValue(PropertyExpansionContext var1);
    }
}

