/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class WsdlGroovyScriptTestStep
extends WsdlTestStepWithProperties
implements PropertyExpansionContainer {
    private static final Logger logger = Logger.getLogger((String)"groovy.log");
    private String scriptText = "";
    private Object scriptResult;
    private ImageIcon failedIcon;
    private ImageIcon okIcon;
    private SoapUIScriptEngine scriptEngine;

    public WsdlGroovyScriptTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (!forLoadTest) {
            this.okIcon = UISupport.createImageIcon("/groovy_script.gif");
            this.setIcon(this.okIcon);
            this.failedIcon = UISupport.createImageIcon("/groovy_script_failed.gif");
        }
        if (config.getConfig() == null) {
            if (!forLoadTest) {
                this.saveScript(config);
            }
        } else {
            this.readConfig(config);
        }
        this.addProperty(new DefaultTestStepProperty("result", true, new DefaultTestStepProperty.PropertyHandlerAdapter(){

            public String getValue(DefaultTestStepProperty property) {
                return WsdlGroovyScriptTestStep.this.scriptResult == null ? null : WsdlGroovyScriptTestStep.this.scriptResult.toString();
            }
        }, this));
        this.addProperty(new TestStepBeanProperty("script", false, this, "script", this));
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
        this.scriptEngine.setScript(this.getScript());
        if (forLoadTest && !this.isDisabled()) {
            try {
                this.scriptEngine.compile();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public Logger getLogger() {
        SoapUI.ensureGroovyLog();
        return logger;
    }

    private void readConfig(TestStepConfig config) {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config.getConfig());
        this.scriptText = reader.readString("script", "");
    }

    private void saveScript(TestStepConfig config) {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("script", this.scriptText);
        config.setConfig(builder.finish());
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.readConfig(config);
    }

    public String getDefaultSourcePropertyName() {
        return "result";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TestStepResult run(TestCaseRunner testRunner, TestCaseRunContext context) {
        SoapUI.ensureGroovyLog();
        WsdlTestStepResult result = new WsdlTestStepResult(this);
        Logger log = (Logger)context.getProperty("log");
        if (log == null) {
            log = logger;
        }
        try {
            try {
                TestRunner.Status testRunnerStatus;
                if (this.scriptText.trim().length() > 0) {
                    WsdlGroovyScriptTestStep wsdlGroovyScriptTestStep = this;
                    synchronized (wsdlGroovyScriptTestStep) {
                        this.scriptEngine.setVariable("context", context);
                        this.scriptEngine.setVariable("testRunner", testRunner);
                        this.scriptEngine.setVariable("log", log);
                        result.setTimeStamp(System.currentTimeMillis());
                        result.startTimer();
                        this.scriptResult = this.scriptEngine.run();
                        result.stopTimer();
                        if (this.scriptResult != null) {
                            result.addMessage("Script-result: " + this.scriptResult.toString());
                        }
                    }
                }
                if ((testRunnerStatus = testRunner.getStatus()) == TestRunner.Status.FAILED) {
                    result.setStatus(TestStepResult.TestStepStatus.FAILED);
                }
                if (testRunnerStatus == TestRunner.Status.CANCELED) {
                    result.setStatus(TestStepResult.TestStepStatus.CANCELED);
                }
                result.setStatus(TestStepResult.TestStepStatus.OK);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
                result.stopTimer();
                result.addMessage(e.getMessage());
                result.setError(e);
                result.setStatus(TestStepResult.TestStepStatus.FAILED);
                Object var8_8 = null;
                if (!this.isForLoadTest()) {
                    this.setIcon(result.getStatus() == TestStepResult.TestStepStatus.FAILED ? this.failedIcon : this.okIcon);
                }
                if (this.scriptEngine == null) return result;
                this.scriptEngine.clearVariables();
                return result;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!this.isForLoadTest()) {
                this.setIcon(result.getStatus() == TestStepResult.TestStepStatus.FAILED ? this.failedIcon : this.okIcon);
            }
            if (this.scriptEngine == null) throw throwable;
            this.scriptEngine.clearVariables();
            throw throwable;
        }
        if (!this.isForLoadTest()) {
            this.setIcon(result.getStatus() == TestStepResult.TestStepStatus.FAILED ? this.failedIcon : this.okIcon);
        }
        if (this.scriptEngine == null) return result;
        this.scriptEngine.clearVariables();
        return result;
    }

    public String getScript() {
        return this.scriptText;
    }

    public void setScript(String scriptText) {
        if (scriptText.equals(this.scriptText)) {
            return;
        }
        String oldScript = this.scriptText;
        this.scriptText = scriptText;
        this.scriptEngine.setScript(scriptText);
        this.saveScript((TestStepConfig)this.getConfig());
        this.notifyPropertyChanged("script", oldScript, scriptText);
    }

    public void release() {
        super.release();
        this.scriptEngine.release();
    }

    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this);
        result.extractAndAddAll("script");
        return result.toArray();
    }
}

