/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.testsuite.AssertedXPath;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.ResponseAssertedMessageExchange;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RestRequestStepResult
extends WsdlTestStepResult
implements ResponseAssertedMessageExchange,
AssertedXPathsContainer,
MessageExchangeTestStepResult {
    private String requestContent;
    private HttpResponse response;
    private String domain;
    private String username;
    private String endpoint;
    private String encoding;
    private String password;
    private StringToStringMap properties;
    private boolean addedAction;
    private List<AssertedXPath> assertedXPaths;

    public RestRequestStepResult(HttpTestRequestStepInterface step) {
        super((WsdlTestStep)((Object)step));
    }

    public Operation getOperation() {
        if (this.response == null) {
            this.response = null;
        }
        return this.response == null ? null : this.response.getRequest().getOperation();
    }

    public ModelItem getModelItem() {
        if (this.response != null) {
            return this.response.getRequest();
        }
        return null;
    }

    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        return this.requestContent;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public ActionList getActions() {
        if (!this.addedAction) {
            this.addAction(new ShowMessageExchangeAction(this, "TestStep"), true);
            this.addedAction = true;
        }
        return super.getActions();
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.addProperty("Domain", domain);
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.addProperty("Encoding", encoding);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.addProperty("Endpoint", endpoint);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("Password", password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.addProperty("Username", username);
    }

    public void discard() {
        super.discard();
        this.requestContent = null;
        this.response = null;
        this.properties = null;
        this.assertedXPaths = null;
    }

    public void writeTo(PrintWriter writer) {
        StringToStringMap headers;
        super.writeTo(writer);
        writer.println("\r\n----------------- Properties ------------------------------");
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key) == null) continue;
                writer.println(key + ": " + (String)this.properties.get(key));
            }
        }
        writer.println("\r\n---------------- Request ---------------------------");
        if (this.response != null) {
            headers = this.response.getRequestHeaders();
            for (String key : headers.keySet()) {
                if (headers.get(key) == null) continue;
                writer.println(key + ": " + (String)headers.get(key));
            }
        }
        if (StringUtils.hasContent(this.requestContent)) {
            writer.println("\r\n" + this.requestContent);
        } else {
            writer.println("\r\n- missing request / garbage collected -");
        }
        writer.println("\r\n---------------- Response --------------------------");
        if (this.response != null) {
            headers = this.response.getResponseHeaders();
            for (String key : headers.keySet()) {
                if (headers.get(key) == null) continue;
                writer.println(key + ": " + (String)headers.get(key));
            }
            String respContent = this.response.getContentAsString();
            if (respContent != null) {
                writer.println("\r\n" + respContent);
            }
        } else {
            writer.println("\r\n- missing response / garbage collected -");
        }
    }

    public StringToStringMap getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    public Attachment[] getRequestAttachments() {
        if (this.response == null || this.response.getRequest() == null) {
            return new Attachment[0];
        }
        return this.response.getRequest().getAttachments();
    }

    public StringToStringMap getRequestHeaders() {
        if (this.response == null) {
            return null;
        }
        return this.response.getRequestHeaders();
    }

    public Attachment[] getResponseAttachments() {
        if (this.response == null) {
            return new Attachment[0];
        }
        return this.response.getAttachments();
    }

    public String getResponseContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.response == null) {
            return "<missing response>";
        }
        return this.response.getContentAsString();
    }

    public String getRequestContentAsXml() {
        return XmlUtils.seemsToBeXml(this.requestContent) ? this.requestContent : "<not-xml/>";
    }

    public String getResponseContentAsXml() {
        return this.response.getContentAsXml();
    }

    public StringToStringMap getResponseHeaders() {
        if (this.response == null) {
            return null;
        }
        return this.response.getResponseHeaders();
    }

    public long getTimestamp() {
        if (this.isDiscarded() || this.response == null) {
            return -1L;
        }
        return this.response.getTimestamp();
    }

    public AssertedXPath[] getAssertedXPathsForResponse() {
        return this.assertedXPaths == null ? new AssertedXPath[]{} : this.assertedXPaths.toArray(new AssertedXPath[this.assertedXPaths.size()]);
    }

    public void addAssertedXPath(AssertedXPath assertedXPath) {
        if (this.assertedXPaths == null) {
            this.assertedXPaths = new ArrayList<AssertedXPath>();
        }
        this.assertedXPaths.add(assertedXPath);
    }

    public MessageExchange[] getMessageExchanges() {
        return new MessageExchange[]{this};
    }

    public byte[] getRawRequestData() {
        return this.response.getRawRequestData();
    }

    public byte[] getRawResponseData() {
        return this.response.getRawResponseData();
    }

    public Attachment[] getRequestAttachmentsForPart(String partName) {
        return null;
    }

    public Attachment[] getResponseAttachmentsForPart(String partName) {
        return null;
    }

    public boolean hasRawData() {
        return this.getRawResponseData() != null || this.getRawRequestData() != null;
    }

    public boolean hasRequest(boolean b) {
        return true;
    }

    public boolean hasResponse() {
        return this.response != null;
    }
}

