/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathPropertySupport {
    private final String propertyName;
    private final AbstractWsdlModelItem<?> modelItem;

    public AbstractPathPropertySupport(AbstractWsdlModelItem<?> modelItem, String propertyName) {
        this.modelItem = modelItem;
        this.propertyName = propertyName;
    }

    public String set(String value, boolean notify) {
        String old = this.get();
        value = PathUtils.relativizeResourcePath(value, this.modelItem);
        try {
            this.setPropertyValue(PathUtils.normalizePath(value));
            if (notify) {
                this.notifyUpdate(value, old);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return old;
    }

    public String get() {
        try {
            return this.getPropertyValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public AbstractWsdlModelItem<?> getModelItem() {
        return this.modelItem;
    }

    public abstract void setPropertyValue(String var1) throws Exception;

    protected void notifyUpdate(String value, String old) {
        this.modelItem.notifyPropertyChanged(this.modelItem.getClass().getName() + "@" + this.propertyName, old, value);
    }

    public String expand(TestCaseRunContext context) {
        try {
            return PathUtils.expandPath(this.getPropertyValue(), this.modelItem, context);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String expand() {
        try {
            return PathUtils.resolveResourcePath(this.getPropertyValue(), this.modelItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String expandUrl() {
        String result = this.expand();
        if (StringUtils.hasContent(result)) {
            try {
                result = PathUtils.isFilePath(result) && !result.startsWith("file:") ? new File(result).toURI().toURL().toString() : new URL(result).toString();
            }
            catch (MalformedURLException e) {
                SoapUI.logError(e);
            }
        }
        return result;
    }

    public abstract String getPropertyValue() throws Exception;

    public void resolveFile(ResolveContext<?> context, String errorDescription) {
        this.resolveFile(context, errorDescription, null, null, true);
    }

    public boolean containsPropertyExpansion() {
        try {
            return PropertyExpansionUtils.containsPropertyExpansion(this.getPropertyValue());
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
            return false;
        }
    }

    public void resolveFile(ResolveContext<?> context, String errorDescription, String extension, String fileType, final boolean notify) {
        block6: {
            if (this.containsPropertyExpansion()) {
                return;
            }
            String source = this.expand();
            if (StringUtils.hasContent(source)) {
                try {
                    new URL(source);
                }
                catch (Exception e) {
                    File file = new File(source);
                    if (!file.exists()) {
                        if (context.hasThisModelItem(this.modelItem, errorDescription, source)) {
                            return;
                        }
                        context.addPathToResolve(this.modelItem, errorDescription, source, new ResolveContext.FileResolver("Select File", extension, fileType, file.getParent()){

                            public boolean apply(File newFile) {
                                AbstractPathPropertySupport.this.set(newFile.getAbsolutePath(), notify);
                                return true;
                            }
                        });
                    }
                    if (!context.hasThisModelItem(this.modelItem, errorDescription, source)) break block6;
                    context.getPath(this.modelItem, errorDescription, source).setSolved(true);
                }
            }
        }
    }

    public void resolveFolder(ResolveContext<?> context, String errorDescription, final boolean notify) {
        block6: {
            if (this.containsPropertyExpansion()) {
                return;
            }
            String source = this.expand();
            if (StringUtils.hasContent(source)) {
                try {
                    new URL(source);
                }
                catch (Exception e) {
                    File file = new File(source);
                    if (!file.exists() || !file.isDirectory()) {
                        if (context.hasThisModelItem(this.modelItem, errorDescription, source)) {
                            return;
                        }
                        context.addPathToResolve(this.modelItem, errorDescription, source, new ResolveContext.DirectoryResolver("Select Directory", source){

                            public boolean apply(File newFile) {
                                AbstractPathPropertySupport.this.set(newFile.getAbsolutePath(), notify);
                                return true;
                            }
                        });
                    }
                    if (!context.hasThisModelItem(this.modelItem, errorDescription, source)) break block6;
                    context.getPath(this.modelItem, errorDescription, source).setSolved(true);
                }
            }
        }
    }
}

