/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.AbstractTestRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCaseRunner
extends AbstractTestRunner<WsdlTestCase, WsdlTestRunContext>
implements TestCaseRunner {
    private TestRunListener[] listeners = new TestRunListener[0];
    private List<TestStepResult> testStepResults = Collections.synchronizedList(new LinkedList());
    private int gotoStepIndex;
    private int resultCount;
    private int initCount;
    private int startStep = 0;

    public WsdlTestCaseRunner(WsdlTestCase testCase, StringToObjectMap properties) {
        super(testCase, properties);
    }

    @Override
    public WsdlTestRunContext createContext(StringToObjectMap properties) {
        return new WsdlTestRunContext(this, properties);
    }

    public int getStartStep() {
        return this.startStep;
    }

    public void setStartStep(int startStep) {
        this.startStep = startStep;
    }

    @Override
    public void onCancel(String reason) {
        TestStep currentStep = ((WsdlTestRunContext)this.getRunContext()).getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
    }

    @Override
    public void onFail(String reason) {
        TestStep currentStep = ((WsdlTestRunContext)this.getRunContext()).getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
    }

    @Override
    public void internalRun(WsdlTestRunContext runContext) throws Exception {
        int currentStepIndex;
        WsdlTestCase testCase = (WsdlTestCase)this.getTestRunnable();
        this.gotoStepIndex = -1;
        this.testStepResults.clear();
        if (testCase.getKeepSession()) {
            runContext.setProperty("#HTTP_STATE", new HttpState());
        }
        this.listeners = testCase.getTestRunListeners();
        testCase.runSetupScript(runContext, this);
        if (!this.isRunning()) {
            return;
        }
        if (testCase.getTimeout() > 0L) {
            this.startTimeoutTimer(testCase.getTimeout());
        }
        this.notifyBeforeRun();
        if (!this.isRunning()) {
            return;
        }
        this.initCount = 0;
        this.setStartTime();
        while (this.initCount < testCase.getTestStepCount() && this.isRunning()) {
            WsdlTestStep testStep = testCase.getTestStepAt(this.initCount);
            if (!testStep.isDisabled()) {
                try {
                    testStep.prepare(this, runContext);
                }
                catch (Exception e) {
                    this.setStatus(TestRunner.Status.FAILED);
                    SoapUI.logError(e);
                    throw new Exception("Failed to prepare testStep [" + testStep.getName() + "]; " + e.toString());
                }
            }
            ++this.initCount;
        }
        runContext.setCurrentStep(currentStepIndex);
        for (currentStepIndex = this.startStep; this.isRunning() && currentStepIndex < testCase.getTestStepCount(); ++currentStepIndex) {
            TestStep currentStep = runContext.getCurrentStep();
            if (!currentStep.isDisabled()) {
                TestStepResult stepResult = this.runTestStep(currentStep, true, true);
                if (stepResult == null) {
                    return;
                }
                if (!this.isRunning()) {
                    return;
                }
                if (this.gotoStepIndex != -1) {
                    currentStepIndex = this.gotoStepIndex - 1;
                    this.gotoStepIndex = -1;
                }
            }
            runContext.setCurrentStep(currentStepIndex + 1);
        }
        if (runContext.getProperty(TestRunner.Status.class.getName()) == TestRunner.Status.FAILED && testCase.getFailTestCaseOnErrors()) {
            this.fail("Failing due to failed test step");
        }
    }

    @Override
    protected void internalFinally(WsdlTestRunContext runContext) {
        WsdlTestCase testCase = (WsdlTestCase)this.getTestRunnable();
        for (int c = 0; c < this.initCount && c < testCase.getTestStepCount(); ++c) {
            WsdlTestStep testStep = testCase.getTestStepAt(c);
            if (testStep.isDisabled()) continue;
            testStep.finish(this, runContext);
        }
        try {
            testCase.runTearDownScript(runContext, this);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.notifyAfterRun();
        runContext.clear();
        this.listeners = null;
    }

    @Override
    public TestStepResult runTestStepByName(String name) {
        return this.runTestStep(this.getTestCase().getTestStepByName(name), true, true);
    }

    public TestStepResult runTestStep(TestStep testStep) {
        return this.runTestStep(testStep, true, true);
    }

    public TestStepResult runTestStep(TestStep testStep, boolean discard, boolean process) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeStep(this, (TestCaseRunContext)this.getRunContext(), testStep);
            if (this.isRunning()) continue;
            return null;
        }
        TestStepResult stepResult = testStep.run(this, (TestCaseRunContext)this.getRunContext());
        this.testStepResults.add(stepResult);
        ++this.resultCount;
        this.enforceMaxResults(((WsdlTestCase)this.getTestRunnable()).getMaxResults());
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterStep(this, (TestCaseRunContext)this.getRunContext(), stepResult);
        }
        if (discard && stepResult.getStatus() == TestStepResult.TestStepStatus.OK && ((WsdlTestCase)this.getTestRunnable()).getDiscardOkResults() && !stepResult.isDiscarded()) {
            stepResult.discard();
        }
        if (process && stepResult.getStatus() == TestStepResult.TestStepStatus.FAILED) {
            if (((WsdlTestCase)this.getTestRunnable()).getFailOnError()) {
                this.setError(stepResult.getError());
                this.fail("Cancelling due to failed test step");
            } else {
                ((WsdlTestRunContext)this.getRunContext()).setProperty(TestRunner.Status.class.getName(), (Object)TestRunner.Status.FAILED);
            }
        }
        return stepResult;
    }

    private void notifyAfterRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].afterRun(this, (TestCaseRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    private void notifyBeforeRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].beforeRun(this, (TestCaseRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    @Override
    public WsdlTestCase getTestCase() {
        return (WsdlTestCase)this.getTestRunnable();
    }

    @Override
    public long getTimeTaken() {
        long sum = 0L;
        for (int c = 0; c < this.testStepResults.size(); ++c) {
            TestStepResult testStepResult = this.testStepResults.get(c);
            if (testStepResult == null) continue;
            sum += testStepResult.getTimeTaken();
        }
        return sum;
    }

    @Override
    public List<TestStepResult> getResults() {
        return this.testStepResults;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    @Override
    public void gotoStep(int index) {
        this.gotoStepIndex = index;
    }

    public void enforceMaxResults(long maxResults) {
        if (maxResults < 1L) {
            return;
        }
        while ((long)this.testStepResults.size() > maxResults) {
            this.testStepResults.remove(0);
        }
    }

    @Override
    public void gotoStepByName(String stepName) {
        WsdlTestStep testStep = this.getTestCase().getTestStepByName(stepName);
        if (testStep != null) {
            this.gotoStep(this.getTestCase().getIndexOfTestStep(testStep));
        }
    }
}

