/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.definition.DefinitionLoader;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.SwingWorker;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;

public class UrlWsdlLoader
extends WsdlLoader
implements DefinitionLoader {
    private HttpState state;
    protected GetMethod getMethod;
    private boolean aborted;
    protected Map<String, byte[]> urlCache = new HashMap<String, byte[]>();
    protected boolean finished;
    private boolean useWorker;
    private ModelItem contextModelItem;
    private static Map<String, Credentials> cache = new HashMap<String, Credentials>();

    public UrlWsdlLoader(String url) {
        this(url, null);
    }

    public UrlWsdlLoader(String url, ModelItem contextModelItem) {
        super(url);
        this.contextModelItem = contextModelItem;
        this.state = new HttpState();
    }

    public boolean isUseWorker() {
        return this.useWorker;
    }

    public void setUseWorker(boolean useWorker) {
        this.useWorker = useWorker;
    }

    public InputStream load() throws Exception {
        return this.load(this.getBaseURI());
    }

    public synchronized InputStream load(String url) throws Exception {
        block17: {
            ByteArrayInputStream byteArrayInputStream;
            if (!PathUtils.isHttpPath(url)) {
                try {
                    File file = new File(url.replace('/', File.separatorChar));
                    if (file.exists()) {
                        url = file.toURI().toURL().toString();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.urlCache.containsKey(url)) {
                this.setNewBaseURI(url);
                return new ByteArrayInputStream(this.urlCache.get(url));
            }
            if (url.startsWith("file:")) {
                return this.handleFile(url);
            }
            log.debug((Object)("Getting wsdl component from [" + url + "]"));
            this.createGetMethod(url);
            if (this.aborted) {
                return null;
            }
            LoaderWorker worker = new LoaderWorker();
            if (this.useWorker) {
                worker.start();
            } else {
                worker.construct();
            }
            while (!this.aborted && !this.finished) {
                Thread.sleep(200L);
            }
            while (!this.aborted && this.getMethod.getResponseBody() == null) {
                Thread.sleep(200L);
            }
            try {
                if (this.aborted) {
                    throw new Exception("Load of url [" + url + "] was aborted");
                }
                byte[] content = this.getMethod.getResponseBody();
                if (content == null) break block17;
                String compressionAlg = HttpClientSupport.getResponseCompressionType((HttpMethod)this.getMethod);
                if (compressionAlg != null) {
                    content = CompressionSupport.decompress(compressionAlg, content);
                }
                this.urlCache.put(url, content);
                String newUrl = this.getMethod.getURI().getURI();
                if (!url.equals(newUrl)) {
                    log.info((Object)("BaseURI was redirected to [" + newUrl + "]"));
                }
                this.setNewBaseURI(newUrl);
                this.urlCache.put(newUrl, content);
                byteArrayInputStream = new ByteArrayInputStream(content);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.getMethod.releaseConnection();
                throw throwable;
            }
            this.getMethod.releaseConnection();
            return byteArrayInputStream;
        }
        throw new Exception("Failed to load url; " + this.getMethod.getStatusCode() + " - " + this.getMethod.getStatusText());
    }

    protected InputStream handleFile(String url) throws IOException {
        this.setNewBaseURI(url);
        return new URL(url).openStream();
    }

    protected void createGetMethod(String url) {
        this.getMethod = new GetMethod(url);
        this.getMethod.setFollowRedirects(true);
        this.getMethod.setDoAuthentication(true);
        this.getMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new WsdlCredentialsProvider());
        if (SoapUI.getSettings().getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY)) {
            HttpClientSupport.getHttpClient().getParams().setAuthenticationPreemptive(true);
        } else {
            HttpClientSupport.getHttpClient().getParams().setAuthenticationPreemptive(false);
        }
    }

    public boolean abort() {
        if (this.getMethod != null) {
            this.getMethod.abort();
        }
        this.aborted = true;
        return true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void close() {
    }

    public final class WsdlCredentialsProvider
    implements CredentialsProvider {
        private XFormDialog basicDialog;
        private XFormDialog ntDialog;

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String key = String.valueOf(authscheme) + "-" + host + "-" + port + "-" + proxy;
            if (cache.containsKey(key)) {
                return (Credentials)cache.get(key);
            }
            if (authscheme == null) {
                return null;
            }
            try {
                String pw = UrlWsdlLoader.this.getPassword();
                if (pw == null) {
                    pw = "";
                }
                if (authscheme instanceof NTLMScheme) {
                    if (UrlWsdlLoader.this.hasCredentials()) {
                        WsdlLoader.log.info((Object)"Returning url credentials");
                        return new NTCredentials(UrlWsdlLoader.this.getUsername(), pw, host, null);
                    }
                    WsdlLoader.log.info((Object)(host + ":" + port + " requires Windows authentication"));
                    if (this.ntDialog == null) {
                        this.buildNtDialog();
                    }
                    StringToStringMap values = new StringToStringMap();
                    values.put("Info", "Authentication required for [" + host + ":" + port + "]");
                    this.ntDialog.setValues(values);
                    if (this.ntDialog.show()) {
                        values = this.ntDialog.getValues();
                        NTCredentials credentials = new NTCredentials((String)values.get("Username"), (String)values.get("Password"), host, (String)values.get("Domain"));
                        cache.put(key, credentials);
                        return credentials;
                    }
                    throw new CredentialsNotAvailableException("Operation cancelled");
                }
                if (authscheme instanceof RFC2617Scheme) {
                    if (UrlWsdlLoader.this.hasCredentials()) {
                        WsdlLoader.log.info((Object)"Returning url credentials");
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(UrlWsdlLoader.this.getUsername(), pw);
                        cache.put(key, credentials);
                        return credentials;
                    }
                    WsdlLoader.log.info((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'"));
                    ShowDialog showDialog = new ShowDialog();
                    showDialog.values.put("Info", "Authentication required for [" + host + ":" + port + "]");
                    UISupport.getUIUtils().runInUIThreadIfSWT(showDialog);
                    if (showDialog.result) {
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)showDialog.values.get("Username"), (String)showDialog.values.get("Password"));
                        cache.put(key, credentials);
                        return credentials;
                    }
                    throw new CredentialsNotAvailableException("Operation cancelled");
                }
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }

        private void buildBasicDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Basic Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            this.basicDialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify Basic Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        private void buildNtDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("NT Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            mainForm.addTextField("Domain", "NT Domain for authentication", XForm.FieldType.TEXT);
            this.ntDialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify NT Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        private class ShowDialog
        implements Runnable {
            StringToStringMap values = new StringToStringMap();
            boolean result;

            private ShowDialog() {
            }

            public void run() {
                if (WsdlCredentialsProvider.this.basicDialog == null) {
                    WsdlCredentialsProvider.this.buildBasicDialog();
                }
                WsdlCredentialsProvider.this.basicDialog.setValues(this.values);
                this.result = WsdlCredentialsProvider.this.basicDialog.show();
                if (this.result) {
                    this.values = WsdlCredentialsProvider.this.basicDialog.getValues();
                }
            }
        }
    }

    public final class LoaderWorker
    extends SwingWorker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            HttpClient httpClient = HttpClientSupport.getHttpClient();
            try {
                try {
                    Settings soapuiSettings = SoapUI.getSettings();
                    HttpClientSupport.applyHttpSettings((HttpMethod)UrlWsdlLoader.this.getMethod, soapuiSettings);
                    HostConfiguration hostConfiguration = ProxyUtils.initProxySettings(soapuiSettings, UrlWsdlLoader.this.state, new HostConfiguration(), UrlWsdlLoader.this.getMethod.getURI().toString(), UrlWsdlLoader.this.contextModelItem == null ? null : new DefaultPropertyExpansionContext(UrlWsdlLoader.this.contextModelItem));
                    httpClient.executeMethod(hostConfiguration, (HttpMethod)UrlWsdlLoader.this.getMethod, UrlWsdlLoader.this.state);
                }
                catch (Exception e) {
                    Exception exception = e;
                    Object var5_7 = null;
                    UrlWsdlLoader.this.finished = true;
                    return exception;
                }
                Object var5_6 = null;
                UrlWsdlLoader.this.finished = true;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                UrlWsdlLoader.this.finished = true;
                throw throwable;
            }
            return null;
        }
    }
}

