/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsa;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AnonymousTypeConfig;
import com.eviware.soapui.config.MustUnderstandTypeConfig;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaContainer;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaValidator;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WsaUtils {
    public static final String WS_A_NAMESPACE_200508 = "http://www.w3.org/2005/08/addressing";
    public static final String WS_A_NAMESPACE_200408 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    public static final String WS_A_NAMESPACE_200602 = "http://www.w3.org/2006/02/addressing/wsdl";
    public static final String WS_A_NAMESPACE_200605 = "http://www.w3.org/2006/05/addressing/wsdl";
    public static final String WS_A_NAMESPACE_200705 = "http://www.w3.org/2007/05/addressing/metadata";
    public static final String[] wsaNamespaces = new String[]{"http://www.w3.org/2007/05/addressing/metadata", "http://www.w3.org/2005/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://www.w3.org/2006/05/addressing/wsdl", "http://www.w3.org/2006/02/addressing/wsdl"};
    SoapVersion soapVersion;
    WsdlOperation operation;
    WsaBuilder builder;
    XmlObject xmlContentObject;
    Element envelopeElement;
    String wsaVersionNameSpace;
    String wsaPrefix = null;
    String wsaVersionNamespaceOld = null;
    String anonymousType;
    String anonymousAddress;
    String noneAddress;
    String relationshipTypeReply;
    String unspecifiedMessage;
    String content;
    XmlObject xmlHeaderObject;
    ArrayList<Node> headerWsaElementList;
    private final PropertyExpansionContext context;

    public WsaUtils(String content, SoapVersion soapVersion, WsdlOperation operation, PropertyExpansionContext context) {
        this.soapVersion = soapVersion;
        this.operation = operation;
        this.content = content;
        this.context = context;
        try {
            this.xmlContentObject = XmlObject.Factory.parse((String)content);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private Element getHeader(WsaContainer wsaContainer) throws XmlException {
        this.wsaVersionNameSpace = WS_A_NAMESPACE_200508;
        if (wsaContainer.getWsaConfig().getVersion().equals(WsaVersionTypeConfig.X_200408.toString())) {
            this.wsaVersionNameSpace = WS_A_NAMESPACE_200408;
        }
        this.anonymousAddress = this.wsaVersionNameSpace + "/anonymous";
        this.noneAddress = this.wsaVersionNameSpace + "/none";
        this.relationshipTypeReply = this.wsaVersionNameSpace + "/reply";
        this.unspecifiedMessage = this.wsaVersionNameSpace + "/unspecified";
        this.anonymousType = wsaContainer.getOperation().getAnonymous();
        if (this.anonymousType.equals(AnonymousTypeConfig.OPTIONAL.toString())) {
            this.anonymousType = wsaContainer.getOperation().getInterface().getAnonymous();
        }
        Element header = (Element)SoapUtils.getHeaderElement(this.xmlContentObject, this.soapVersion, true).getDomNode();
        this.wsaPrefix = XmlUtils.findPrefixForNamespace(header, WS_A_NAMESPACE_200508);
        if (this.wsaPrefix != null) {
            this.wsaVersionNamespaceOld = WS_A_NAMESPACE_200508;
        } else {
            this.wsaPrefix = XmlUtils.findPrefixForNamespace(header, WS_A_NAMESPACE_200408);
            if (this.wsaPrefix != null) {
                this.wsaVersionNamespaceOld = WS_A_NAMESPACE_200408;
            } else {
                this.wsaPrefix = XmlUtils.findPrefixForNamespace(header, WS_A_NAMESPACE_200508);
                if (this.wsaPrefix != null) {
                    this.wsaVersionNamespaceOld = WS_A_NAMESPACE_200508;
                } else {
                    this.wsaPrefix = XmlUtils.findPrefixForNamespace(header, WS_A_NAMESPACE_200408);
                    if (this.wsaPrefix != null) {
                        this.wsaVersionNamespaceOld = WS_A_NAMESPACE_200408;
                    } else {
                        this.wsaPrefix = "wsa";
                    }
                }
            }
        }
        XmlObject[] envelope = this.xmlContentObject.selectChildren(this.soapVersion.getEnvelopeQName());
        this.envelopeElement = (Element)envelope[0].getDomNode();
        Boolean mustUnderstand = null;
        if (wsaContainer.getWsaConfig().getMustUnderstand().equals(MustUnderstandTypeConfig.FALSE.toString())) {
            mustUnderstand = false;
        } else if (wsaContainer.getWsaConfig().getMustUnderstand().equals(MustUnderstandTypeConfig.TRUE.toString())) {
            mustUnderstand = true;
        }
        this.builder = new WsaBuilder(this.wsaVersionNameSpace, mustUnderstand);
        return header;
    }

    private Node getWsaProperty(Element header, String elementLocalName) {
        NodeList elmList = header.getElementsByTagName(elementLocalName);
        Node elm = null;
        if (elmList.getLength() > 0) {
            elm = elmList.item(0);
        }
        return elm;
    }

    private Element removeWsaProperty(boolean overrideExisting, Element header, String elementLocalName) {
        if (overrideExisting) {
            NodeList elmList = header.getElementsByTagName(elementLocalName);
            Node elm = null;
            if (elmList.getLength() > 0) {
                elm = elmList.item(0);
            }
            if (elm != null) {
                header.removeChild(elm);
            }
        }
        return header;
    }

    private Element processWsaProperty(Element header, boolean override, String elementLocalName, String wsaPropValue, boolean address, String refParamsContent) {
        boolean existsWsa;
        boolean bl = existsWsa = this.getWsaProperty(header, elementLocalName) != null;
        if (override) {
            if (existsWsa) {
                header = this.removeWsaProperty(override, header, elementLocalName);
            }
            if (address) {
                header.appendChild(this.builder.createWsaAddressChildElement(elementLocalName, this.envelopeElement, wsaPropValue, refParamsContent));
            } else {
                header.appendChild(this.builder.createWsaChildElement(elementLocalName, this.envelopeElement, wsaPropValue));
            }
        } else if (!existsWsa) {
            if (address) {
                header.appendChild(this.builder.createWsaAddressChildElement(elementLocalName, this.envelopeElement, wsaPropValue, refParamsContent));
            } else {
                header.appendChild(this.builder.createWsaChildElement(elementLocalName, this.envelopeElement, wsaPropValue));
            }
        }
        return header;
    }

    private Element processWsaProperty(Element header, boolean override, String elementLocalName, String wsaPropValue, boolean address) {
        return this.processWsaProperty(header, override, elementLocalName, wsaPropValue, address, null);
    }

    private Element processWsaRelatesToProperty(Element header, boolean override, String elementLocalName, String relationshipType, String relatesTo) {
        boolean existsWsa;
        boolean bl = existsWsa = this.getWsaProperty(header, elementLocalName) != null;
        if (override) {
            if (existsWsa) {
                header = this.removeWsaProperty(override, header, elementLocalName);
            }
            header.appendChild(this.builder.createRelatesToElement(this.wsaPrefix + ":RelatesTo", this.envelopeElement, relationshipType, relatesTo));
        } else if (!existsWsa) {
            header.appendChild(this.builder.createRelatesToElement(this.wsaPrefix + ":RelatesTo", this.envelopeElement, relationshipType, relatesTo));
        }
        return header;
    }

    public String removeWSAddressing(WsaContainer wsaContainer) {
        try {
            Element header = this.getHeader(wsaContainer);
            NodeList headerProps = XmlUtils.getChildElements(header);
            for (int i = 0; i < headerProps.getLength(); ++i) {
                Node headerChild = headerProps.item(i);
                if (!headerChild.getNamespaceURI().equals(this.wsaVersionNameSpace)) continue;
                header.removeChild(headerChild);
            }
            this.content = this.xmlContentObject.xmlText();
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
        return this.content;
    }

    public String addWSAddressingRequest(WsaContainer wsaContainer) {
        return this.addWSAddressingRequest(wsaContainer, null);
    }

    public String addWSAddressingRequest(WsaContainer wsaContainer, ExtendedHttpMethod httpMethod) {
        return this.createNewWSAddressingRequest(wsaContainer, httpMethod, SoapUI.getSettings().getBoolean(WsaSettings.OVERRIDE_EXISTING_HEADERS));
    }

    private String createNewWSAddressingRequest(WsaContainer wsaContainer, ExtendedHttpMethod httpMethod, boolean override) {
        try {
            Element header = this.getHeader(wsaContainer);
            if (override || this.wsaVersionNamespaceOld == null) {
                header.setAttribute("xmlns:" + this.wsaPrefix, this.wsaVersionNameSpace);
            }
            String action = null;
            action = wsaContainer.getWsaConfig().isAddDefaultAction() ? WsdlUtils.getDefaultWsaAction(wsaContainer.getOperation(), false) : PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getAction());
            if (!StringUtils.isNullOrEmpty(action)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":Action", action, false);
            }
            String replyTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getReplyTo());
            String replyToRefParams = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getReplyToRefParams());
            if (AnonymousTypeConfig.REQUIRED.toString().equals(this.anonymousType)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":ReplyTo", this.anonymousAddress, true, replyToRefParams);
            } else if (!(StringUtils.isNullOrEmpty(replyTo) || AnonymousTypeConfig.PROHIBITED.toString().equals(this.anonymousType) && WsaUtils.isAnonymousAddress(replyTo, this.wsaVersionNameSpace))) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":ReplyTo", replyTo, true, replyToRefParams);
            }
            String from = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFrom());
            if (!StringUtils.isNullOrEmpty(from)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":From", from, true);
            }
            String faultTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFaultTo());
            String faultToRefParams = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFaultToRefParams());
            if (!StringUtils.isNullOrEmpty(faultTo)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":FaultTo", faultTo, true, faultToRefParams);
            }
            String relatesTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getRelatesTo());
            String relationshipType = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getRelationshipType());
            if (!StringUtils.isNullOrEmpty(relationshipType) && !StringUtils.isNullOrEmpty(relatesTo)) {
                header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", relationshipType, relatesTo);
            }
            if (wsaContainer.getWsaConfig().isGenerateMessageId()) {
                String generatedMessageId = "uuid:" + UUID.randomUUID().toString();
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":MessageID", generatedMessageId, false);
            } else {
                String msgId = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getMessageID());
                if (!StringUtils.isNullOrEmpty(msgId)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":MessageID", msgId, false);
                }
            }
            if (httpMethod != null && wsaContainer.getWsaConfig().isAddDefaultTo()) {
                String defaultTo = httpMethod.getURI().toString();
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":To", defaultTo, false);
            } else {
                String to = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getTo());
                if (!StringUtils.isNullOrEmpty(to)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":To", to, false);
                }
            }
            this.content = this.xmlContentObject.xmlText();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return this.content;
    }

    public String addWSAddressingMockResponse(WsaContainer wsaContainer) {
        return this.addWSAddressingMockResponse(wsaContainer, null);
    }

    public String addWSAddressingMockResponse(WsaContainer wsaContainer, WsdlMockRequest request) {
        return this.createWSAddressingMockResponse(wsaContainer, request, SoapUI.getSettings().getBoolean(WsaSettings.OVERRIDE_EXISTING_HEADERS));
    }

    private String createWSAddressingMockResponse(WsaContainer wsaContainer, WsdlMockRequest request, boolean override) {
        try {
            Element header = this.getHeader(wsaContainer);
            if (override || this.wsaVersionNamespaceOld == null) {
                header.setAttribute("xmlns:" + this.wsaPrefix, this.wsaVersionNameSpace);
            }
            String action = null;
            action = wsaContainer.getWsaConfig().isAddDefaultAction() ? WsdlUtils.getDefaultWsaAction(wsaContainer.getOperation(), true) : PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getAction());
            if (!StringUtils.isNullOrEmpty(action)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":Action", action, false);
            }
            if (AnonymousTypeConfig.REQUIRED.toString().equals(this.anonymousType)) {
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":ReplyTo", this.anonymousAddress, true);
            } else {
                String replyTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getReplyTo());
                String replyToRefParams = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getReplyToRefParams());
                if (!StringUtils.isNullOrEmpty(replyTo)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":ReplyTo", replyTo, true, replyToRefParams);
                }
            }
            Element requestHeader = null;
            if (request != null) {
                String to;
                Element replyToAddresseNode;
                String relationshipType;
                String from;
                XmlObject requestXmlObject = request.getRequestXmlObject();
                String requestWsaVersionNameSpace = WsaValidator.getWsaVersion(requestXmlObject, request.getSoapVersion());
                requestHeader = (Element)SoapUtils.getHeaderElement(requestXmlObject, request.getSoapVersion(), true).getDomNode();
                Element msgNode = XmlUtils.getFirstChildElementNS(requestHeader, requestWsaVersionNameSpace, "MessageID");
                String requestMessageId = null;
                if (msgNode != null) {
                    requestMessageId = XmlUtils.getElementText(msgNode);
                }
                if (!StringUtils.isNullOrEmpty(from = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFrom()))) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":From", from, true);
                }
                String faultTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFaultTo());
                String faultToRefParams = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getFaultToRefParams());
                if (!StringUtils.isNullOrEmpty(faultTo)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":FaultTo", faultTo, true, faultToRefParams);
                }
                if (!StringUtils.isNullOrEmpty(relationshipType = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getRelationshipType()))) {
                    if (!StringUtils.isNullOrEmpty(requestMessageId)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", relationshipType, requestMessageId);
                    } else if (SoapUI.getSettings().getBoolean(WsaSettings.USE_DEFAULT_RELATES_TO)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", relationshipType, this.unspecifiedMessage);
                    }
                } else if (wsaContainer instanceof WsdlMockResponse && SoapUI.getSettings().getBoolean(WsaSettings.USE_DEFAULT_RELATIONSHIP_TYPE)) {
                    if (!StringUtils.isNullOrEmpty(requestMessageId)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", this.relationshipTypeReply, requestMessageId);
                    } else if (SoapUI.getSettings().getBoolean(WsaSettings.USE_DEFAULT_RELATES_TO)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", this.relationshipTypeReply, this.unspecifiedMessage);
                    }
                }
                Element replyToNode = XmlUtils.getFirstChildElementNS(requestHeader, requestWsaVersionNameSpace, "ReplyTo");
                String requestReplyToValue = null;
                if (replyToNode != null && (replyToAddresseNode = XmlUtils.getFirstChildElementNS(replyToNode, requestWsaVersionNameSpace, "Address")) != null) {
                    requestReplyToValue = XmlUtils.getElementText(replyToAddresseNode);
                }
                if (!StringUtils.isNullOrEmpty(to = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getTo()))) {
                    if (!AnonymousTypeConfig.PROHIBITED.toString().equals(this.anonymousType) || !WsaUtils.isAnonymousAddress(to, this.wsaVersionNameSpace)) {
                        header = this.processWsaProperty(header, override, this.wsaPrefix + ":To", to, false);
                    }
                } else if (!(StringUtils.isNullOrEmpty(requestReplyToValue) || AnonymousTypeConfig.PROHIBITED.toString().equals(this.anonymousType) && WsaUtils.isAnonymousAddress(requestReplyToValue, this.wsaVersionNameSpace))) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":To", requestReplyToValue, false);
                }
            } else {
                String to = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getTo());
                if (!StringUtils.isNullOrEmpty(to)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":To", to, false);
                }
                String relationshipType = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getRelationshipType());
                String relatesTo = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getRelatesTo());
                if (!StringUtils.isNullOrEmpty(relationshipType) && !StringUtils.isNullOrEmpty(relatesTo)) {
                    header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", relationshipType, relatesTo);
                } else if (wsaContainer instanceof WsdlMockResponse && SoapUI.getSettings().getBoolean(WsaSettings.USE_DEFAULT_RELATIONSHIP_TYPE)) {
                    if (!StringUtils.isNullOrEmpty(relatesTo)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", this.relationshipTypeReply, relatesTo);
                    } else if (SoapUI.getSettings().getBoolean(WsaSettings.USE_DEFAULT_RELATES_TO)) {
                        header = this.processWsaRelatesToProperty(header, override, this.wsaPrefix + ":RelatesTo", this.relationshipTypeReply, this.unspecifiedMessage);
                    }
                }
            }
            if (wsaContainer.getWsaConfig().isGenerateMessageId()) {
                String generatedMessageId = "uuid:" + UUID.randomUUID().toString();
                header = this.processWsaProperty(header, override, this.wsaPrefix + ":MessageID", generatedMessageId, false);
            } else {
                String msgId = PropertyExpander.expandProperties(this.context, wsaContainer.getWsaConfig().getMessageID());
                if (!StringUtils.isNullOrEmpty(msgId)) {
                    header = this.processWsaProperty(header, override, this.wsaPrefix + ":MessageID", msgId, false);
                }
            }
            this.content = this.xmlContentObject.xmlText();
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
        return this.content;
    }

    public static boolean isAnonymousAddress(String address, String wsaVersionNamespace) {
        return address.equals(wsaVersionNamespace + "/anonymous");
    }

    public static boolean isNoneAddress(String address, String wsaVersionNamespace) {
        return address.equals(wsaVersionNamespace + "/none");
    }

    public static String getNamespace(String Version2) {
        if (Version2.equals(WsaVersionTypeConfig.X_200408.toString())) {
            return WS_A_NAMESPACE_200408;
        }
        return WS_A_NAMESPACE_200508;
    }

    public class WsaBuilder {
        private final String wsaVersionNameSpace;
        private final Boolean mustUnderstand;

        public WsaBuilder(String wsaVersionNameSpace, Boolean mustUnderstand) {
            this.wsaVersionNameSpace = wsaVersionNameSpace;
            this.mustUnderstand = mustUnderstand;
        }

        public Element createWsaChildElement(String elementName, Element addToElement, String wsaProperty) {
            Element wsaElm = addToElement.getOwnerDocument().createElementNS(this.wsaVersionNameSpace, elementName);
            Text txtElm = addToElement.getOwnerDocument().createTextNode(wsaProperty);
            if (this.mustUnderstand != null) {
                wsaElm.setAttributeNS(WsaUtils.this.soapVersion.getEnvelopeNamespace(), "mustUnderstand", this.mustUnderstand != false ? "1" : "0");
            }
            wsaElm.appendChild(txtElm);
            return wsaElm;
        }

        public Element createWsaAddressChildElement(String elementName, Element addToElement, String wsaProperty, String refParamsContent) {
            Document document = addToElement.getOwnerDocument();
            Element wsAddressElm = document.createElementNS(this.wsaVersionNameSpace, WsaUtils.this.wsaPrefix + ":Address");
            Element wsaElm = document.createElementNS(this.wsaVersionNameSpace, elementName);
            Text propertyContent = document.createTextNode(wsaProperty);
            if (this.mustUnderstand != null) {
                wsaElm.setAttributeNS(WsaUtils.this.soapVersion.getEnvelopeNamespace(), "mustUnderstand", this.mustUnderstand != false ? "1" : "0");
            }
            wsAddressElm.appendChild(propertyContent);
            wsaElm.appendChild(wsAddressElm);
            try {
                if (refParamsContent != null) {
                    Element refParamsElm = document.createElementNS(this.wsaVersionNameSpace, WsaUtils.this.wsaPrefix + ":ReferenceParameters");
                    refParamsContent = "<dummy>" + refParamsContent + "</dummy>";
                    Node xx = document.importNode(XmlUtils.parseXml(refParamsContent).getDocumentElement(), true);
                    NodeList xxList = xx.getChildNodes();
                    for (int i = 0; i < xxList.getLength(); ++i) {
                        refParamsElm.appendChild(xxList.item(i));
                    }
                    wsaElm.appendChild(refParamsElm);
                }
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return wsaElm;
        }

        public Element createRelatesToElement(String elementName, Element addToElement, String relationshipType, String relatesTo) {
            Element wsaElm = addToElement.getOwnerDocument().createElementNS(this.wsaVersionNameSpace, elementName);
            wsaElm.setAttribute("RelationshipType", relationshipType);
            Text txtElm = addToElement.getOwnerDocument().createTextNode(relatesTo);
            if (this.mustUnderstand != null) {
                wsaElm.setAttributeNS(WsaUtils.this.soapVersion.getEnvelopeNamespace(), "mustUnderstand", this.mustUnderstand != false ? "1" : "0");
            }
            wsaElm.appendChild(txtElm);
            return wsaElm;
        }
    }
}

