/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.support.soap.AbstractSoapVersion;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUtils {
    public static boolean isSoapFault(String responseContent, SoapVersion soapVersion) throws XmlException {
        XmlObject xml;
        XmlObject[] paths;
        if (StringUtils.isNullOrEmpty(responseContent)) {
            return false;
        }
        return (responseContent.indexOf(":Fault") > 0 || responseContent.indexOf("<Fault") > 0) && (paths = (xml = XmlObject.Factory.parse((String)responseContent)).selectPath("declare namespace env='" + soapVersion.getEnvelopeNamespace() + "';" + "//env:Fault")).length > 0;
    }

    public static SoapVersion deduceSoapVersion(String contentType, XmlObject xmlObject) {
        Element elm;
        if (xmlObject != null && (elm = ((Document)xmlObject.getDomNode()).getDocumentElement()).getLocalName().equals("Envelope")) {
            if (elm.getNamespaceURI().equals(SoapVersion.Soap11.getEnvelopeNamespace())) {
                return SoapVersion.Soap11;
            }
            if (elm.getNamespaceURI().equals(SoapVersion.Soap12.getEnvelopeNamespace())) {
                return SoapVersion.Soap12;
            }
        }
        AbstractSoapVersion soapVersion = null;
        if (StringUtils.isNullOrEmpty(contentType)) {
            return null;
        }
        soapVersion = contentType.startsWith(SoapVersion.Soap11.getContentType()) ? SoapVersion.Soap11 : null;
        AbstractSoapVersion abstractSoapVersion = soapVersion = soapVersion == null && contentType.startsWith(SoapVersion.Soap12.getContentType()) ? SoapVersion.Soap12 : soapVersion;
        if (soapVersion == null && contentType.startsWith("application/xop+xml")) {
            if (contentType.indexOf("type=\"" + SoapVersion.Soap11.getContentType() + "\"") > 0) {
                soapVersion = SoapVersion.Soap11;
            } else if (contentType.indexOf("type=\"" + SoapVersion.Soap12.getContentType() + "\"") > 0) {
                soapVersion = SoapVersion.Soap12;
            }
        }
        return soapVersion;
    }

    public static String getSoapAction(SoapVersion soapVersion, StringToStringMap headers) {
        int ix;
        String soapAction = null;
        String contentType = (String)headers.get("Content-Type");
        if (soapVersion == SoapVersion.Soap11) {
            soapAction = (String)headers.get("SOAPAction");
        } else if (soapVersion == SoapVersion.Soap12 && (ix = contentType.indexOf("action=")) > 0) {
            int endIx = contentType.indexOf(59, ix);
            soapAction = endIx == -1 ? contentType.substring(ix + 7) : contentType.substring(ix + 7, endIx);
        }
        soapAction = StringUtils.unquote(soapAction);
        return soapAction;
    }

    public static XmlObject getBodyElement(XmlObject messageObject, SoapVersion soapVersion) throws XmlException {
        XmlObject[] envelope = messageObject.selectChildren(soapVersion.getEnvelopeQName());
        if (envelope.length != 1) {
            throw new XmlException("Missing/Invalid SOAP Envelope, expecting [" + soapVersion.getEnvelopeQName() + "]");
        }
        XmlObject[] body = envelope[0].selectChildren(soapVersion.getBodyQName());
        if (body.length != 1) {
            throw new XmlException("Missing/Invalid SOAP Body, expecting [" + soapVersion.getBodyQName() + "]");
        }
        return body[0];
    }

    public static XmlObject getHeaderElement(XmlObject messageObject, SoapVersion soapVersion, boolean create) throws XmlException {
        XmlObject[] envelope = messageObject.selectChildren(soapVersion.getEnvelopeQName());
        if (envelope.length != 1) {
            throw new XmlException("Missing/Invalid SOAP Envelope, expecting [" + soapVersion.getEnvelopeQName() + "]");
        }
        QName headerQName = soapVersion.getHeaderQName();
        XmlObject[] header = envelope[0].selectChildren(headerQName);
        if (header.length == 0 && create) {
            Element elm = (Element)envelope[0].getDomNode();
            Element headerElement = elm.getOwnerDocument().createElementNS(headerQName.getNamespaceURI(), headerQName.getLocalPart());
            elm.insertBefore(headerElement, elm.getFirstChild());
            header = envelope[0].selectChildren(headerQName);
        }
        return header.length == 0 ? null : header[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XmlObject getContentElement(XmlObject messageObject, SoapVersion soapVersion) throws XmlException {
        XmlCursor cursor;
        block7: {
            XmlObject xmlObject;
            XmlObject bodyElement = SoapUtils.getBodyElement(messageObject, soapVersion);
            if (bodyElement == null) return null;
            cursor = bodyElement.newCursor();
            try {
                try {
                    if (!cursor.toFirstChild()) break block7;
                    while (!cursor.isContainer()) {
                        cursor.toNextSibling();
                    }
                    if (!cursor.isContainer()) break block7;
                    xmlObject = cursor.getObject();
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var6_8 = null;
                    cursor.dispose();
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                cursor.dispose();
                throw throwable;
            }
            cursor.dispose();
            return xmlObject;
        }
        Object var6_7 = null;
        cursor.dispose();
        return null;
    }

    public static WsdlOperation findOperationForRequest(SoapVersion soapVersion, String soapAction, XmlObject requestContent, List<WsdlOperation> operations, boolean requireSoapVersionMatch, boolean requireSoapActionMatch, Attachment[] attachments) throws Exception {
        XmlObject contentElm = SoapUtils.getContentElement(requestContent, soapVersion);
        if (contentElm == null) {
            for (WsdlOperation operation : operations) {
                if (!operation.getAction().equals(soapAction) || operation.getBindingOperation().getOperation().getInput().getMessage().getParts().size() != 0) continue;
                return operation;
            }
        }
        QName contentQName = XmlUtils.getQName(contentElm.getDomNode());
        NodeList contentChildNodes = null;
        for (int c = 0; c < operations.size(); ++c) {
            List parts;
            Message message;
            BindingOperation bindingOperation;
            QName qname;
            WsdlOperation wsdlOperation = operations.get(c);
            String action = wsdlOperation.getAction();
            if (requireSoapActionMatch && (soapAction != null || wsdlOperation.getAction() != null) && (action == null || !action.equals(soapAction)) || !contentQName.equals(qname = wsdlOperation.getRequestBodyElementQName())) continue;
            SoapVersion ifaceSoapVersion = wsdlOperation.getInterface().getSoapVersion();
            if (requireSoapVersionMatch && ifaceSoapVersion != soapVersion) continue;
            if (wsdlOperation.getStyle().equals("Document")) {
                bindingOperation = wsdlOperation.getBindingOperation();
                message = bindingOperation.getOperation().getInput().getMessage();
                parts = message.getOrderedParts(null);
                for (int x = 0; x < parts.size(); ++x) {
                    if (WsdlUtils.isAttachmentInputPart((Part)parts.get(x), bindingOperation)) {
                        for (Attachment attachment : attachments) {
                            if (!attachment.getPart().equals(((Part)parts.get(x)).getName())) continue;
                            parts.remove(x);
                            --x;
                        }
                        continue;
                    }
                    parts.remove(x);
                    --x;
                }
                if (!parts.isEmpty()) continue;
                return wsdlOperation;
            }
            if (!wsdlOperation.getStyle().equals("RPC")) continue;
            bindingOperation = wsdlOperation.getBindingOperation();
            message = bindingOperation.getOperation().getInput().getMessage();
            parts = message.getOrderedParts(null);
            if (contentChildNodes == null) {
                contentChildNodes = XmlUtils.getChildElements((Element)contentElm.getDomNode());
            }
            int i = 0;
            if (parts.size() > 0) {
                for (int x = 0; x < parts.size(); ++x) {
                    if (WsdlUtils.isAttachmentInputPart((Part)parts.get(x), bindingOperation)) {
                        for (Attachment attachment : attachments) {
                            if (!attachment.getPart().equals(((Part)parts.get(x)).getName())) continue;
                            parts.remove(x);
                            --x;
                        }
                    }
                    if (x < 0 || !WsdlUtils.isHeaderInputPart((Part)parts.get(x), message, bindingOperation)) continue;
                    parts.remove(x);
                    --x;
                }
                while (i < contentChildNodes.getLength() && !parts.isEmpty()) {
                    Node item = contentChildNodes.item(i);
                    if (item.getNodeType() == 1) {
                        int j;
                        for (j = 0; j < parts.size() && !item.getNodeName().equals(((Part)parts.get(j)).getName()); ++j) {
                            Part part = (Part)parts.get(j);
                            if (part.getElementName() != null) {
                                QName qn = part.getElementName();
                                if (!item.getLocalName().equals(qn.getLocalPart()) || !item.getNamespaceURI().equals(qn.getNamespaceURI())) continue;
                                break;
                            }
                            if (item.getNodeName().equals(((Part)parts.get(j)).getName())) break;
                        }
                        if (j == parts.size()) break;
                        parts.remove(j);
                    }
                    ++i;
                }
            }
            if (i != contentChildNodes.getLength() || !parts.isEmpty()) continue;
            return wsdlOperation;
        }
        throw new DispatchException("Missing operation for soapAction [" + soapAction + "] and body element [" + contentQName + "] with SOAP Version [" + soapVersion + "]");
    }

    public static WsdlOperation findOperationForResponse(SoapVersion soapVersion, String soapAction, XmlObject responseContent, List<WsdlOperation> operations, boolean requireSoapVersionMatch, boolean requireSoapActionMatch) throws Exception {
        XmlObject contentElm = SoapUtils.getContentElement(responseContent, soapVersion);
        if (contentElm == null) {
            return null;
        }
        QName contentQName = XmlUtils.getQName(contentElm.getDomNode());
        NodeList contentChildNodes = null;
        for (int c = 0; c < operations.size(); ++c) {
            QName qname;
            WsdlOperation wsdlOperation = operations.get(c);
            String action = wsdlOperation.getAction();
            if (requireSoapActionMatch && (soapAction != null || wsdlOperation.getAction() != null) && (action == null || !action.equals(soapAction)) || !contentQName.equals(qname = wsdlOperation.getResponseBodyElementQName())) continue;
            SoapVersion ifaceSoapVersion = wsdlOperation.getInterface().getSoapVersion();
            if (requireSoapVersionMatch && ifaceSoapVersion != soapVersion) continue;
            if (wsdlOperation.getStyle().equals("Document")) {
                return wsdlOperation;
            }
            if (!wsdlOperation.getStyle().equals("RPC")) continue;
            BindingOperation bindingOperation = wsdlOperation.getBindingOperation();
            Message message = bindingOperation.getOperation().getOutput().getMessage();
            List parts = message.getOrderedParts(null);
            if (contentChildNodes == null) {
                contentChildNodes = XmlUtils.getChildElements((Element)contentElm.getDomNode());
            }
            int i = 0;
            if (parts.size() > 0) {
                for (int x = 0; x < parts.size(); ++x) {
                    if (!WsdlUtils.isAttachmentOutputPart((Part)parts.get(x), bindingOperation) && !WsdlUtils.isHeaderOutputPart((Part)parts.get(x), message, bindingOperation)) continue;
                    parts.remove(x);
                    --x;
                }
                while (i < contentChildNodes.getLength() && !parts.isEmpty()) {
                    Node item = contentChildNodes.item(i);
                    if (item.getNodeType() == 1) {
                        int j;
                        for (j = 0; j < parts.size() && !item.getNodeName().equals(((Part)parts.get(j)).getName()); ++j) {
                            Part part = (Part)parts.get(j);
                            if (part.getElementName() != null) {
                                QName qn = part.getElementName();
                                if (!item.getLocalName().equals(qn.getLocalPart()) || !item.getNamespaceURI().equals(qn.getNamespaceURI())) continue;
                                break;
                            }
                            if (item.getNodeName().equals(((Part)parts.get(j)).getName())) break;
                        }
                        if (j == parts.size()) break;
                        parts.remove(j);
                    }
                    ++i;
                }
            }
            if (i != contentChildNodes.getLength() || !parts.isEmpty()) continue;
            return wsdlOperation;
        }
        throw new DispatchException("Missing response operation for soapAction [" + soapAction + "] and body element [" + contentQName + "] with SOAP Version [" + soapVersion + "]");
    }

    public static String removeEmptySoapHeaders(String content, SoapVersion soapVersion) throws XmlException {
        Node domNode;
        XmlObject xmlObject = XmlObject.Factory.parse((String)content);
        XmlObject[] selectPath = xmlObject.selectPath("declare namespace soap='" + soapVersion.getEnvelopeNamespace() + "';/soap:Envelope/soap:Header");
        if (selectPath.length > 0 && !(domNode = selectPath[0].getDomNode()).hasChildNodes() && !domNode.hasAttributes()) {
            domNode.getParentNode().removeChild(domNode);
            return xmlObject.xmlText();
        }
        return content;
    }

    public static SoapVersion deduceSoapVersion(String requestContentType, String requestContent) {
        try {
            return SoapUtils.deduceSoapVersion(requestContentType, XmlObject.Factory.parse((String)requestContent));
        }
        catch (XmlException e) {
            return SoapUtils.deduceSoapVersion(requestContentType, (XmlObject)null);
        }
    }

    public static String transferSoapHeaders(String requestContent, String newRequest, SoapVersion soapVersion) {
        try {
            Element headerElm;
            NodeList childNodes;
            XmlObject source = XmlObject.Factory.parse((String)requestContent);
            String headerXPath = "declare namespace ns='" + soapVersion.getEnvelopeNamespace() + "'; //ns:Header";
            XmlObject[] header = source.selectPath(headerXPath);
            if (header.length == 1 && (childNodes = (headerElm = (Element)header[0].getDomNode()).getChildNodes()).getLength() > 0) {
                XmlObject dest = XmlObject.Factory.parse((String)newRequest);
                header = dest.selectPath(headerXPath);
                Element destElm = null;
                if (header.length == 0) {
                    Element docElm = ((Document)dest.getDomNode()).getDocumentElement();
                    destElm = (Element)docElm.insertBefore(docElm.getOwnerDocument().createElementNS(soapVersion.getEnvelopeNamespace(), docElm.getPrefix() + ":Header"), XmlUtils.getFirstChildElementNS(docElm, soapVersion.getBodyQName()));
                } else {
                    destElm = (Element)header[0].getDomNode();
                }
                for (int c = 0; c < childNodes.getLength(); ++c) {
                    destElm.appendChild(destElm.getOwnerDocument().importNode(childNodes.item(c), true));
                }
                return dest.xmlText();
            }
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
        return newRequest;
    }
}

