/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSHeader;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.types.StringToStringMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSResponse
implements WsdlResponse {
    private String payload;
    private Message messageReceive;
    private Message messageSend;
    private Attachment[] attachments = new Attachment[0];
    private Request request;
    private long requestStartedTime;
    private String endpoint;

    public JMSResponse(String payload, Message messageSend, Message messageReceive, Request request, long requestStartedTime) {
        this.payload = payload;
        this.messageReceive = messageReceive;
        this.messageSend = messageSend;
        this.request = request;
        this.requestStartedTime = requestStartedTime;
        this.endpoint = request.getEndpoint();
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachment[] attachments) {
        this.attachments = attachments;
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        return this.attachments;
    }

    @Override
    public String getContentAsString() {
        return this.payload;
    }

    @Override
    public long getContentLength() {
        return this.payload.length();
    }

    @Override
    public String getContentType() {
        if (this.messageReceive != null) {
            try {
                return this.messageReceive.getJMSType();
            }
            catch (JMSException e) {
                SoapUI.logError(e);
            }
        }
        return null;
    }

    @Override
    public String getProperty(String name) {
        if (this.messageReceive != null) {
            try {
                return this.messageReceive.getStringProperty(name);
            }
            catch (JMSException e) {
                SoapUI.logError(e);
            }
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        try {
            if (this.messageReceive != null) {
                Enumeration temp = this.messageReceive.getPropertyNames();
                while (temp.hasMoreElements()) {
                    propertyNames.add((String)temp.nextElement());
                }
                return propertyNames.toArray(new String[propertyNames.size()]);
            }
            return new String[0];
        }
        catch (JMSException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public byte[] getRawRequestData() {
        if (this.messageSend != null) {
            return this.messageSend.toString().getBytes();
        }
        return "".getBytes();
    }

    @Override
    public byte[] getRawResponseData() {
        if (this.messageReceive != null) {
            return this.messageReceive.toString().getBytes();
        }
        return "".getBytes();
    }

    @Override
    public String getRequestContent() {
        if (this.messageSend != null) {
            try {
                if (this.messageSend instanceof TextMessage) {
                    return ((TextMessage)this.messageSend).getText();
                }
            }
            catch (JMSException e) {
                SoapUI.logError(e);
            }
            return this.messageSend.toString();
        }
        return "";
    }

    @Override
    public StringToStringMap getRequestHeaders() {
        if (this.messageSend != null) {
            return JMSHeader.getMessageHeadersAndProperties(this.messageSend);
        }
        return new StringToStringMap();
    }

    @Override
    public StringToStringMap getResponseHeaders() {
        if (this.messageReceive != null) {
            return JMSHeader.getMessageHeadersAndProperties(this.messageReceive);
        }
        return new StringToStringMap();
    }

    @Override
    public long getTimeTaken() {
        return Calendar.getInstance().getTimeInMillis() - this.requestStartedTime;
    }

    @Override
    public long getTimestamp() {
        try {
            if (this.messageReceive != null) {
                return this.messageReceive.getJMSTimestamp();
            }
            return 0L;
        }
        catch (JMSException e) {
            SoapUI.logError(e);
            return 0L;
        }
    }

    @Override
    public void setProperty(String name, String value) {
        try {
            this.messageReceive.setStringProperty(name, value);
        }
        catch (JMSException e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public String getContentAsXml() {
        if (this.payload != null && !"".equals(this.payload)) {
            return this.payload;
        }
        return "<xml/>";
    }

    @Override
    public String getHttpVersion() {
        return null;
    }

    @Override
    public RestRequestInterface.RequestMethod getMethod() {
        return null;
    }

    @Override
    public SSLInfo getSSLInfo() {
        return null;
    }

    @Override
    public int getStatusCode() {
        return 0;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public void setResponseContent(String responseContent) {
        this.payload = responseContent;
    }

    @Override
    public Vector<?> getWssResult() {
        return null;
    }

    @Override
    public WsdlRequest getRequest() {
        return (WsdlRequest)this.request;
    }

    public Message getMessageReceive() {
        return this.messageReceive;
    }

    public Message getMessageSend() {
        return this.messageSend;
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

