/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageResponse;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMimeMessageResponse
extends MimeMessageResponse
implements WsdlResponse {
    private Vector<Object> wssResult;

    public WsdlMimeMessageResponse(WsdlRequest httpRequest, ExtendedHttpMethod httpMethod, String requestContent, PropertyExpansionContext context) {
        super(httpRequest, httpMethod, requestContent, context);
        HeaderElement[] elements;
        WsdlRequest wsdlRequest = httpRequest;
        this.processIncomingWss(wsdlRequest, context);
        String multipartType = null;
        Header h = httpMethod.getResponseHeader("Content-Type");
        for (HeaderElement element : elements = h.getElements()) {
            NameValuePair parameter;
            String name = element.getName().toUpperCase();
            if (!name.startsWith("MULTIPART/") || (parameter = element.getParameterByName("type")) == null) continue;
            multipartType = parameter.getValue();
        }
        if (wsdlRequest.isExpandMtomResponseAttachments() && "application/xop+xml".equals(multipartType)) {
            this.expandMtomAttachments(wsdlRequest);
        }
    }

    private void processIncomingWss(AbstractHttpRequestInterface<?> wsdlRequest, PropertyExpansionContext context) {
        IncomingWss incomingWss = (IncomingWss)context.getProperty("WssRequestFilter#IncomingWss");
        if (incomingWss != null) {
            try {
                Document document = XmlUtils.parseXml(this.getMmSupport().getResponseContent());
                this.wssResult = incomingWss.processIncoming(document, context);
                if (this.wssResult != null && this.wssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serializePretty(document, (Writer)writer);
                    this.getMmSupport().setResponseContent(writer.toString());
                }
            }
            catch (Exception e) {
                if (this.wssResult == null) {
                    this.wssResult = new Vector();
                }
                this.wssResult.add(e);
            }
        }
    }

    private void expandMtomAttachments(WsdlRequest wsdlRequest) {
        try {
            XmlObject[] includes;
            XmlObject xmlObject = XmlObject.Factory.parse((String)this.getContentAsString());
            for (XmlObject include : includes = xmlObject.selectPath("declare namespace xop='http://www.w3.org/2004/08/xop/include'; //xop:Include")) {
                SchemaTypeSystem typeSystem;
                SchemaGlobalElement schemaElement;
                Element elm = (Element)include.getDomNode();
                String href = elm.getAttribute("href");
                Attachment attachment = this.getMmSupport().getAttachmentWithContentId("<" + href.substring(4) + ">");
                if (attachment == null) continue;
                ByteArrayOutputStream data = Tools.readAll(attachment.getInputStream(), 0L);
                byte[] byteArray = data.toByteArray();
                XmlCursor cursor = include.newCursor();
                cursor.toParent();
                XmlObject parentXmlObject = cursor.getObject();
                cursor.dispose();
                SchemaType schemaType = parentXmlObject.schemaType();
                Node parentNode = elm.getParentNode();
                if (schemaType.isNoType() && (schemaElement = (typeSystem = wsdlRequest.getOperation().getInterface().getWsdlContext().getSchemaTypeSystem()).findElement(new QName(parentNode.getNamespaceURI(), parentNode.getLocalName()))) != null) {
                    schemaType = schemaElement.getType();
                }
                String txt = null;
                txt = SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type) ? new String(Hex.encodeHex((byte[])byteArray)) : new String(Base64.encodeBase64((byte[])byteArray));
                parentNode.replaceChild(elm.getOwnerDocument().createTextNode(txt), elm);
            }
            this.getMmSupport().setResponseContent(xmlObject.toString());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public WsdlRequest getRequest() {
        return (WsdlRequest)super.getRequest();
    }

    @Override
    public Vector<?> getWssResult() {
        return this.wssResult;
    }
}

