/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.settings.HttpSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PostResponseDataSource
implements DataSource {
    private final ExtendedHttpMethod postMethod;
    private byte[] data;

    public PostResponseDataSource(ExtendedHttpMethod postMethod) {
        this.postMethod = postMethod;
        try {
            String compressionAlg;
            this.data = postMethod.getResponseBody();
            if (!SoapUI.getSettings().getBoolean(HttpSettings.DISABLE_RESPONSE_DECOMPRESSION) && (compressionAlg = HttpClientSupport.getResponseCompressionType(postMethod)) != null) {
                this.data = CompressionSupport.decompress(compressionAlg, this.data);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public long getDataSize() {
        return this.data == null ? -1L : (long)this.data.length;
    }

    public String getContentType() {
        return this.postMethod.getResponseHeader("Content-Type").getValue();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return this.postMethod.getName() + " response for " + this.postMethod.getPath().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public byte[] getData() {
        return this.data;
    }
}

