/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class MockResponseDataSource
implements DataSource {
    private final String responseContent;
    private final boolean isXOP;
    private final WsdlMockResponse mockResponse;

    public MockResponseDataSource(WsdlMockResponse mockResponse, String responseContent, boolean isXOP) {
        this.mockResponse = mockResponse;
        this.responseContent = responseContent;
        this.isXOP = isXOP;
    }

    public String getContentType() {
        SoapVersion soapVersion = this.mockResponse.getSoapVersion();
        if (this.isXOP) {
            return AttachmentUtils.buildRootPartContentType(this.mockResponse.getMockOperation().getOperation().getName(), soapVersion);
        }
        return soapVersion.getContentType() + "; charset=UTF-8";
    }

    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.responseContent.getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }

    public String getName() {
        return this.mockResponse.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

