/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.httpclient.methods.RequestEntity;

public class MimeMessageMockResponseEntity
implements RequestEntity {
    private final MimeMessage message;
    private byte[] buffer;
    private final boolean isXOP;
    private final WsdlMockResponse mockResponse;

    public MimeMessageMockResponseEntity(MimeMessage message, boolean isXOP, WsdlMockResponse response) {
        this.message = message;
        this.isXOP = isXOP;
        this.mockResponse = response;
    }

    public long getContentLength() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeRequest(out);
            this.buffer = out.toByteArray();
            return this.buffer.length;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public String getContentType() {
        try {
            SoapVersion soapVersion = this.mockResponse.getSoapVersion();
            if (this.isXOP) {
                String header = this.message.getHeader("Content-Type")[0];
                return AttachmentUtils.buildMTOMContentType(header, null, soapVersion);
            }
            String header = this.message.getHeader("Content-Type")[0];
            int ix = header.indexOf("boundary");
            return "multipart/related; type=\"" + soapVersion.getContentType() + "\"; start=\"" + "<rootpart@soapui.org>" + "\"; " + header.substring(ix);
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream arg0) throws IOException {
        try {
            if (this.buffer == null) {
                arg0.write("\r\n".getBytes());
                ((MimeMultipart)this.message.getContent()).writeTo(arg0);
            } else {
                arg0.write(this.buffer);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }
}

