/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.ConnectionWithSocket;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;

public final class HttpMethodSupport {
    private long timeTaken;
    private long startTime;
    private long maxSize;
    private long responseReadTime;
    private byte[] responseBody;
    private SSLInfo sslInfo;
    private String dumpFile;
    private final HttpMethodBase httpMethod;
    private Throwable failureCause;

    public HttpMethodSupport(HttpMethodBase httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getDumpFile() {
        return this.dumpFile;
    }

    public void setDumpFile(String dumpFile) {
        this.dumpFile = dumpFile;
    }

    public void afterReadResponse(HttpState arg0, HttpConnection arg1) {
        Socket socket;
        if (arg1 instanceof ConnectionWithSocket && (socket = ((ConnectionWithSocket)arg1).getConnectionSocket()) instanceof SSLSocket) {
            this.sslInfo = new SSLInfo((SSLSocket)socket);
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void afterWriteRequest(HttpState arg0, HttpConnection arg1) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
    }

    public void initStartTime() {
        this.startTime = System.nanoTime();
    }

    public long getTimeTaken() {
        if (this.timeTaken == 0L) {
            this.timeTaken = (System.nanoTime() - this.startTime) / 1000000L;
        }
        return this.timeTaken;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public byte[] getResponseBody() throws IOException {
        if (this.responseBody != null) {
            return this.responseBody;
        }
        long contentLength = this.httpMethod.getResponseContentLength();
        long now = System.nanoTime();
        InputStream instream = this.httpMethod.getResponseBodyAsStream();
        if (this.maxSize == 0L || contentLength >= 0L && contentLength <= this.maxSize) {
            String compressionAlg;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (instream != null) {
                Tools.writeAll(out, instream);
            }
            this.responseReadTime = System.nanoTime() - now;
            this.responseBody = out.toByteArray();
            try {
                if (StringUtils.hasContent(this.dumpFile)) {
                    Tools.writeAll(new FileOutputStream(this.dumpFile), new ByteArrayInputStream(this.responseBody));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!SoapUI.getSettings().getBoolean(HttpSettings.DISABLE_RESPONSE_DECOMPRESSION) && (compressionAlg = HttpClientSupport.getResponseCompressionType((HttpMethod)this.httpMethod)) != null) {
                try {
                    this.responseBody = CompressionSupport.decompress(compressionAlg, this.responseBody);
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Decompression of response failed");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        } else {
            ByteArrayOutputStream outstream;
            try {
                if (StringUtils.hasContent(this.dumpFile) && instream != null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.dumpFile);
                    Tools.writeAll(fileOutputStream, instream);
                    this.responseReadTime = System.nanoTime() - now;
                    fileOutputStream.close();
                    instream = new FileInputStream(this.dumpFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteArrayOutputStream byteArrayOutputStream = outstream = instream == null ? new ByteArrayOutputStream() : Tools.readAll(instream, this.maxSize);
            if (this.responseReadTime == 0L) {
                this.responseReadTime = System.nanoTime() - now;
            }
            this.responseBody = outstream.toByteArray();
        }
        this.responseReadTime /= 1000000L;
        return this.responseBody;
    }

    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    public String getResponseContentType() {
        Header[] headers = this.httpMethod.getResponseHeaders("Content-Type");
        if (headers != null && headers.length > 0 && headers[0].getElements().length > 0) {
            return headers[0].getElements()[0].getName();
        }
        return null;
    }

    public long getResponseReadTime() {
        return this.responseReadTime;
    }

    public String getResponseCharset() {
        Header contentEncodingHeader;
        Header header = this.httpMethod.getResponseHeader("Content-Type");
        if (header != null) {
            for (HeaderElement headerElement : header.getElements()) {
                NameValuePair parameter = headerElement.getParameterByName("charset");
                if (parameter == null) continue;
                return parameter.getValue();
            }
        }
        if ((contentEncodingHeader = this.httpMethod.getResponseHeader("Content-Encoding")) != null) {
            try {
                String value = contentEncodingHeader.getValue();
                if (CompressionSupport.getAvailableAlgorithm(value) == null) {
                    new String("").getBytes(value);
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public boolean isFailed() {
        return this.failureCause != null;
    }

    public void setFailed(Throwable t) {
        this.failureCause = t;
    }

    public boolean hasResponse() {
        return this.responseBody != null;
    }
}

