/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSettingsRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> httpRequest) {
        String httpVersion;
        String compressionAlg;
        ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)context.getProperty("httpMethod");
        XmlBeansSettingsImpl settings = httpRequest.getSettings();
        if (settings.getBoolean(HttpSettings.CLOSE_CONNECTIONS)) {
            httpMethod.setRequestHeader("Connection", "close");
        }
        if (settings.getBoolean(HttpSettings.EXPECT_CONTINUE) && httpMethod instanceof EntityEnclosingMethod) {
            httpMethod.getParams().setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
        }
        if (!"None".equals(compressionAlg = settings.getString(HttpSettings.REQUEST_COMPRESSION, "None"))) {
            httpMethod.setRequestHeader("Content-Encoding", compressionAlg);
        }
        if (settings.getBoolean(HttpSettings.RESPONSE_COMPRESSION)) {
            httpMethod.setRequestHeader("Accept-Encoding", CompressionSupport.getAvailableAlgorithms(","));
        }
        if ((httpVersion = settings.getString(HttpSettings.HTTP_VERSION, "1.1")).equals("1.1")) {
            httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
        } else if (httpVersion.equals("1.0")) {
            httpMethod.getParams().setVersion(HttpVersion.HTTP_1_0);
        } else if (httpVersion.equals("0.9")) {
            httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
        }
        long maxSize = httpRequest.getMaxSize();
        if (maxSize == 0L) {
            maxSize = settings.getLong(HttpSettings.MAX_RESPONSE_SIZE, 0L);
        }
        if (maxSize > 0L) {
            httpMethod.setMaxSize(maxSize);
        }
        httpMethod.setFollowRedirects(httpRequest.isFollowRedirects());
        HttpClientSupport.applyHttpSettings(httpMethod, settings);
        String timeout = context.expand(httpRequest.getTimeout());
        if (StringUtils.hasContent(timeout)) {
            try {
                httpMethod.getParams().setSoTimeout(Integer.parseInt(timeout));
            }
            catch (NumberFormatException e) {
                SoapUI.logError(e);
            }
        }
    }
}

