/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.settings.HttpSettings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCompressionRequestFilter
extends AbstractRequestFilter {
    private static final Logger log = Logger.getLogger(HttpCompressionRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> httpRequest) {
        XmlBeansSettingsImpl settings = httpRequest.getSettings();
        String compressionAlg = settings.getString(HttpSettings.REQUEST_COMPRESSION, "None");
        if (!"None".equals(compressionAlg)) {
            try {
                RequestEntity requestEntity;
                ExtendedHttpMethod method = (ExtendedHttpMethod)context.getProperty("httpMethod");
                if (method instanceof EntityEnclosingMethod && (requestEntity = method.getRequestEntity()) != null) {
                    ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
                    requestEntity.writeRequest((OutputStream)tempOut);
                    byte[] compressedData = CompressionSupport.compress(compressionAlg, tempOut.toByteArray());
                    ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)new ByteArrayRequestEntity(compressedData));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

