/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfMessageSerializer;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amf.client.AMFHeaderProcessor;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUIAMFConnection {
    private static int DEFAULT_OBJECT_ENCODING = 3;
    private ActionContext actionContext;
    private boolean connected;
    private int objectEncoding;
    private boolean objectEncodingSet = false;
    private SerializationContext serializationContext;
    private String url;
    private List<MessageHeader> amfHeaders;
    private AMFHeaderProcessor amfHeaderProcessor;
    private Map<String, String> httpRequestHeaders;
    private int responseCounter;
    private ExtendedPostMethod postMethod;
    private HttpState httpState = new HttpState();
    private PropertyExpansionContext context;

    public int getObjectEncoding() {
        if (!this.objectEncodingSet) {
            return DEFAULT_OBJECT_ENCODING;
        }
        return this.objectEncoding;
    }

    public void setObjectEncoding(int objectEncoding) {
        this.objectEncoding = objectEncoding;
        this.objectEncodingSet = true;
    }

    public String getUrl() {
        return this.url;
    }

    public void addAmfHeader(String name, boolean mustUnderstand, Object data) {
        if (this.amfHeaders == null) {
            this.amfHeaders = new ArrayList<MessageHeader>();
        }
        MessageHeader header = new MessageHeader(name, mustUnderstand, data);
        this.amfHeaders.add(header);
    }

    public void addAmfHeader(String name, Object data) {
        this.addAmfHeader(name, false, data);
    }

    public boolean removeAmfHeader(String name) {
        boolean exists = false;
        if (this.amfHeaders != null) {
            Iterator<MessageHeader> iterator = this.amfHeaders.iterator();
            while (iterator.hasNext()) {
                MessageHeader header = iterator.next();
                if (!name.equals(header.getName())) continue;
                iterator.remove();
                exists = true;
            }
        }
        return exists;
    }

    public void removeAllAmfHeaders() {
        if (this.amfHeaders != null) {
            this.amfHeaders = null;
        }
    }

    public void addHttpRequestHeader(String name, String value) {
        if (this.httpRequestHeaders == null) {
            this.httpRequestHeaders = new HashMap<String, String>();
        }
        this.httpRequestHeaders.put(name, value);
    }

    public boolean removeHttpRequestHeader(String name) {
        boolean exists = false;
        if (this.httpRequestHeaders != null) {
            String previousValue = this.httpRequestHeaders.remove(name);
            exists = previousValue != null;
        }
        return exists;
    }

    public void removeAllHttpRequestHeaders() {
        if (this.httpRequestHeaders != null) {
            this.httpRequestHeaders = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(PropertyExpansionContext context, String command, Object ... arguments) throws ClientStatusException, ServerStatusException {
        Object object;
        this.context = context;
        if (!this.connected) {
            String message = "AMF connection is not connected";
            ClientStatusException cse = new ClientStatusException(message, "AMFConnection.Call.Failed");
            throw cse;
        }
        String responseURI = this.getResponseURI();
        ActionMessage requestMessage = new ActionMessage(this.getObjectEncoding());
        if (this.amfHeaders != null) {
            for (MessageHeader header : this.amfHeaders) {
                requestMessage.addHeader(header);
            }
        }
        MessageBody amfMessage = new MessageBody(command, responseURI, (Object)arguments);
        requestMessage.addBody(amfMessage);
        this.actionContext.setRequestMessage(requestMessage);
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfMessageSerializer amfMessageSerializer = new AmfMessageSerializer();
        amfMessageSerializer.initialize(this.serializationContext, (OutputStream)outBuffer, null);
        try {
            try {
                Object result;
                amfMessageSerializer.writeMessage(requestMessage);
                object = result = this.send(outBuffer);
                Object var12_15 = null;
            }
            catch (Exception e) {
                if (e instanceof ClientStatusException) {
                    throw (ClientStatusException)((Object)e);
                }
                if (e instanceof ServerStatusException) {
                    throw (ServerStatusException)((Object)e);
                }
                ClientStatusException exception = new ClientStatusException((Throwable)e, "AMFConnection.Call.Failed");
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                outBuffer.close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return object;
        }
        outBuffer.close();
        return object;
    }

    public void close() {
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
            this.postMethod = null;
        }
        this.url = null;
        this.serializationContext = null;
        this.connected = false;
    }

    public void connect(String url) throws ClientStatusException {
        if (this.connected) {
            this.close();
        }
        this.url = url;
        try {
            this.serializationContext = new SerializationContext();
            this.serializationContext.createASObjectForMissingType = true;
            this.internalConnect();
        }
        catch (IOException e) {
            ClientStatusException exception = new ClientStatusException((Throwable)e, "AMFConnection.Connect.Failed");
            throw exception;
        }
    }

    protected ServerStatusException.HttpResponseInfo generateHttpResponseInfo() {
        ServerStatusException.HttpResponseInfo httpResponseInfo = null;
        try {
            int responseCode = this.postMethod.getStatusCode();
            String responseMessage = this.postMethod.getResponseBodyAsString();
            httpResponseInfo = new ServerStatusException.HttpResponseInfo(responseCode, responseMessage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return httpResponseInfo;
    }

    protected String getResponseURI() {
        String responseURI = "/" + this.responseCounter;
        ++this.responseCounter;
        return responseURI;
    }

    protected void internalConnect() throws IOException {
        this.serializationContext.instantiateTypes = false;
        this.postMethod = new ExtendedPostMethod(this.url);
        this.setHttpRequestHeaders();
        this.actionContext = new ActionContext();
        this.connected = true;
    }

    protected Object processHttpResponse(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        return this.processHttpResponseBody(inputStream);
    }

    protected Object processHttpResponseBody(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        DataInputStream din = new DataInputStream(inputStream);
        ActionMessage message = new ActionMessage();
        this.actionContext.setRequestMessage(message);
        AmfMessageDeserializer deserializer = new AmfMessageDeserializer();
        deserializer.initialize(this.serializationContext, (InputStream)din, null);
        deserializer.readMessage(message, this.actionContext);
        din.close();
        this.context.setProperty("AMF_RESPONSE_ACTION_MESSAGE", message);
        return this.processAmfPacket(message);
    }

    protected Object processAmfPacket(ActionMessage packet) throws ClientStatusException, ServerStatusException {
        this.processAmfHeaders(packet.getHeaders());
        return this.processAmfBody(packet.getBodies());
    }

    protected void processAmfHeaders(ArrayList<MessageHeader> headers) throws ClientStatusException {
        if (this.amfHeaderProcessor == null) {
            return;
        }
        for (MessageHeader header : headers) {
            this.amfHeaderProcessor.processHeader(header);
        }
    }

    protected Object processAmfBody(ArrayList<MessageBody> messages) throws ServerStatusException {
        for (MessageBody message : messages) {
            String targetURI = message.getTargetURI();
            if (targetURI.endsWith("/onResult")) {
                return message.getData();
            }
            if (!targetURI.endsWith("/onStatus")) continue;
            return message.getData();
        }
        return null;
    }

    protected Object send(ByteArrayOutputStream outBuffer) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        this.internalConnect();
        this.postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(outBuffer.toByteArray()));
        HostConfiguration hostConfiguration = new HostConfiguration();
        ProxyUtils.initProxySettings(this.context.getModelItem() == null ? SoapUI.getSettings() : this.context.getModelItem().getSettings(), this.httpState, hostConfiguration, this.url, this.context);
        HttpClientSupport.getHttpClient().executeMethod(hostConfiguration, (HttpMethod)this.postMethod, this.httpState);
        this.context.setProperty("AMF_POST_METHOD", this.postMethod);
        return this.processHttpResponse(this.responseBodyInputStream());
    }

    private ByteArrayInputStream responseBodyInputStream() throws IOException {
        byte[] responseBody = this.postMethod.getResponseBody();
        ByteArrayInputStream bais = new ByteArrayInputStream(responseBody);
        this.context.setProperty("AMF_RAW_RESPONSE_BODY", responseBody);
        return bais;
    }

    protected void setHttpRequestHeaders() {
        if (this.httpRequestHeaders != null) {
            for (Map.Entry<String, String> element : this.httpRequestHeaders.entrySet()) {
                String key = element.getKey();
                String value = element.getValue();
                this.postMethod.setRequestHeader(key, value);
            }
        }
    }

    public static void registerAlias(String alias, String className) {
        ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
        registry.registerAlias(alias, className);
        registry.registerAlias(className, alias);
    }
}

