/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RunTestCaseRunModeTypeConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestRunLogTestRunListener;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlRunTestCaseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.XFormMultiSelectList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlRunTestCaseStepDesktopPanel
extends ModelItemDesktopPanel<WsdlRunTestCaseTestStep>
implements PropertyChangeListener {
    private WsdlProject project = ((WsdlRunTestCaseTestStep)this.getModelItem()).getTestCase().getTestSuite().getProject();
    private TitledBorder titledBorder;
    private OptionsAction optionsAction;
    private RunAction runAction;
    private OpenTestCaseAction openTestCaseAction;
    private JTestRunLog testRunLog;
    private CancelRunTestCaseAction cancelAction;
    private XFormDialog optionsDialog;
    private JInspectorPanel inspectorPanel;
    private PropertyHolderTable propertiesTable;

    public WsdlRunTestCaseStepDesktopPanel(WsdlRunTestCaseTestStep modelItem) {
        super(modelItem);
        ((WsdlRunTestCaseTestStep)this.getModelItem()).addPropertyChangeListener(WsdlRunTestCaseTestStep.TARGET_TESTCASE, this);
        WsdlTestCase targetTestCase = ((WsdlRunTestCaseTestStep)this.getModelItem()).getTargetTestCase();
        if (targetTestCase != null) {
            targetTestCase.addPropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
            targetTestCase.getTestSuite().addPropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
        }
        this.buildUI();
        this.setEnabledState();
        if (modelItem.getTargetTestCase() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsAction.actionPerformed(null);
                }
            });
        }
        this.setPreferredSize(new Dimension(400, 600));
    }

    private void setEnabledState() {
        this.runAction.setEnabled(((WsdlRunTestCaseTestStep)this.getModelItem()).getTargetTestCase() != null);
        this.openTestCaseAction.setEnabled(((WsdlRunTestCaseTestStep)this.getModelItem()).getTargetTestCase() != null);
    }

    private void buildUI() {
        this.add(this.buildToolbar(), "North");
        this.add(this.buildContent(), "Center");
    }

    private Component buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.createPropertiesTable());
        this.inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildLog(), "TestCase Log", "log output from testcase run", true));
        return this.inspectorPanel.getComponent();
    }

    private JComponent buildLog() {
        this.testRunLog = new JTestRunLog(((WsdlRunTestCaseTestStep)this.getModelItem()).getSettings());
        return this.testRunLog;
    }

    protected JComponent createPropertiesTable() {
        this.propertiesTable = new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
        this.titledBorder = BorderFactory.createTitledBorder(this.createTitleForBorder());
        this.propertiesTable.setBorder(this.titledBorder);
        return this.propertiesTable;
    }

    private String createTitleForBorder() {
        WsdlTestCase targetTestCase = ((WsdlRunTestCaseTestStep)this.getModelItem()).getTargetTestCase();
        return "TestCase [" + (targetTestCase == null ? "- none selected -" : targetTestCase.getTestSuite().getName() + ":" + targetTestCase.getName()) + "] Run Properties";
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.runAction = new RunAction();
        toolbar.add(UISupport.createToolbarButton(this.runAction));
        this.cancelAction = new CancelRunTestCaseAction();
        toolbar.add(UISupport.createToolbarButton(this.cancelAction, false));
        this.optionsAction = new OptionsAction();
        toolbar.add(UISupport.createToolbarButton(this.optionsAction));
        this.openTestCaseAction = new OpenTestCaseAction();
        toolbar.add(UISupport.createToolbarButton(this.openTestCaseAction));
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/runtestcasestep.html")));
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        WsdlRunTestCaseTestStep callStep = (WsdlRunTestCaseTestStep)this.getModelItem();
        return modelItem == callStep || modelItem == callStep.getTestCase() || modelItem == callStep.getTestCase().getTestSuite() || modelItem == callStep.getTestCase().getTestSuite().getProject();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        ((WsdlRunTestCaseTestStep)this.getModelItem()).removePropertyChangeListener(WsdlRunTestCaseTestStep.TARGET_TESTCASE, this);
        WsdlTestCase targetTestCase = ((WsdlRunTestCaseTestStep)this.getModelItem()).getTargetTestCase();
        if (targetTestCase != null) {
            targetTestCase.removePropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
            targetTestCase.getTestSuite().removePropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
        }
        this.testRunLog.release();
        if (this.optionsDialog != null) {
            this.optionsDialog.release();
            this.optionsDialog = null;
        }
        this.propertiesTable.release();
        this.inspectorPanel.release();
        return this.release();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals(WsdlRunTestCaseTestStep.TARGET_TESTCASE)) {
            WsdlTestCase targetTestCase = (WsdlTestCase)evt.getOldValue();
            if (targetTestCase != null) {
                targetTestCase.removePropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
                targetTestCase.getTestSuite().removePropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
            }
            if ((targetTestCase = (WsdlTestCase)evt.getNewValue()) != null) {
                targetTestCase.addPropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
                targetTestCase.getTestSuite().addPropertyChangeListener(WsdlTestCase.NAME_PROPERTY, this);
            }
        }
        this.setEnabledState();
        this.titledBorder.setTitle(this.createTitleForBorder());
        this.repaint();
    }

    public class CancelRunTestCaseAction
    extends AbstractAction {
        public CancelRunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Stops running this testcase");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestCaseRunner testCaseRunner = ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTestCaseRunner();
            if (testCaseRunner != null) {
                testCaseRunner.cancel("Canceled from RunTestCase UI");
            }
        }
    }

    public class InternalTestRunListener
    extends TestRunLogTestRunListener {
        public InternalTestRunListener() {
            super(WsdlRunTestCaseStepDesktopPanel.this.testRunLog, true);
        }

        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(false);
            WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(true);
        }

        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(true);
            WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(false);
        }
    }

    @AForm(name="Run TestCase Options", description="Set options for the Run TestCase Step below")
    private static interface OptionsForm {
        public static final String RUN_PRIMARY_TEST_CASE = "Run primary TestCase (fail if already running)";
        public static final String CREATE_ISOLATED_COPY_FOR_EACH_RUN = "Create isolated copy for each run (Thread-Safe)";
        public static final String RUN_SYNCHRONIZED_TESTCASE = "Run primary TestCase (wait for running to finish, Thread-Safe)";
        @AField(name="Target TestCase", description="Selects the TestCase to run", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Target TestSuite", description="Selects the containing TestSuite to run", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "Target TestSuite";
        @AField(name="Return Properties", description="Selects the properties that are return values", type=AField.AFieldType.MULTILIST)
        public static final String RETURN_PROPERTIES = "Return Properties";
        @AField(name="Run Mode", description="Sets how to run the target TestCase", type=AField.AFieldType.RADIOGROUP, values={"Create isolated copy for each run (Thread-Safe)", "Run primary TestCase (fail if already running)", "Run primary TestCase (wait for running to finish, Thread-Safe)"})
        public static final String RUN_MODE = "Run Mode";
        @AField(name="Copy LoadTest Properties", description="Copies LoadTest related properties to target context", type=AField.AFieldType.BOOLEAN)
        public static final String COPY_LOADTEST_PROPERTIES = "Copy LoadTest Properties";
        @AField(name="Copy HTTP Session", description="Copies LoadTest related properties to target context", type=AField.AFieldType.BOOLEAN)
        public static final String COPY_HTTP_SESSION = "Copy HTTP Session";
        @AField(name="Ignore Empty Properties", description="Does not set empty TestCase property values", type=AField.AFieldType.BOOLEAN)
        public static final String IGNORE_EMPTY_PROPERTIES = "Ignore Empty Properties";
    }

    private class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.putValue("ShortDescription", "Sets Options");
        }

        public void actionPerformed(ActionEvent e) {
            List<TestCase> testCaseList;
            if (WsdlRunTestCaseStepDesktopPanel.this.optionsDialog == null) {
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog = ADialogBuilder.buildDialog(OptionsForm.class);
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Target TestSuite").addFormFieldListener(new XFormFieldListener(){

                    public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                        List<TestCase> testCaseList = WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteByName(newValue).getTestCaseList();
                        testCaseList.remove(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTestCase());
                        WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Target TestCase", ModelSupport.getNames(testCaseList));
                        if (testCaseList.size() > 0) {
                            WsdlTestCase testCase = WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteByName(newValue).getTestCaseAt(0);
                            WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", testCase.getPropertyNames());
                            ((XFormMultiSelectList)WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Return Properties")).setSelectedOptions(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getReturnProperties().toStringArray());
                        }
                    }
                });
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Target TestCase").addFormFieldListener(new XFormFieldListener(){

                    public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                        WsdlTestSuite testSuite = WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteByName(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getValue("Target TestSuite"));
                        WsdlTestCase testCase = testSuite.getTestCaseByName(newValue);
                        WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", testCase.getPropertyNames());
                        ((XFormMultiSelectList)WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Return Properties")).setSelectedOptions(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getReturnProperties().toStringArray());
                    }
                });
            }
            WsdlTestCase targetTestCase = ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTargetTestCase();
            WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Target TestSuite", ModelSupport.getNames(WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteList()));
            if (targetTestCase != null) {
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setValue("Target TestSuite", targetTestCase.getTestSuite().getName());
                testCaseList = targetTestCase.getTestSuite().getTestCaseList();
                testCaseList.remove(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTestCase());
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Target TestCase", ModelSupport.getNames(testCaseList));
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setValue("Target TestCase", targetTestCase.getName());
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", targetTestCase.getPropertyNames());
                ((XFormMultiSelectList)WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Return Properties")).setSelectedOptions(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getReturnProperties().toStringArray());
            } else if (WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteCount() == 0) {
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Target TestCase", new String[0]);
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", new String[0]);
            } else {
                testCaseList = WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteAt(0).getTestCaseList();
                testCaseList.remove(((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTestCase());
                WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Target TestCase", ModelSupport.getNames(testCaseList));
                if (testCaseList.isEmpty()) {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", new String[0]);
                } else {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setOptions("Return Properties", testCaseList.get(0).getPropertyNames());
                }
            }
            switch (((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getRunMode().intValue()) {
                case 1: {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setValue("Run Mode", "Create isolated copy for each run (Thread-Safe)");
                    break;
                }
                case 3: {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setValue("Run Mode", "Run primary TestCase (fail if already running)");
                    break;
                }
                case 2: {
                    WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setValue("Run Mode", "Run primary TestCase (wait for running to finish, Thread-Safe)");
                }
            }
            WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setBooleanValue("Copy HTTP Session", ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).isCopyHttpSession());
            WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setBooleanValue("Copy LoadTest Properties", ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).isCopyLoadTestProperties());
            WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.setBooleanValue("Ignore Empty Properties", ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).isIgnoreEmptyProperties());
            if (WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.show()) {
                WsdlTestSuite testSuite = WsdlRunTestCaseStepDesktopPanel.this.project.getTestSuiteByName(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getValue("Target TestSuite"));
                ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setTargetTestCase(testSuite == null ? null : testSuite.getTestCaseByName(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getValue("Target TestCase")));
                ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setReturnProperties(new StringList(((XFormMultiSelectList)WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getFormField("Return Properties")).getSelectedOptions()));
                switch (WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getValueIndex("Run Mode")) {
                    case 0: {
                        ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setRunMode(RunTestCaseRunModeTypeConfig.PARALLELL);
                        break;
                    }
                    case 1: {
                        ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setRunMode(RunTestCaseRunModeTypeConfig.SINGLETON_AND_FAIL);
                        break;
                    }
                    case 2: {
                        ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setRunMode(RunTestCaseRunModeTypeConfig.SINGLETON_AND_WAIT);
                    }
                }
                ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setCopyHttpSession(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getBooleanValue("Copy HTTP Session"));
                ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setCopyLoadTestProperties(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getBooleanValue("Copy LoadTest Properties"));
                ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).setIgnoreEmptyProperties(WsdlRunTestCaseStepDesktopPanel.this.optionsDialog.getBooleanValue("Ignore Empty Properties"));
                WsdlRunTestCaseStepDesktopPanel.this.titledBorder.setTitle(WsdlRunTestCaseStepDesktopPanel.this.createTitleForBorder());
            }
        }
    }

    private class OpenTestCaseAction
    extends AbstractAction {
        public OpenTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/testCase.gif"));
            this.putValue("ShortDescription", "Opens the target TestCases editor");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestCase targetTestCase = ((WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem()).getTargetTestCase();
            if (targetTestCase == null) {
                UISupport.showErrorMessage("No target TestCase selected");
            } else {
                UISupport.showDesktopPanel(targetTestCase);
            }
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs the selected TestCases");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(false);
            WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(true);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    WsdlRunTestCaseTestStep testStep = (WsdlRunTestCaseTestStep)WsdlRunTestCaseStepDesktopPanel.this.getModelItem();
                    InternalTestRunListener testRunListener = new InternalTestRunListener();
                    testStep.addTestRunListener(testRunListener);
                    try {
                        block4: {
                            try {
                                WsdlRunTestCaseStepDesktopPanel.this.testRunLog.clear();
                                MockTestRunner mockTestRunner = new MockTestRunner(testStep.getTestCase(), SoapUI.ensureGroovyLog());
                                WsdlTestStepResult result = (WsdlTestStepResult)testStep.run(mockTestRunner, new MockTestRunContext(mockTestRunner, testStep));
                                Throwable er = result.getError();
                                if (er == null) break block4;
                                UISupport.showErrorMessage(er.toString());
                            }
                            catch (Throwable t) {
                                UISupport.showErrorMessage(t);
                                Object var7_8 = null;
                                testStep.removeTestRunListener(testRunListener);
                                WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(true);
                                WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(false);
                                return;
                            }
                        }
                        Object var7_7 = null;
                        testStep.removeTestRunListener(testRunListener);
                        WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(true);
                        WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        testStep.removeTestRunListener(testRunListener);
                        WsdlRunTestCaseStepDesktopPanel.this.runAction.setEnabled(true);
                        WsdlRunTestCaseStepDesktopPanel.this.cancelAction.setEnabled(false);
                        throw throwable;
                    }
                }
            }).start();
        }
    }
}

