/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.JdbcRequestTestStepConfig;
import com.eviware.soapui.config.ModelItemConfig;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcSubmit;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractAnimatableModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRequest
extends AbstractAnimatableModelItem<ModelItemConfig>
implements Assertable,
TestRequest {
    private final JdbcRequestTestStep testStep;
    private Set<SubmitListener> submitListeners = new HashSet<SubmitListener>();
    private JdbcResponse response;
    static final Logger logger = Logger.getLogger(JdbcRequest.class);
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;
    private RequestIconAnimator<?> iconAnimator;
    private boolean forLoadTest;
    private Assertable.AssertionStatus currentStatus;

    public JdbcRequest(JdbcRequestTestStep testStep, boolean forLoadTest) {
        this.testStep = testStep;
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    @Override
    public void addSubmitListener(SubmitListener listener) {
        this.submitListeners.add(listener);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ModelSupport.dependsOn(this.testStep, modelItem);
    }

    @Override
    public Attachment[] getAttachments() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getEndpoint() {
        return null;
    }

    @Override
    public Operation getOperation() {
        return null;
    }

    @Override
    public String getRequestContent() {
        return ((JdbcRequestTestStepConfig)this.testStep.getConfig()).getQuery();
    }

    @Override
    public MessagePart[] getRequestParts() {
        return null;
    }

    @Override
    public MessagePart[] getResponseParts() {
        return null;
    }

    @Override
    public String getTimeout() {
        return this.testStep.getQueryTimeout();
    }

    @Override
    public void removeSubmitListener(SubmitListener listener) {
        this.submitListeners.remove(listener);
    }

    @Override
    public void setEncoding(String string) {
    }

    @Override
    public void setEndpoint(String string) {
    }

    @Override
    public JdbcSubmit submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        return new JdbcSubmit(this, submitContext, async);
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.testStep.getDescription();
    }

    @Override
    public String getId() {
        return this.testStep.getId();
    }

    @Override
    public String getName() {
        return this.testStep.getName();
    }

    @Override
    public ModelItem getParent() {
        return this.testStep.getParent();
    }

    @Override
    public Settings getSettings() {
        return this.testStep.getSettings();
    }

    public SubmitListener[] getSubmitListeners() {
        return this.submitListeners.toArray(new SubmitListener[this.submitListeners.size()]);
    }

    @Override
    public JdbcRequestTestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy) {
        return this.testStep.importAssertion(source, overwrite2, createCopy);
    }

    @Override
    public TestAssertion addAssertion(String selection) {
        return this.testStep.addAssertion(selection);
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.testStep.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.testStep.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContent() {
        return this.testStep.getAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.testStep.getAssertableType();
    }

    @Override
    public TestAssertion getAssertionAt(int c) {
        return this.testStep.getAssertionAt(c);
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.testStep.getAssertionByName(name);
    }

    @Override
    public int getAssertionCount() {
        return this.testStep.getAssertionCount();
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.testStep.getAssertionList();
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        this.currentStatus = Assertable.AssertionStatus.UNKNOWN;
        if (this.getResponse() == null) {
            return this.currentStatus;
        }
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        boolean hasEnabled = false;
        for (int c = 0; c < cnt; ++c) {
            if (!this.getAssertionAt(c).isDisabled()) {
                hasEnabled = true;
            }
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            this.currentStatus = Assertable.AssertionStatus.FAILED;
            break;
        }
        if (this.currentStatus == Assertable.AssertionStatus.UNKNOWN && hasEnabled) {
            this.currentStatus = Assertable.AssertionStatus.VALID;
        }
        return this.currentStatus;
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.testStep.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.testStep.getDefaultAssertableContent();
    }

    @Override
    public Interface getInterface() {
        return this.testStep.getInterface();
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep.getModelItem();
    }

    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        return this.testStep.moveAssertion(ix, offset);
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.testStep.removeAssertion(assertion);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.testStep.removeAssertionsListener(listener);
    }

    public void setResponse(JdbcResponse response) {
        this.response = response;
    }

    @Override
    public JdbcResponse getResponse() {
        return this.response;
    }

    public void initIcons() {
        if (this.validRequestIcon == null) {
            this.validRequestIcon = UISupport.createImageIcon("/valid_jdbc_request.gif");
        }
        if (this.failedRequestIcon == null) {
            this.failedRequestIcon = UISupport.createImageIcon("/invalid_jdbc_request.gif");
        }
        if (this.unknownRequestIcon == null) {
            this.unknownRequestIcon = UISupport.createImageIcon("/unknown_jdbc_request.gif");
        }
        if (this.disabledRequestIcon == null) {
            this.disabledRequestIcon = UISupport.createImageIcon("/disabled_jdbc_request.gif");
        }
        this.setIconAnimator(new RequestIconAnimator<JdbcRequest>(this, "/jdbc_request.gif", "/exec_jdbc_request", 4, "gif"));
    }

    protected RequestIconAnimator<?> initIconAnimator() {
        return new RequestIconAnimator<JdbcRequest>(this, "/jdbc_request.gif", "/exec_jdbc_request", 4, "gif");
    }

    public RequestIconAnimator<?> getIconAnimator() {
        return this.iconAnimator;
    }

    public void setIconAnimator(RequestIconAnimator<?> iconAnimator) {
        if (this.iconAnimator != null) {
            this.removeSubmitListener(this.iconAnimator);
        }
        this.iconAnimator = iconAnimator;
        this.addSubmitListener(this.iconAnimator);
    }

    @Override
    public ImageIcon getIcon() {
        if (this.forLoadTest || UISupport.isHeadless() || this.getIconAnimator() == null) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && testMonitor.hasRunningLoadTest(this.getTestStep().getTestCase())) {
            return this.disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return this.validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return this.failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return this.unknownRequestIcon;
            }
        }
        return icon;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        this.getTestStep().setIcon(icon);
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestIconAnimator<T extends JdbcRequest>
    extends ModelItemIconAnimator<T>
    implements SubmitListener {
        public RequestIconAnimator(T modelItem, String baseIcon, String animIconRoot, int iconCount, String iconExtension) {
            super(modelItem, baseIcon, animIconRoot, iconCount, iconExtension);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (this.isEnabled() && submit.getRequest() == this.getTarget()) {
                this.start();
            }
            return true;
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }
}

