/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.impl.wsdl.mock.MockRunnerManager;
import com.eviware.soapui.impl.wsdl.mock.MockRunnerManagerException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.TestCase;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MockRunnerManagerImpl
implements MockRunnerManager {
    private static final Logger log = Logger.getLogger(MockRunnerManagerImpl.class);
    private static Map<String, MockRunnerManager> managers = new HashMap<String, MockRunnerManager>();
    private Map<String, WsdlMockService> mockServices = new HashMap<String, WsdlMockService>();
    private Vector<WsdlMockRunner> mockRunners = new Vector();
    private Project project;

    private MockRunnerManagerImpl(Project project) {
        this.project = project;
    }

    public static MockRunnerManager getInstance(TestCase testCase) {
        if (managers.containsKey(testCase.getId())) {
            return managers.get(testCase.getId());
        }
        MockRunnerManagerImpl manager = new MockRunnerManagerImpl(testCase.getTestSuite().getProject());
        managers.put(testCase.getId(), manager);
        return manager;
    }

    public WsdlMockService getMockService(int port, String path) {
        String key = port + path;
        WsdlMockService service = this.mockServices.get(key);
        if (service == null) {
            MockServiceConfig mockServiceConfig = MockServiceConfig.Factory.newInstance();
            mockServiceConfig.setPath(path);
            mockServiceConfig.setPort(port);
            mockServiceConfig.setName(port + ":" + path);
            service = new WsdlMockService(this.project, mockServiceConfig);
            this.mockServices.put(key, service);
        }
        return service;
    }

    public void start() throws MockRunnerManagerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting MockRunnerManager");
        }
        for (WsdlMockService mockService : this.mockServices.values()) {
            try {
                this.mockRunners.add(mockService.start());
            }
            catch (Exception e) {
                throw new MockRunnerManagerException("Failed to create a WsdlMockRunner", e);
            }
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping MockRunnerManager");
        }
        for (WsdlMockRunner runner : this.mockRunners) {
            try {
                runner.stop();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        this.mockServices.clear();
        this.mockRunners.clear();
    }

    public boolean isStarted() {
        for (WsdlMockRunner runner : this.mockRunners) {
            if (!runner.isRunning()) continue;
            return true;
        }
        return false;
    }
}

