/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.strategy;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.AbstractLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.ComponentBag;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class ThreadCountChangeLoadStrategy
extends AbstractLoadStrategy {
    private static final Logger log = Logger.getLogger(ThreadCountChangeLoadStrategy.class);
    private static final int DEFAULT_END_THREAD_COUNT = 10;
    private static final int DEFAULT_START_THREAD_COUNT = 1;
    public static final String STRATEGY_TYPE = "Thread";
    private int startThreadCount = 1;
    private int endThreadCount = 10;
    private JPanel configPanel;
    private ComponentBag stateDependantComponents = new ComponentBag();
    private SpinnerNumberModel startThreadCountSpinnerNumberModel;
    private JSpinner startThreadCountSpinner;
    private SpinnerNumberModel endThreadCountSpinnerNumberModel;
    private JSpinner endThreadCountSpinner;

    public ThreadCountChangeLoadStrategy(XmlObject config, WsdlLoadTest loadTest) {
        super(STRATEGY_TYPE, loadTest);
        if (config != null) {
            XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config);
            this.startThreadCount = reader.readInt("startThreadCount", 1);
            this.endThreadCount = reader.readInt("endThreadCount", 10);
        }
    }

    public XmlObject getConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("startThreadCount", this.startThreadCount);
        builder.add("endThreadCount", this.endThreadCount);
        return builder.finish();
    }

    public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        super.beforeLoadTest(loadTestRunner, context);
        this.stateDependantComponents.setEnabled(false);
        WsdlLoadTest wsdlLoadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
        wsdlLoadTest.setThreadCount(this.startThreadCount);
    }

    public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        this.stateDependantComponents.setEnabled(true);
    }

    public boolean allowThreadCountChangeDuringRun() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        WsdlLoadTestRunner runner = (WsdlLoadTestRunner)loadTestRunner;
        float progress = runner.getProgress();
        if ((int)progress != -1) {
            WsdlLoadTest wsdlLoadTest;
            WsdlLoadTest wsdlLoadTest2 = wsdlLoadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
            synchronized (wsdlLoadTest2) {
                int newThreadCount = (int)((double)this.startThreadCount + ((double)(progress * (float)(this.endThreadCount - this.startThreadCount)) + 0.5));
                if ((long)newThreadCount != wsdlLoadTest.getThreadCount() && newThreadCount <= this.endThreadCount) {
                    log.debug((Object)("Changing threadcount to " + newThreadCount + ", progress = " + progress));
                    wsdlLoadTest.setThreadCount(newThreadCount);
                }
            }
        }
    }

    public JComponent getConfigurationPanel() {
        if (this.configPanel == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.startThreadCountSpinnerNumberModel = new SpinnerNumberModel(this.startThreadCount, 1, 10000, 1);
            this.startThreadCountSpinner = new JSpinner(this.startThreadCountSpinnerNumberModel);
            UISupport.setPreferredHeight(this.startThreadCountSpinner, 18);
            this.startThreadCountSpinner.setToolTipText("Sets the initial thread-count");
            this.startThreadCountSpinnerNumberModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ThreadCountChangeLoadStrategy.this.startThreadCount = ThreadCountChangeLoadStrategy.this.startThreadCountSpinnerNumberModel.getNumber().intValue();
                    ThreadCountChangeLoadStrategy.this.notifyConfigurationChanged();
                }
            });
            builder.addFixed((JComponent)new JLabel("Start Threads"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.startThreadCountSpinner);
            builder.addRelatedGap();
            this.endThreadCountSpinnerNumberModel = new SpinnerNumberModel(this.endThreadCount, 1, 10000, 1);
            this.endThreadCountSpinner = new JSpinner(this.endThreadCountSpinnerNumberModel);
            UISupport.setPreferredHeight(this.endThreadCountSpinner, 18);
            this.endThreadCountSpinner.setToolTipText("Sets the final thread-count");
            this.endThreadCountSpinnerNumberModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ThreadCountChangeLoadStrategy.this.endThreadCount = ThreadCountChangeLoadStrategy.this.endThreadCountSpinnerNumberModel.getNumber().intValue();
                    ThreadCountChangeLoadStrategy.this.notifyConfigurationChanged();
                }
            });
            builder.addFixed((JComponent)new JLabel("End Threads"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.endThreadCountSpinner);
            this.configPanel = builder.getPanel();
            this.stateDependantComponents.add(this.startThreadCountSpinner);
            this.stateDependantComponents.add(this.endThreadCountSpinner);
        }
        return this.configPanel;
    }

    public static class Factory
    implements LoadStrategyFactory {
        public String getType() {
            return ThreadCountChangeLoadStrategy.STRATEGY_TYPE;
        }

        public LoadStrategy build(XmlObject config, WsdlLoadTest loadTest) {
            return new ThreadCountChangeLoadStrategy(config, loadTest);
        }

        public LoadStrategy create(WsdlLoadTest loadTest) {
            return new ThreadCountChangeLoadStrategy(null, loadTest);
        }
    }
}

