/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.content;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Content;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.support.TypeInferrer;
import com.eviware.soapui.inferredSchema.SimpleContentConfig;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

public class SimpleContent
implements Content {
    private Schema schema;
    private XmlAnySimpleType simpleType;

    public SimpleContent(Schema schema, String initialValue) {
        this.schema = schema;
        this.simpleType = TypeInferrer.inferSimpleType(initialValue);
    }

    public SimpleContent(Schema schema, XmlAnySimpleType initialType) {
        this.schema = schema;
        this.simpleType = initialType;
    }

    public SimpleContent(SimpleContentConfig xml, Schema schema) {
        this.schema = schema;
        this.simpleType = TypeInferrer.getType(xml.getTypeName());
    }

    public SimpleContentConfig save() {
        SimpleContentConfig xml = SimpleContentConfig.Factory.newInstance();
        xml.setTypeName(this.simpleType.schemaType().getName().getLocalPart());
        return xml;
    }

    public Content validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        String value = "";
        if (cursor.isStart()) {
            throw new XmlException("Unsupported!");
        }
        if (!cursor.isEnd()) {
            value = cursor.getTextValue();
        }
        if (!TypeInferrer.validateSimpleType(value, this.simpleType)) {
            XmlAnySimpleType newSimpleType = TypeInferrer.expandTypeForValue(value, this.simpleType);
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.TYPE, new QName(this.schema.getNamespace(), context.getAttribute("typeName")), context.getPath(), "Illegal value.")) {
                this.simpleType = newSimpleType;
            } else {
                throw new XmlException("Illegal content!");
            }
        }
        return this;
    }

    public String toString(String attrs) {
        if (this.simpleType == null) {
            return attrs;
        }
        String xsdns = this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema");
        StringBuilder s = new StringBuilder("<" + xsdns + ":simpleContent><" + xsdns + ":extension base=\"" + xsdns + ":" + this.simpleType.schemaType().getName().getLocalPart() + "\">");
        s.append(attrs);
        s.append("</" + xsdns + ":extension></" + xsdns + ":simpleContent>");
        return s.toString();
    }
}

