/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.panels;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.EndpointsComboBoxModel;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.support.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpRequestDesktopPanel<T extends ModelItem, T2 extends AbstractHttpRequestInterface<?>>
extends ModelItemDesktopPanel<T>
implements SubmitListener {
    private static final Logger log = Logger.getLogger(AbstractHttpRequestDesktopPanel.class);
    private JComponent endpointComponent;
    private JButton submitButton;
    private JButton cancelButton;
    private EndpointsComboBoxModel endpointsModel;
    private JEditorStatusBarWithProgress statusBar;
    private JButton splitButton;
    private Submit submit;
    private JSplitPane requestSplitPane;
    private MoveFocusAction moveFocusAction;
    private ClosePanelAction closePanelAction = new ClosePanelAction();
    private T2 request;
    private ModelItemXmlEditor<?, ?> requestEditor;
    private ModelItemXmlEditor<?, ?> responseEditor;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private JToggleButton tabsButton;
    private boolean responseHasFocus;
    private SubmitAction submitAction;
    private boolean hasClosed;

    public AbstractHttpRequestDesktopPanel(T modelItem, T2 request) {
        super(modelItem);
        this.request = request;
        this.init(request);
        try {
            if (request.getAttachmentCount() > 0 && request.getOperation() != null) {
                request.getOperation().getInterface().getDefinitionContext().loadIfNecessary();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init(T2 request) {
        this.endpointsModel = new EndpointsComboBoxModel((AbstractHttpRequestInterface<?>)request);
        request.addSubmitListener(this);
        request.addPropertyChangeListener(this);
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AbstractHttpRequestDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AbstractHttpRequestDesktopPanel.this.responseHasFocus) {
                    AbstractHttpRequestDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    AbstractHttpRequestDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
    }

    public final T2 getRequest() {
        return this.request;
    }

    public final ModelItemXmlEditor<?, ?> getRequestEditor() {
        return this.requestEditor;
    }

    public final ModelItemXmlEditor<?, ?> getResponseEditor() {
        return this.responseEditor;
    }

    public Submit getSubmit() {
        return this.submit;
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    public JEditorStatusBarWithProgress getStatusBar() {
        return this.statusBar;
    }

    protected JComponent buildContent() {
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.submitAction = new SubmitAction();
        this.submitButton = AbstractHttpRequestDesktopPanel.createActionButton(this.submitAction, true);
        this.submitButton.setEnabled(this.request.getEndpoint() != null && this.request.getEndpoint().trim().length() > 0);
        this.cancelButton = AbstractHttpRequestDesktopPanel.createActionButton(new CancelAction(), false);
        this.splitButton = AbstractHttpRequestDesktopPanel.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.moveFocusAction = new MoveFocusAction();
        this.requestEditor = this.buildRequestEditor();
        this.responseEditor = this.buildResponseEditor();
        this.requestTabs = new JTabbedPane();
        this.requestTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ix = AbstractHttpRequestDesktopPanel.this.requestTabs.getSelectedIndex();
                        if (ix == 0) {
                            AbstractHttpRequestDesktopPanel.this.requestEditor.requestFocus();
                        } else if (ix == 1 && AbstractHttpRequestDesktopPanel.this.responseEditor != null) {
                            AbstractHttpRequestDesktopPanel.this.responseEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        if (this.request.getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Request", this.requestEditor);
            if (this.responseEditor != null) {
                this.requestTabs.addTab("Response", this.responseEditor);
            }
            this.splitButton.setEnabled(false);
            this.tabsButton.setSelected(true);
            return this.requestTabPanel;
        }
        this.requestSplitPane.setTopComponent(this.requestEditor);
        this.requestSplitPane.setBottomComponent(this.responseEditor);
        this.requestSplitPane.setDividerLocation(0.5);
        return this.requestSplitPane;
    }

    public SubmitAction getSubmitAction() {
        return this.submitAction;
    }

    protected abstract ModelItemXmlEditor<?, ?> buildResponseEditor();

    protected abstract ModelItemXmlEditor<?, ?> buildRequestEditor();

    protected JComponent buildToolbar() {
        this.endpointComponent = this.buildEndpointComponent();
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(this.submitButton);
        this.insertButtons(toolbar);
        toolbar.add(this.cancelButton);
        if (this.endpointComponent != null) {
            toolbar.addSeparator();
            toolbar.add(this.endpointComponent);
        }
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
        return toolbar;
    }

    protected JComponent buildEndpointComponent() {
        JComboBox endpointCombo = new JComboBox(this.endpointsModel);
        endpointCombo.addPropertyChangeListener(this);
        endpointCombo.setToolTipText(this.endpointsModel.getSelectedItem().toString());
        return UISupport.addTooltipListener(endpointCombo, "- no endpoint set for request -");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("endpoint")) {
            this.submitButton.setEnabled(this.submit == null && StringUtils.hasContent(this.request.getEndpoint()));
        }
        super.propertyChange(evt);
    }

    public JButton getSubmitButton() {
        return this.submitButton;
    }

    protected abstract String getHelpUrl();

    protected abstract void insertButtons(JXToolBar var1);

    @Override
    public void setEnabled(boolean enabled) {
        if (this.endpointComponent != null) {
            this.endpointComponent.setEnabled(enabled);
        }
        this.requestEditor.setEditable(enabled);
        if (this.responseEditor != null) {
            this.responseEditor.setEditable(enabled);
        }
        this.submitButton.setEnabled(enabled && this.request.hasEndpoint());
        this.statusBar.setIndeterminate(!enabled);
    }

    protected abstract Submit doSubmit() throws Request.SubmitException;

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        if (submit.getRequest() != this.request) {
            return true;
        }
        if (this.getModelItem().getSettings().getBoolean(UISettings.AUTO_VALIDATE_REQUEST)) {
            boolean result = this.requestEditor.saveDocument(true);
            if (!result && this.getModelItem().getSettings().getBoolean(UISettings.ABORT_ON_INVALID_REQUEST)) {
                this.statusBar.setInfo("Cancelled request due to invalid content");
                return false;
            }
        } else if (this.requestEditor != null) {
            this.requestEditor.saveDocument(false);
        }
        this.setEnabled(false);
        this.cancelButton.setEnabled(this.submit != null);
        return true;
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        String requestName;
        if (submit.getRequest() != this.request) {
            return;
        }
        Submit.Status status = submit.getStatus();
        HttpResponse response = (HttpResponse)submit.getResponse();
        if (status == Submit.Status.FINISHED) {
            this.request.setResponse(response, context);
        }
        if (this.hasClosed) {
            this.request.removeSubmitListener(this);
            return;
        }
        this.cancelButton.setEnabled(false);
        this.setEnabled(true);
        String message = null;
        String infoMessage = null;
        String string = requestName = this.request.getOperation() == null ? this.request.getName() : this.request.getOperation().getInterface().getName() + "." + this.request.getOperation().getName() + ":" + this.request.getName();
        if (status == Submit.Status.CANCELED) {
            message = "CANCELED";
            infoMessage = "[" + requestName + "] - CANCELED";
        } else if (status == Submit.Status.ERROR || response == null) {
            message = "Error getting response; " + submit.getError();
            infoMessage = "Error getting response for [" + requestName + "]; " + submit.getError();
        } else {
            message = "response time: " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            infoMessage = "Got response for [" + requestName + "] in " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            if (!this.splitButton.isEnabled()) {
                this.requestTabs.setSelectedIndex(1);
            }
            this.responseEditor.requestFocus();
        }
        this.logMessages(message, infoMessage);
        if (this.getModelItem().getSettings().getBoolean(UISettings.AUTO_VALIDATE_RESPONSE)) {
            this.responseEditor.getSourceEditor().validate();
        }
        this.submit = null;
    }

    protected void logMessages(String message, String infoMessage) {
        log.info((Object)infoMessage);
        this.statusBar.setInfo(message);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (canCancel) {
            if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
                Boolean retVal = UISupport.confirmOrCancel("Cancel request before closing?", "Closing window");
                if (retVal == null) {
                    return false;
                }
                if (retVal.booleanValue() && this.submit.getStatus() == Submit.Status.RUNNING) {
                    this.submit.cancel();
                }
                this.hasClosed = true;
            } else {
                this.request.removeSubmitListener(this);
            }
        } else if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
            this.submit.cancel();
            this.hasClosed = true;
        } else {
            this.request.removeSubmitListener(this);
        }
        this.request.removePropertyChangeListener(this);
        this.requestEditor.saveDocument(false);
        if (this.responseEditor != null) {
            this.responseEditor.getParent().remove(this.responseEditor);
        }
        this.requestEditor.getParent().remove(this.requestEditor);
        this.requestSplitPane.removeAll();
        return this.release();
    }

    @Override
    protected boolean release() {
        this.endpointsModel.release();
        this.requestEditor.release();
        if (this.responseEditor != null) {
            this.responseEditor.release();
        }
        return super.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return this.request.dependsOn(modelItem);
    }

    public void setContent(JComponent content) {
        this.add((Component)content, "Center");
    }

    public void removeContent(JComponent content) {
        this.remove(content);
    }

    protected void onSubmit() {
        if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
            if (UISupport.confirm("Cancel current request?", "Submit Request")) {
                this.submit.cancel();
            } else {
                return;
            }
        }
        try {
            this.submit = this.doSubmit();
        }
        catch (Request.SubmitException e1) {
            SoapUI.logError(e1);
        }
    }

    protected void onCancel() {
        if (this.submit == null) {
            return;
        }
        this.cancelButton.setEnabled(false);
        this.submit.cancel();
        this.setEnabled(true);
        this.submit = null;
    }

    public boolean isHasClosed() {
        return this.hasClosed;
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractHttpRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractHttpRequestDesktopPanel.this.splitButton.setEnabled(false);
                AbstractHttpRequestDesktopPanel.this.removeContent(AbstractHttpRequestDesktopPanel.this.requestSplitPane);
                AbstractHttpRequestDesktopPanel.this.setContent(AbstractHttpRequestDesktopPanel.this.requestTabPanel);
                AbstractHttpRequestDesktopPanel.this.requestTabs.addTab("Request", AbstractHttpRequestDesktopPanel.this.requestEditor);
                if (AbstractHttpRequestDesktopPanel.this.responseEditor != null) {
                    AbstractHttpRequestDesktopPanel.this.requestTabs.addTab("Response", AbstractHttpRequestDesktopPanel.this.responseEditor);
                }
                if (AbstractHttpRequestDesktopPanel.this.responseHasFocus) {
                    AbstractHttpRequestDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    AbstractHttpRequestDesktopPanel.this.requestEditor.requestFocus();
                }
            } else {
                int selectedIndex = AbstractHttpRequestDesktopPanel.this.requestTabs.getSelectedIndex();
                AbstractHttpRequestDesktopPanel.this.splitButton.setEnabled(true);
                AbstractHttpRequestDesktopPanel.this.removeContent(AbstractHttpRequestDesktopPanel.this.requestTabPanel);
                AbstractHttpRequestDesktopPanel.this.setContent(AbstractHttpRequestDesktopPanel.this.requestSplitPane);
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setTopComponent(AbstractHttpRequestDesktopPanel.this.requestEditor);
                if (AbstractHttpRequestDesktopPanel.this.responseEditor != null) {
                    AbstractHttpRequestDesktopPanel.this.requestSplitPane.setBottomComponent(AbstractHttpRequestDesktopPanel.this.responseEditor);
                }
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0 || AbstractHttpRequestDesktopPanel.this.responseEditor == null) {
                    AbstractHttpRequestDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AbstractHttpRequestDesktopPanel.this.responseEditor.requestFocus();
                }
            }
            AbstractHttpRequestDesktopPanel.this.revalidate();
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private MoveFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractHttpRequestDesktopPanel.this.requestEditor.hasFocus()) {
                AbstractHttpRequestDesktopPanel.this.responseEditor.requestFocus();
            } else {
                AbstractHttpRequestDesktopPanel.this.requestEditor.requestFocus();
            }
        }
    }

    private class ClosePanelAction
    extends AbstractAction {
        private ClosePanelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel((ModelItem)AbstractHttpRequestDesktopPanel.this.getModelItem());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.gif"));
            this.putValue("ShortDescription", "Aborts ongoing request");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt X"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractHttpRequestDesktopPanel.this.onCancel();
        }
    }

    public class SubmitAction
    extends AbstractAction {
        public SubmitAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Submit request to specified endpoint URL");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractHttpRequestDesktopPanel.this.onSubmit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ResultAreaFocusListener
    implements FocusListener {
        private final XmlSourceEditorView<?> sourceEditor;

        public ResultAreaFocusListener(XmlSourceEditorView<?> editor) {
            this.sourceEditor = editor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AbstractHttpRequestDesktopPanel.this.responseHasFocus = true;
            AbstractHttpRequestDesktopPanel.this.statusBar.setTarget(this.sourceEditor.getInputArea());
            if (!AbstractHttpRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractHttpRequestDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (AbstractHttpRequestDesktopPanel.this.request.getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (AbstractHttpRequestDesktopPanel.this.requestSplitPane.getUI() instanceof SoapUISplitPaneUI && ((SoapUISplitPaneUI)AbstractHttpRequestDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged() || AbstractHttpRequestDesktopPanel.this.request.getResponse() == null) {
                return;
            }
            int pos = AbstractHttpRequestDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AbstractHttpRequestDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class InputAreaFocusListener
    implements FocusListener {
        private final XmlSourceEditorView<?> sourceEditor;

        public InputAreaFocusListener(XmlSourceEditorView<?> editor) {
            this.sourceEditor = editor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            AbstractHttpRequestDesktopPanel.this.responseHasFocus = false;
            AbstractHttpRequestDesktopPanel.this.statusBar.setTarget(this.sourceEditor.getInputArea());
            if (!AbstractHttpRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractHttpRequestDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            if (AbstractHttpRequestDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (AbstractHttpRequestDesktopPanel.this.requestSplitPane.getUI() instanceof SoapUISplitPaneUI && ((SoapUISplitPaneUI)AbstractHttpRequestDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractHttpRequestDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AbstractHttpRequestDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AbstractHttpRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractHttpResponseMessageEditor<T3 extends XmlDocument>
    extends ResponseMessageXmlEditor<T2, T3> {
        private JXEditTextArea inputArea;
        private ResultAreaFocusListener resultAreaFocusListener;
        final /* synthetic */ AbstractHttpRequestDesktopPanel this$0;

        public AbstractHttpResponseMessageEditor(T3 document) {
            this.this$0 = var1_1;
            super(document, ((AbstractHttpRequestDesktopPanel)var1_1).request);
            XmlSourceEditorView editor = this.getSourceEditor();
            this.inputArea = editor.getInputArea();
            if (this.inputArea != null) {
                this.resultAreaFocusListener = var1_1.new ResultAreaFocusListener(editor);
                this.inputArea.addFocusListener(this.resultAreaFocusListener);
                this.inputArea.getInputHandler().addKeyBinding("A+ENTER", ((AbstractHttpRequestDesktopPanel)var1_1).submitButton.getAction());
                this.inputArea.getInputHandler().addKeyBinding("A+X", ((AbstractHttpRequestDesktopPanel)var1_1).cancelButton.getAction());
                this.inputArea.getInputHandler().addKeyBinding("AC+TAB", ((AbstractHttpRequestDesktopPanel)var1_1).moveFocusAction);
                this.inputArea.getInputHandler().addKeyBinding("C+F4", ((AbstractHttpRequestDesktopPanel)var1_1).closePanelAction);
            }
        }

        @Override
        public void release() {
            super.release();
            if (this.inputArea != null) {
                this.inputArea.removeFocusListener(this.resultAreaFocusListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractHttpRequestMessageEditor<T3 extends XmlDocument>
    extends RequestMessageXmlEditor<T2, T3> {
        private InputAreaFocusListener inputAreaFocusListener;
        private JXEditTextArea inputArea;
        final /* synthetic */ AbstractHttpRequestDesktopPanel this$0;

        public AbstractHttpRequestMessageEditor(T3 document) {
            this.this$0 = var1_1;
            super(document, ((AbstractHttpRequestDesktopPanel)var1_1).request);
            XmlSourceEditorView editor = this.getSourceEditor();
            if (editor != null) {
                this.inputArea = editor.getInputArea();
                this.inputArea.getInputHandler().addKeyBinding("A+ENTER", ((AbstractHttpRequestDesktopPanel)var1_1).submitButton.getAction());
                this.inputArea.getInputHandler().addKeyBinding("A+X", ((AbstractHttpRequestDesktopPanel)var1_1).cancelButton.getAction());
                this.inputArea.getInputHandler().addKeyBinding("AC+TAB", ((AbstractHttpRequestDesktopPanel)var1_1).moveFocusAction);
                this.inputArea.getInputHandler().addKeyBinding("C+F4", ((AbstractHttpRequestDesktopPanel)var1_1).closePanelAction);
                this.inputAreaFocusListener = var1_1.new InputAreaFocusListener(editor);
                this.inputArea.addFocusListener(this.inputAreaFocusListener);
            }
        }

        @Override
        public void release() {
            super.release();
            if (this.inputArea != null) {
                this.inputArea.removeFocusListener(this.inputAreaFocusListener);
            }
        }
    }
}

