/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class ResponseXmlDocument
extends AbstractXmlDocument
implements PropertyChangeListener {
    private final WsdlRequest request;
    private boolean settingResponse;

    public ResponseXmlDocument(WsdlRequest request) {
        this.request = request;
        request.addPropertyChangeListener(this);
    }

    public String getXml() {
        WsdlResponse response = this.request.getResponse();
        return response == null ? null : response.getContentAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXml(String xml) {
        WsdlResponse response = this.request.getResponse();
        if (response != null) {
            try {
                this.settingResponse = true;
                response.setResponseContent(xml);
            }
            finally {
                this.settingResponse = false;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object newResponse;
        Object oldResponse;
        if (this.settingResponse) {
            return;
        }
        if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_PROPERTY)) {
            oldResponse = (Response)evt.getOldValue();
            newResponse = (Response)evt.getNewValue();
            this.fireXmlChanged(oldResponse == null ? null : oldResponse.getContentAsString(), newResponse == null ? null : newResponse.getContentAsString());
        }
        if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_CONTENT_PROPERTY)) {
            oldResponse = (String)evt.getOldValue();
            newResponse = (String)evt.getNewValue();
            this.fireXmlChanged((String)oldResponse, (String)newResponse);
        }
    }

    public SchemaTypeSystem getTypeSystem() {
        WsdlInterface iface = this.request.getOperation().getInterface();
        WsdlContext wsdlContext = iface.getWsdlContext();
        try {
            return wsdlContext.getSchemaTypeSystem();
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
            return XmlBeans.getBuiltinTypeSystem();
        }
    }

    public void release() {
        this.request.removePropertyChangeListener(this);
    }
}

