/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestParameterConfig;
import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeansRestParamsTestPropertyHolder
implements RestParamsPropertyHolder {
    private RestParametersConfig config;
    private List<RestParamProperty> properties = new ArrayList<RestParamProperty>();
    private Map<String, RestParamProperty> propertyMap = new HashMap<String, RestParamProperty>();
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();
    private ModelItem modelItem;
    private Properties overrideProperties;
    private String propertiesLabel = "Test Properties";

    public XmlBeansRestParamsTestPropertyHolder(ModelItem modelItem, RestParametersConfig config) {
        this.modelItem = modelItem;
        this.config = config;
        for (RestParameterConfig propertyConfig : config.getParameterList()) {
            this.addProperty(propertyConfig, false);
        }
    }

    protected XmlBeansRestParamProperty addProperty(RestParameterConfig propertyConfig, boolean notify) {
        XmlBeansRestParamProperty propertiesStepProperty = new XmlBeansRestParamProperty(propertyConfig);
        this.properties.add(propertiesStepProperty);
        this.propertyMap.put(propertiesStepProperty.getName().toUpperCase(), propertiesStepProperty);
        if (notify) {
            this.firePropertyAdded(propertiesStepProperty.getName());
        }
        return propertiesStepProperty;
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public XmlBeansRestParamProperty addProperty(String name) {
        RestParameterConfig propertyConfig = this.config.addNewParameter();
        propertyConfig.setName(name);
        return this.addProperty(propertyConfig, true);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.propertyMap.get(name.toUpperCase());
    }

    @Override
    public String[] getPropertyNames() {
        String[] result = new String[this.properties.size()];
        for (int c = 0; c < this.properties.size(); ++c) {
            result[c] = this.properties.get(c).getName();
        }
        return result;
    }

    @Override
    public String getPropertyValue(String name) {
        RestParamProperty property = this.getProperty(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        RestParamProperty property = this.getProperty(propertyName);
        if (property != null) {
            int ix = this.properties.indexOf(property);
            this.propertyMap.remove(propertyName.toUpperCase());
            this.properties.remove(ix);
            this.firePropertyRemoved(propertyName);
            this.config.removeParameter(ix);
            return property;
        }
        return null;
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        RestParamProperty property = this.getProperty(name);
        if (property != null) {
            property.setValue(value);
        } else {
            this.addProperty(name).setValue(value);
        }
    }

    @Override
    public void resetValues() {
        for (RestParamProperty property : this.properties) {
            ((XmlBeansRestParamProperty)property).reset();
        }
    }

    public void resetPropertiesConfig(RestParametersConfig config) {
        this.config = config;
        for (int c = 0; c < config.sizeOfParameterArray(); ++c) {
            ((XmlBeansRestParamProperty)this.properties.get(c)).setConfig(config.getParameterArray(c));
        }
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        if (this.getProperty(newName) != null) {
            return false;
        }
        RestParamProperty property = this.getProperty(name);
        if (property == null) {
            return false;
        }
        property.setName(newName);
        this.firePropertyRenamed(name, newName);
        return true;
    }

    @Override
    public int getPropertyIndex(String name) {
        for (int c = 0; c < this.properties.size(); ++c) {
            if (!this.properties.get(c).getName().equals(name)) continue;
            return c;
        }
        return -1;
    }

    @Override
    public void saveTo(Properties props) {
        int cnt = 0;
        for (RestParamProperty p : this.properties) {
            String name = p.getName();
            String value = p.getValue();
            if (value == null) {
                value = "";
            }
            props.setProperty(name, value);
            ++cnt;
        }
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.properties.get(index);
    }

    @Override
    public List<TestProperty> getPropertyList() {
        ArrayList<TestProperty> result = new ArrayList<TestProperty>();
        for (RestParamProperty property : this.properties) {
            result.add(property);
        }
        return result;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
        for (RestParamProperty property : this.propertyMap.values()) {
            result.put(property.getName(), property);
        }
        return result;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyMap.containsKey(name.toUpperCase());
    }

    public int addPropertiesFromFile(String propFile) {
        if (!StringUtils.hasContent(propFile)) {
            return 0;
        }
        try {
            InputStream input = null;
            File file = new File(propFile);
            if (file.exists()) {
                input = new FileInputStream(file);
            } else if (propFile.toLowerCase().startsWith("http://") || propFile.toLowerCase().startsWith("https://")) {
                UrlWsdlLoader loader = new UrlWsdlLoader(propFile, this.getModelItem());
                loader.setUseWorker(false);
                input = loader.load();
            }
            if (input != null) {
                if (this.overrideProperties == null) {
                    this.overrideProperties = new Properties();
                }
                int sz = this.overrideProperties.size();
                this.overrideProperties.load(input);
                for (Object key : this.overrideProperties.keySet()) {
                    String name = key.toString();
                    if (this.hasProperty(name)) continue;
                    this.addProperty(name);
                }
                return this.overrideProperties.size() - sz;
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return 0;
    }

    @Override
    public ModelItem getModelItem() {
        return this.modelItem;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList result = new ArrayList();
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        RestParamProperty property = this.getProperty(propertyName);
        int ix = this.properties.indexOf(property);
        if (ix == targetIndex) {
            return;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        String value = property.getValue();
        String defaultValue = property.getDefaultValue();
        String style = property.getStyle().name();
        String[] options = property.getOptions();
        boolean required = property.getRequired();
        QName type = property.getType();
        String description = property.getDescription();
        boolean disableUrlEncoding = property.isDisableUrlEncoding();
        this.config.removeParameter(ix);
        RestParameterConfig propertyConfig = null;
        if (targetIndex < this.properties.size()) {
            this.properties.add(targetIndex, this.properties.remove(ix));
            propertyConfig = this.config.insertNewParameter(targetIndex);
        } else {
            this.properties.add(this.properties.remove(ix));
            propertyConfig = this.config.addNewParameter();
        }
        propertyConfig.setName(propertyName);
        propertyConfig.setValue(value);
        propertyConfig.setDefault(defaultValue);
        propertyConfig.setStyle(RestParameterConfig.Style.Enum.forString((String)style));
        propertyConfig.setOptionArray(options);
        propertyConfig.setRequired(required);
        propertyConfig.setType(type);
        propertyConfig.setDescription(description);
        propertyConfig.setDisableUrlEncoding(disableUrlEncoding);
        this.resetPropertiesConfig(this.config);
        if (targetIndex > this.properties.size()) {
            targetIndex = this.properties.size();
        }
        this.firePropertyMoved(propertyName, ix, targetIndex);
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.removeProperty(this.getPropertyAt(0).getName());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hasProperty((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.propertyMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        HashSet<Map.Entry<String, TestProperty>> result = new HashSet<Map.Entry<String, TestProperty>>();
        for (RestParamProperty p : this.propertyMap.values()) {
            result.add(new HashMapEntry<String, RestParamProperty>(p.getName(), p));
        }
        return result;
    }

    @Override
    public RestParamProperty get(Object key) {
        return this.getProperty((String)key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(Arrays.asList(this.getPropertyNames()));
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        XmlBeansRestParamProperty result = this.addProperty(key);
        result.setValue(value.getValue());
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        for (TestProperty testProperty : m.values()) {
            this.addProperty(testProperty.getName()).setValue(testProperty.getValue());
        }
    }

    @Override
    public TestProperty remove(Object key) {
        return this.removeProperty((String)key);
    }

    @Override
    public int size() {
        return this.propertyMap.size();
    }

    @Override
    public Collection<TestProperty> values() {
        ArrayList<TestProperty> result = new ArrayList<TestProperty>();
        result.addAll(this.propertyMap.values());
        return result;
    }

    @Override
    public String getPropertiesLabel() {
        return this.propertiesLabel;
    }

    @Override
    public void setPropertiesLabel(String propertiesLabel) {
        this.propertiesLabel = propertiesLabel;
    }

    public XmlObject getConfig() {
        return this.config;
    }

    public void addParameters(RestParamsPropertyHolder params) {
        for (int c = 0; c < params.getPropertyCount(); ++c) {
            RestParamProperty property = params.getPropertyAt(c);
            if (this.hasProperty(property.getName())) continue;
            this.addParameter(property);
        }
    }

    @Override
    public void addParameter(RestParamProperty property) {
        XmlBeansRestParamProperty prop = this.addProperty(property.getName());
        prop.setStyle(property.getStyle());
        prop.setValue(property.getValue());
        prop.setType(property.getType());
        prop.setDefaultValue(property.getDefaultValue());
        prop.setDescription(property.getDescription());
        prop.setOptions(property.getOptions());
        prop.setRequired(property.getRequired());
    }

    public void release() {
    }

    public RestParamProperty addProperty(XmlBeansRestParamProperty prop) {
        RestParameterConfig propertyConfig = (RestParameterConfig)this.config.addNewParameter().set((XmlObject)prop.getConfig());
        return this.addProperty(propertyConfig, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashMapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public HashMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    public class XmlBeansRestParamProperty
    implements RestParamProperty {
        private RestParameterConfig propertyConfig;
        private PropertyChangeSupport propertySupport;

        public XmlBeansRestParamProperty(RestParameterConfig propertyConfig) {
            this.propertyConfig = propertyConfig;
            this.propertySupport = new PropertyChangeSupport(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(propertyName, listener);
        }

        public void setConfig(RestParameterConfig restParameterConfig) {
            this.propertyConfig = restParameterConfig;
        }

        public String getName() {
            return this.propertyConfig.getName();
        }

        public void setName(String name) {
            String oldName = this.getName();
            this.propertyConfig.setName(name);
            XmlBeansRestParamsTestPropertyHolder.this.propertyMap.remove(oldName.toUpperCase());
            XmlBeansRestParamsTestPropertyHolder.this.propertyMap.put(name.toUpperCase(), this);
            XmlBeansRestParamsTestPropertyHolder.this.firePropertyRenamed(oldName, name);
        }

        public String getDescription() {
            return this.propertyConfig.getDescription();
        }

        public void setDescription(String description) {
            String old = this.getDescription();
            this.propertyConfig.setDescription(description);
            this.propertySupport.firePropertyChange("description", old, description);
        }

        public RestParamsPropertyHolder.ParameterStyle getStyle() {
            if (this.propertyConfig.xgetStyle() == null) {
                this.propertyConfig.setStyle(RestParameterConfig.Style.QUERY);
            }
            return RestParamsPropertyHolder.ParameterStyle.valueOf(this.propertyConfig.getStyle().toString());
        }

        public void setStyle(RestParamsPropertyHolder.ParameterStyle style) {
            RestParamsPropertyHolder.ParameterStyle old = this.getStyle();
            this.propertyConfig.setStyle(RestParameterConfig.Style.Enum.forString((String)style.name()));
            this.propertySupport.firePropertyChange("style", (Object)old, (Object)style);
        }

        public String getValue() {
            if (XmlBeansRestParamsTestPropertyHolder.this.overrideProperties != null && XmlBeansRestParamsTestPropertyHolder.this.overrideProperties.containsKey(this.getName())) {
                return XmlBeansRestParamsTestPropertyHolder.this.overrideProperties.getProperty(this.getName());
            }
            return this.propertyConfig.getValue() == null ? "" : this.propertyConfig.getValue();
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            this.propertyConfig.setValue(value);
            if (XmlBeansRestParamsTestPropertyHolder.this.overrideProperties != null && XmlBeansRestParamsTestPropertyHolder.this.overrideProperties.containsKey(this.getName())) {
                XmlBeansRestParamsTestPropertyHolder.this.overrideProperties.remove(this.getName());
                if (XmlBeansRestParamsTestPropertyHolder.this.overrideProperties.isEmpty()) {
                    XmlBeansRestParamsTestPropertyHolder.this.overrideProperties = null;
                }
            }
            XmlBeansRestParamsTestPropertyHolder.this.firePropertyValueChanged(this.getName(), oldValue, value);
        }

        public boolean isReadOnly() {
            return false;
        }

        public ModelItem getModelItem() {
            return XmlBeansRestParamsTestPropertyHolder.this.modelItem;
        }

        public String getDefaultValue() {
            return this.propertyConfig.isSetDefault() ? this.propertyConfig.getDefault() : "";
        }

        public String[] getOptions() {
            return this.propertyConfig.getOptionList().toArray(new String[this.propertyConfig.sizeOfOptionArray()]);
        }

        public boolean getRequired() {
            return this.propertyConfig.getRequired();
        }

        public boolean isDisableUrlEncoding() {
            return this.propertyConfig.getDisableUrlEncoding();
        }

        public void setDisableUrlEncoding(boolean encode) {
            boolean old = this.isDisableUrlEncoding();
            if (old == encode) {
                return;
            }
            this.propertyConfig.setDisableUrlEncoding(encode);
            this.propertySupport.firePropertyChange("disableUrlEncoding", old, encode);
        }

        public QName getType() {
            return this.propertyConfig.isSetType() ? this.propertyConfig.getType() : XmlString.type.getName();
        }

        public void setOptions(String[] arg0) {
            String[] old = this.getOptions();
            this.propertyConfig.setOptionArray(arg0);
            this.propertySupport.firePropertyChange("options", old, arg0);
        }

        public void setRequired(boolean arg0) {
            boolean old = this.getRequired();
            if (old == arg0) {
                return;
            }
            this.propertyConfig.setRequired(arg0);
            this.propertySupport.firePropertyChange("required", old, arg0);
        }

        public void setType(QName arg0) {
            this.propertyConfig.setType(arg0);
        }

        public void setDefaultValue(String default1) {
            String old = default1;
            this.propertyConfig.setDefault(default1);
            this.propertySupport.firePropertyChange("defaultValue", old, default1);
        }

        public RestParameterConfig getConfig() {
            return this.propertyConfig;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XmlBeansRestParamProperty) {
                return this.propertyConfig.toString().equals(((XmlBeansRestParamProperty)obj).propertyConfig.toString());
            }
            return super.equals(obj);
        }

        public void reset() {
            this.setValue(this.getDefaultValue());
        }
    }
}

