/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestRequestParamsPropertyHolder
implements RestParamsPropertyHolder,
TestPropertyListener {
    private StringToStringMap values;
    private RestParamsPropertyHolder methodParams;
    private ModelItem modelItem;
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();
    private Map<RestParamProperty, InternalRestParamProperty> wrappers = new HashMap<RestParamProperty, InternalRestParamProperty>();

    public RestRequestParamsPropertyHolder(RestParamsPropertyHolder methodParams, ModelItem modelItem, StringToStringMap values) {
        this.methodParams = methodParams;
        this.modelItem = modelItem;
        this.values = values;
        methodParams.addTestPropertyListener(this);
    }

    public void reset(RestParamsPropertyHolder methodParams, StringToStringMap values) {
        this.methodParams = methodParams;
        this.values = values;
        this.clearWrappers();
    }

    private void clearWrappers() {
        for (InternalRestParamProperty property : this.wrappers.values()) {
            property.release();
        }
        this.wrappers.clear();
    }

    @Override
    public RestParamProperty addProperty(String name) {
        return this.methodParams.addProperty(name);
    }

    @Override
    public void addParameter(RestParamProperty prop) {
        this.methodParams.addParameter(prop);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        for (String key : this.getPropertyNames()) {
            String oldValue = this.getPropertyValue(key);
            this.values.put(key, "");
            this.firePropertyValueChanged(key, oldValue, "");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.methodParams.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value) || this.methodParams.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TestProperty>> entrySet() {
        Set<Map.Entry<String, TestProperty>> entrySet = this.methodParams.entrySet();
        for (Map.Entry entry : entrySet) {
            entry.setValue(this.getWrapper((RestParamProperty)entry.getValue()));
        }
        return entrySet;
    }

    @Override
    public RestParamProperty get(Object key) {
        if (!this.methodParams.containsKey(key)) {
            return null;
        }
        return this.getWrapper(this.methodParams.get(key));
    }

    @Override
    public ModelItem getModelItem() {
        return this.methodParams.getModelItem();
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        Map<String, TestProperty> map = this.methodParams.getProperties();
        for (String key : map.keySet()) {
            map.put(key, this.getWrapper((RestParamProperty)map.get(key)));
        }
        return map;
    }

    @Override
    public String getPropertiesLabel() {
        return this.methodParams.getPropertiesLabel();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        if (!this.methodParams.hasProperty(name)) {
            return null;
        }
        return this.getWrapper(this.methodParams.getProperty(name));
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        if (this.methodParams.getPropertyCount() <= index) {
            return null;
        }
        return this.getWrapper(this.methodParams.getPropertyAt(index));
    }

    @Override
    public int getPropertyCount() {
        return this.methodParams.getPropertyCount();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        return this.methodParams.getPropertyExpansions();
    }

    @Override
    public int getPropertyIndex(String name) {
        return this.methodParams.getPropertyIndex(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.methodParams.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.values.containsKey(name) ? (String)this.values.get(name) : this.methodParams.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.methodParams.hasProperty(name);
    }

    @Override
    public boolean isEmpty() {
        return this.methodParams.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.methodParams.keySet();
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.methodParams.moveProperty(propertyName, targetIndex);
    }

    @Override
    public TestProperty put(String key, TestProperty value) {
        if (value.getValue() != null) {
            this.values.put(key, value.getValue());
        } else {
            this.values.remove(key);
        }
        return this.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends TestProperty> m) {
        for (Map.Entry<? extends String, ? extends TestProperty> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public TestProperty remove(Object key) {
        this.values.remove(key);
        return this.methodParams.get(key);
    }

    @Override
    public RestParamProperty removeProperty(String propertyName) {
        this.values.remove(propertyName);
        return this.methodParams.getProperty(propertyName);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        this.values.put(newName, this.values.get(name));
        this.values.remove(name);
        return this.methodParams.renameProperty(name, newName);
    }

    @Override
    public void resetValues() {
        this.values.clear();
    }

    public void release() {
        this.methodParams.removeTestPropertyListener(this);
        this.clearWrappers();
    }

    @Override
    public void saveTo(Properties props) {
        int count = this.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            String value;
            RestParamProperty p = this.getPropertyAt(i);
            String name = p.getName();
            String string = value = this.values.containsKey(name) ? (String)this.values.get(name) : p.getValue();
            if (value == null) {
                value = "";
            }
            props.setProperty(name, value);
        }
    }

    @Override
    public void setPropertiesLabel(String propertiesLabel) {
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (value == null) {
            this.values.remove(name);
        } else {
            this.values.put(name, value);
        }
    }

    @Override
    public int size() {
        return this.methodParams.size();
    }

    @Override
    public Collection<TestProperty> values() {
        ArrayList<TestProperty> ret = new ArrayList<TestProperty>();
        for (TestProperty p : this.methodParams.values()) {
            ret.add(this.getWrapper((RestParamProperty)p));
        }
        return ret;
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    private RestParamProperty getWrapper(RestParamProperty key) {
        if (!this.wrappers.containsKey(key)) {
            this.wrappers.put(key, new InternalRestParamProperty(key));
        }
        return this.wrappers.get(key);
    }

    @Override
    public void propertyAdded(String name) {
        this.firePropertyAdded(name);
    }

    @Override
    public void propertyMoved(String name, int oldIndex, int newIndex) {
        this.firePropertyMoved(name, oldIndex, newIndex);
    }

    @Override
    public void propertyRemoved(String name) {
        this.values.remove(name);
        this.firePropertyRemoved(name);
    }

    @Override
    public void propertyRenamed(String oldName, String newName) {
        if (this.values.containsKey(oldName)) {
            this.values.put(newName, this.values.get(oldName));
            this.values.remove(oldName);
        }
        this.firePropertyRenamed(oldName, newName);
    }

    @Override
    public void propertyValueChanged(String name, String oldValue, String newValue) {
        if (!this.values.containsKey(name)) {
            this.firePropertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.methodParams.getPropertyList();
    }

    public class InternalRestParamProperty
    implements RestParamProperty,
    PropertyChangeListener {
        private RestParamProperty overriddenProp;
        private PropertyChangeSupport propertySupport;

        public InternalRestParamProperty(RestParamProperty override) {
            this.overriddenProp = override;
            this.overriddenProp.addPropertyChangeListener(this);
            this.propertySupport = new PropertyChangeSupport(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.addPropertyChangeListener(propertyName, listener);
        }

        public boolean isDisableUrlEncoding() {
            return this.overriddenProp.isDisableUrlEncoding();
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertySupport.removePropertyChangeListener(propertyName, listener);
        }

        public void setDisableUrlEncoding(boolean encode) {
        }

        public void setName(String name) {
        }

        public String getDefaultValue() {
            return this.overriddenProp.getDefaultValue();
        }

        public String getDescription() {
            return this.overriddenProp.getDescription();
        }

        public ModelItem getModelItem() {
            return RestRequestParamsPropertyHolder.this.modelItem;
        }

        public String getName() {
            return this.overriddenProp.getName();
        }

        public QName getType() {
            return this.overriddenProp.getType();
        }

        public String getValue() {
            if (RestRequestParamsPropertyHolder.this.values.containsKey(this.getName()) && RestRequestParamsPropertyHolder.this.values.get(this.getName()) != null) {
                return (String)RestRequestParamsPropertyHolder.this.values.get(this.getName());
            }
            return this.getDefaultValue();
        }

        public boolean isReadOnly() {
            return this.overriddenProp.isReadOnly();
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            if (this.getDefaultValue() != null && this.getDefaultValue().equals(value)) {
                value = null;
            }
            if (value == null) {
                RestRequestParamsPropertyHolder.this.values.remove(this.getName());
            } else {
                RestRequestParamsPropertyHolder.this.values.put(this.getName(), value);
            }
            RestRequestParamsPropertyHolder.this.firePropertyValueChanged(this.getName(), oldValue, this.getValue());
        }

        public String[] getOptions() {
            return this.overriddenProp.getOptions();
        }

        public boolean getRequired() {
            return this.overriddenProp.getRequired();
        }

        public RestParamsPropertyHolder.ParameterStyle getStyle() {
            return this.overriddenProp.getStyle();
        }

        public void setDefaultValue(String default1) {
        }

        public void setDescription(String description) {
        }

        public void setOptions(String[] arg0) {
        }

        public void setRequired(boolean arg0) {
        }

        public void setStyle(RestParamsPropertyHolder.ParameterStyle style) {
        }

        public void setType(QName arg0) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.propertySupport.firePropertyChange(evt);
        }

        public void release() {
            this.overriddenProp.removePropertyChangeListener(this);
            this.overriddenProp = null;
            this.propertySupport = null;
        }
    }
}

