/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JTabbedPane;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestResourceDesktopPanel
extends ModelItemDesktopPanel<RestResource> {
    private JUndoableTextField pathTextField;
    private boolean updating;
    private RestParamsTable paramsTable;

    public RestResourceDesktopPanel(RestResource modelItem) {
        super(modelItem);
        this.add(this.buildToolbar(), "North");
        this.add(this.buildContent(), "Center");
    }

    private Component buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        this.paramsTable = new RestParamsTable(((RestResource)this.getModelItem()).getParams(), true);
        tabs.addTab("Resource Parameters", this.paramsTable);
        return UISupport.createTabPanel(tabs, false);
    }

    @Override
    public String getTitle() {
        return this.getName((RestResource)this.getModelItem());
    }

    public RestParamsTable getParamsTable() {
        return this.paramsTable;
    }

    @Override
    protected boolean release() {
        this.paramsTable.release();
        return super.release();
    }

    private String getName(RestResource modelItem) {
        if (modelItem.getParentResource() != null) {
            return this.getName(modelItem.getParentResource()) + "/" + modelItem.getName();
        }
        return modelItem.getName();
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(RestResourceDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("NewRestMethodAction", this.getModelItem(), null, "/create_empty_method.gif"), true));
        toolbar.addSeparator();
        this.pathTextField = new JUndoableTextField(((RestResource)this.getModelItem()).getPath(), 20);
        this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!RestResourceDesktopPanel.this.updating) {
                    RestResourceDesktopPanel.this.updating = true;
                    ((RestResource)RestResourceDesktopPanel.this.getModelItem()).setPath(this.getText(document));
                    RestResourceDesktopPanel.this.updating = false;
                }
            }
        });
        this.pathTextField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                for (String p : RestUtils.extractTemplateParams(((RestResource)RestResourceDesktopPanel.this.getModelItem()).getPath())) {
                    if (((RestResource)RestResourceDesktopPanel.this.getModelItem()).hasProperty(p) || !UISupport.confirm("Add template parameter [" + p + "] to resource?", "Add Parameter")) continue;
                    RestParamProperty property = ((RestResource)RestResourceDesktopPanel.this.getModelItem()).addProperty(p);
                    property.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                    String value = UISupport.prompt("Specify default value for parameter [" + p + "]", "Add Parameter", "");
                    if (value == null) continue;
                    property.setDefaultValue(value);
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        toolbar.addLabeledFixed("Resource Path", this.pathTextField);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/rest/resources.html")));
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ((RestResource)this.getModelItem()).dependsOn(modelItem);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("path") && !this.updating) {
            this.updating = true;
            this.pathTextField.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
        super.propertyChange(evt);
    }
}

