/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.AnnotatedSettingsPrefs;
import com.eviware.soapui.actions.EditorPrefs;
import com.eviware.soapui.actions.GlobalPropertiesPrefs;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.actions.ProxyPrefs;
import com.eviware.soapui.actions.ToolsPrefs;
import com.eviware.soapui.actions.UIPrefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.settings.SecuritySettings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SwingConfigurationDialogImpl;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class SoapUIPreferencesAction
extends AbstractAction {
    public static final String GLOBAL_SECURITY_SETTINGS = "Global Security Settings";
    public static final String WS_I_SETTINGS = "WS-I Settings";
    public static final String WSDL_SETTINGS = "WSDL Settings";
    public static final String UI_SETTINGS = "UI Settings";
    public static final String EDITOR_SETTINGS = "Editor Settings";
    public static final String PROXY_SETTINGS = "Proxy Settings";
    public static final String HTTP_SETTINGS = "HTTP Settings";
    public static final String SSL_SETTINGS = "SSL Settings";
    public static final String INTEGRATED_TOOLS = "Tools";
    public static final String WSA_SETTINGS = "WS-A Settings";
    private SwingConfigurationDialogImpl dialog;
    private JTabbedPane tabs;
    private List<Prefs> prefs = new ArrayList<Prefs>();
    private static SoapUIPreferencesAction instance;

    public SoapUIPreferencesAction() {
        super("Preferences");
        this.putValue("ShortDescription", "Sets global soapUI preferences");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt P"));
        this.addPrefs(new AnnotatedSettingsPrefs(HttpSettings.class, HTTP_SETTINGS));
        this.addPrefs(new ProxyPrefs(PROXY_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(SSLSettings.class, SSL_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(WsdlSettings.class, WSDL_SETTINGS));
        this.addPrefs(new UIPrefs(UI_SETTINGS));
        this.addPrefs(new EditorPrefs(EDITOR_SETTINGS));
        this.addPrefs(new ToolsPrefs(INTEGRATED_TOOLS));
        this.addPrefs(new AnnotatedSettingsPrefs(WSISettings.class, WS_I_SETTINGS));
        this.addPrefs(new GlobalPropertiesPrefs());
        this.addPrefs(new AnnotatedSettingsPrefs(SecuritySettings.class, GLOBAL_SECURITY_SETTINGS));
        this.addPrefs(new AnnotatedSettingsPrefs(WsaSettings.class, WSA_SETTINGS));
        instance = this;
    }

    public void addPrefs(Prefs pref) {
        this.prefs.add(pref);
    }

    public static SoapUIPreferencesAction getInstance() {
        if (instance == null) {
            instance = new SoapUIPreferencesAction();
        }
        return instance;
    }

    public void actionPerformed(ActionEvent e) {
        this.show(HTTP_SETTINGS);
    }

    public boolean show(String initialTab) {
        int ix;
        if (this.dialog == null) {
            this.buildDialog();
        }
        Settings settings = SoapUI.getSettings();
        for (Prefs pref : this.prefs) {
            pref.setFormValues(settings);
        }
        if (initialTab != null && (ix = this.tabs.indexOfTab(initialTab)) != -1) {
            this.tabs.setSelectedIndex(ix);
        }
        if (this.dialog.show(new StringToStringMap())) {
            for (Prefs pref : this.prefs) {
                pref.getFormValues(settings);
            }
            return true;
        }
        return false;
    }

    private void buildDialog() {
        this.dialog = new SwingConfigurationDialogImpl("soapUI Preferences", "http://www.soapui.org/userguide/preferences.html", "Set global soapUI settings", UISupport.OPTIONS_ICON);
        this.tabs = new JTabbedPane();
        this.tabs.setTabLayoutPolicy(1);
        this.tabs.setTabPlacement(2);
        for (Prefs pref : this.prefs) {
            this.tabs.addTab(pref.getTitle(), pref.getForm().getPanel());
        }
        this.dialog.setContent(UISupport.createTabPanel(this.tabs, false));
    }
}

