/*
 * Decompiled with CFR 0.152.
 */
package com.sop.services.wsdl;

import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.SoapUIException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

public class ParseWsdl {
    public static String parseWsdl(String wsdl) {
        String response = "";
        try {
            WsdlProject project = new WsdlProject();
            WsdlInterfaceFactory.importWsdl((WsdlProject)project, (String)wsdl, (boolean)true);
            response = String.valueOf(response) + "<wsdl location=\"" + wsdl + "\">";
            Iterator it = project.getInterfaceList().iterator();
            Interface inter = null;
            while (it.hasNext()) {
                inter = (Interface)it.next();
                List operations = inter.getOperationList();
                for (WsdlOperation op : operations) {
                    response = String.valueOf(response) + "\n<" + op.getName() + " soapAction=\"" + op.getAction() + "\" endpoint=\"" + inter.getEndpoints()[0] + "\"><![CDATA[";
                    response = String.valueOf(response) + op.createRequest(true);
                    response = String.valueOf(response) + "]]></" + op.getName() + ">";
                }
            }
            response = String.valueOf(response) + "</wsdl>";
        }
        catch (XmlException e) {
            response = "<exception>XML Exeption Occured (" + e.getMessage() + ")</exception>";
            e.printStackTrace();
        }
        catch (IOException e) {
            response = "<exception>IO Exeption Occured (" + e.getMessage() + ")</exception>";
            e.printStackTrace();
        }
        catch (SoapUIException e) {
            response = "<exception>SOAPUI Exeption Occured (" + e.getMessage() + ")</exception>";
            e.printStackTrace();
        }
        catch (Exception e) {
            response = "<exception>Exeption Occured (" + e.getMessage() + ")</exception>";
            e.printStackTrace();
        }
        System.out.println("Request for wsdl (" + wsdl + ")");
        System.out.println("Returning " + response);
        return response;
    }

    public static void parseWsdl(String wsdl, String fileName) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(fileName);
        PrintStream p = new PrintStream(out);
        p.print(ParseWsdl.parseWsdl(wsdl));
        p.close();
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("This requires 2 arguments (wsdl, filename). Exiting");
            System.exit(0);
        }
        try {
            ParseWsdl.parseWsdl(args[0], args[1]);
        }
        catch (FileNotFoundException exp) {
            System.out.println("No File Exception");
        }
    }
}

